/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.auth;

import com.aliyun.emr.fs.s3.auth.AuthUtils;
import com.aliyun.emr.fs.s3.auth.CredentialInitializationException;
import com.aliyun.emr.fs.s3.auth.JindoCredentialsProvider;
import com.aliyun.emr.fs.s3.auth.NoAuthWithException;
import com.aliyun.emr.fs.s3.auth.S3Credentials;
import com.aliyun.emr.fs.s3.auth.S3CredentialsProvider;
import com.aliyun.emr.shade.google_guava.annotations.VisibleForTesting;
import com.aliyun.emr.shade.google_guava.base.Preconditions;
import com.aliyun.emr.utils.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class S3CredentialProviderList
implements S3CredentialsProvider,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(S3CredentialProviderList.class);
    public static final String NO_CREDENTIAL_PROVIDERS = "No Credential Providers";
    static final String CREDENTIALS_REQUESTED_WHEN_CLOSED = "S3Credentials requested after provider list was closed";
    private final List<S3CredentialsProvider> providers = new ArrayList<S3CredentialsProvider>(1);
    private boolean reuseLastProvider = true;
    private S3CredentialsProvider lastProvider;
    private final AtomicInteger refCount = new AtomicInteger(1);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private String name = "";

    public S3CredentialProviderList() {
    }

    public S3CredentialProviderList(Collection<S3CredentialsProvider> providers) {
        this.providers.addAll(providers);
    }

    public S3CredentialProviderList(String name, S3CredentialsProvider ... providerArgs) {
        this.setName(name);
        Collections.addAll(this.providers, providerArgs);
    }

    public JindoCredentialsProvider getJindoCredentialsProvider() throws IOException {
        JindoCredentialsProvider result;
        List resultList = this.providers.stream().filter(provider -> provider instanceof JindoCredentialsProvider).map(provider -> (JindoCredentialsProvider)provider).collect(Collectors.toList());
        if (resultList.size() >= 1) {
            result = (JindoCredentialsProvider)resultList.get(0);
            if (resultList.size() > 1) {
                throw new IOException("ERROR: more than one password less credential provider configured: " + Arrays.toString(resultList.stream().map(r -> r.getClass()).toArray()) + ". Only support one password less credential provider.");
            }
            if (!result.equals(this.providers.get(this.providers.size() - 1))) {
                throw new IOException("ERROR: the password less credential provider\uff1a" + result.getClass() + " should be configured at last.");
            }
        } else {
            throw new IOException("ERROR: without login secrets configured.");
        }
        return result;
    }

    public void setName(String name) {
        this.name = !name.isEmpty() && !name.endsWith(": ") ? name + ": " : name;
    }

    public void add(S3CredentialsProvider p) {
        this.providers.add(p);
    }

    public void addAll(S3CredentialProviderList other) {
        this.providers.addAll(other.providers);
    }

    @Override
    public void refresh() {
        if (this.isClosed()) {
            return;
        }
        for (S3CredentialsProvider provider : this.providers) {
            provider.refresh();
        }
    }

    @Override
    public S3Credentials getCredentials() {
        if (this.isClosed()) {
            LOG.warn(CREDENTIALS_REQUESTED_WHEN_CLOSED);
            throw new NoAuthWithException(this.name + CREDENTIALS_REQUESTED_WHEN_CLOSED);
        }
        this.checkNotEmpty();
        if (this.reuseLastProvider && this.lastProvider != null) {
            return this.lastProvider.getCredentials();
        }
        CredentialInitializationException lastException = null;
        for (S3CredentialsProvider provider : this.providers) {
            try {
                S3Credentials credentials = provider.getCredentials();
                Preconditions.checkNotNull(credentials, "Null s3Credentials returned by %s", provider);
                if (credentials.getAccessKeyId() == null || credentials.getAccessKeySecret() == null) continue;
                this.lastProvider = provider;
                LOG.debug("Using s3Credentials from {}", (Object)provider);
                return credentials;
            }
            catch (CredentialInitializationException e) {
                lastException = e;
                LOG.debug("No credentials provided by {}: {}", new Object[]{provider, e.toString(), e});
            }
        }
        String message = this.name + "No S3Credentials provided by " + this.listProviderNames();
        if (lastException != null) {
            message = message + ": " + lastException;
        }
        LOG.debug(message);
        return null;
    }

    @VisibleForTesting
    List<S3CredentialsProvider> getProviders() {
        return this.providers;
    }

    public void checkNotEmpty() {
        if (this.providers.isEmpty()) {
            throw new NoAuthWithException(this.name + NO_CREDENTIAL_PROVIDERS);
        }
    }

    public String listProviderNames() {
        return this.providers.stream().map(provider -> provider.getClass().getSimpleName() + ' ').collect(Collectors.joining());
    }

    public String toString() {
        return "S3CredentialProviderList[" + this.name + "refcount= " + this.refCount.get() + ": [" + StringUtils.join(this.providers, ", ") + ']' + (this.lastProvider != null ? " last provider: " + this.lastProvider : "");
    }

    public synchronized S3CredentialProviderList share() {
        Preconditions.checkState(!this.closed.get(), "Provider list is closed");
        this.refCount.incrementAndGet();
        return this;
    }

    @VisibleForTesting
    public int getRefCount() {
        return this.refCount.get();
    }

    @VisibleForTesting
    public boolean isClosed() {
        return this.closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        S3CredentialProviderList s3CredentialProviderList = this;
        synchronized (s3CredentialProviderList) {
            if (this.closed.get()) {
                return;
            }
            int remainder = this.refCount.decrementAndGet();
            if (remainder != 0) {
                LOG.debug("Not closing {}", (Object)this);
                return;
            }
            LOG.debug("Closing {}", (Object)this);
            this.closed.set(true);
        }
        for (S3CredentialsProvider p : this.providers) {
            if (p instanceof Closeable) {
                IOUtils.closeStream((Closeable)((Closeable)((Object)p)));
                continue;
            }
            if (!(p instanceof AutoCloseable)) continue;
            AuthUtils.closeAutocloseables(LOG, (AutoCloseable)((Object)p));
        }
    }

    public int size() {
        return this.providers.size();
    }
}

