/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.auth;

import com.aliyun.emr.fs.s3.auth.AbstractSessionCredentialsProvider;
import com.aliyun.emr.fs.s3.auth.AuthUtils;
import com.aliyun.emr.fs.s3.auth.MarshalledCredentialBinding;
import com.aliyun.emr.fs.s3.auth.MarshalledCredentials;
import com.aliyun.emr.fs.s3.auth.NoCredentialsException;
import com.aliyun.emr.fs.s3.auth.S3Credentials;
import com.aliyun.emr.fs.s3.auth.S3CredentialsProvider;
import com.aliyun.emr.fs.s3.common.AbstractJindoShimsFileSystem;
import java.io.IOException;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TemporaryS3CredentialsProvider
extends AbstractSessionCredentialsProvider {
    public static final String NAME = "com.aliyun.emr.fs.s3.auth.TemporaryS3CredentialsProvider";
    public static final String COMPONENT = "Session credentials in Hadoop configuration";

    public TemporaryS3CredentialsProvider(Configuration conf, S3CredentialsProvider.CredentialType type) {
        this(null, conf, type);
    }

    public TemporaryS3CredentialsProvider(@Nullable URI uri, Configuration conf, S3CredentialsProvider.CredentialType type) {
        super(uri, conf, type);
    }

    @Override
    protected S3Credentials createCredentials(Configuration config) throws IOException {
        MarshalledCredentials creds;
        if (this.getType() == S3CredentialsProvider.CredentialType.S3) {
            creds = MarshalledCredentialBinding.fromFileSystem(this.getUri(), config, AbstractJindoShimsFileSystem.class);
        } else if (this.getType() == S3CredentialsProvider.CredentialType.OTS) {
            creds = new MarshalledCredentials(AuthUtils.getPassword(config, "fs.jfs.cache.ots.accessKeyId", null, ""), AuthUtils.getPassword(config, "fs.jfs.cache.ots.accessKeySecret", null, ""), AuthUtils.getPassword(config, "fs.jfs.cache.ots.securityToken", null, ""));
        } else if (this.getType() == S3CredentialsProvider.CredentialType.JFS) {
            creds = new MarshalledCredentials(AuthUtils.getPassword(config, "fs.jfs.accessKeyId", null, ""), AuthUtils.getPassword(config, "fs.jfs.accessKeySecret", null, ""), AuthUtils.getPassword(config, "fs.jfs.securityToken", null, ""));
        } else {
            throw new IOException("WARNING: wrong credential type: " + this.getType().name());
        }
        MarshalledCredentials.CredentialTypeRequired sessionOnly = MarshalledCredentials.CredentialTypeRequired.SessionOnly;
        if (!creds.isValid(sessionOnly)) {
            throw new NoCredentialsException(COMPONENT);
        }
        return MarshalledCredentialBinding.toCredentials(creds, sessionOnly, COMPONENT);
    }
}

