/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.auth.delegation;

import com.aliyun.emr.fs.common.DurationInfo;
import com.aliyun.emr.fs.s3.auth.S3CredentialProviderList;
import com.aliyun.emr.fs.s3.auth.delegation.AbstractDTService;
import com.aliyun.emr.fs.s3.auth.delegation.AbstractS3TokenIdentifier;
import com.aliyun.emr.fs.s3.auth.delegation.DelegationTokenIOException;
import com.aliyun.emr.fs.s3.auth.delegation.S3DelegationTokens;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDelegationTokenBinding
extends AbstractDTService {
    private final Text kind;
    private SecretManager<AbstractS3TokenIdentifier> secretManager;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDelegationTokenBinding.class);

    protected AbstractDelegationTokenBinding(String name, Text kind) {
        super(name);
        this.kind = Objects.requireNonNull(kind);
    }

    public Text getKind() {
        return this.kind;
    }

    public Text getOwnerText() {
        return new Text(this.getOwner().getUserName());
    }

    public S3DelegationTokens.TokenIssuingPolicy getTokenIssuingPolicy() {
        return S3DelegationTokens.TokenIssuingPolicy.RequestNewToken;
    }

    public Token<AbstractS3TokenIdentifier> createDelegationToken(Text renewer) throws IOException {
        this.requireServiceStarted();
        AbstractS3TokenIdentifier tokenIdentifier = this.createTokenIdentifier(renewer);
        if (tokenIdentifier != null) {
            Token token = new Token((TokenIdentifier)tokenIdentifier, this.secretManager);
            token.setKind(this.getKind());
            LOG.debug("Created token {} with token identifier {}", (Object)token, (Object)tokenIdentifier);
            return token;
        }
        return null;
    }

    public abstract AbstractS3TokenIdentifier createTokenIdentifier(Text var1) throws IOException;

    protected <T extends AbstractS3TokenIdentifier> T convertTokenIdentifier(AbstractS3TokenIdentifier identifier, Class<T> expectedClass) throws DelegationTokenIOException {
        if (!((Object)((Object)identifier)).getClass().equals(expectedClass)) {
            throw new DelegationTokenIOException("Delegation token is wrong class; expected a token identifier of type " + expectedClass + " but got " + ((Object)((Object)identifier)).getClass() + " and kind " + identifier.getKind());
        }
        return (T)((Object)identifier);
    }

    public abstract S3CredentialProviderList deployUnbonded() throws IOException;

    public abstract S3CredentialProviderList bindToTokenIdentifier(AbstractS3TokenIdentifier var1) throws IOException;

    public abstract AbstractS3TokenIdentifier createEmptyIdentifier();

    public String toString() {
        return super.toString() + " token kind = " + this.getKind();
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        this.secretManager = this.createSecretMananger();
    }

    public String getDescription() {
        return "Token binding " + this.getKind().toString();
    }

    protected SecretManager<AbstractS3TokenIdentifier> createSecretMananger() throws IOException {
        return new TokenSecretManager();
    }

    public String getUserAgentField() {
        return "";
    }

    protected static byte[] getSecretManagerPasssword() {
        return "non-password".getBytes(Charset.forName("UTF-8"));
    }

    protected class TokenSecretManager
    extends SecretManager<AbstractS3TokenIdentifier> {
        protected TokenSecretManager() {
        }

        protected byte[] createPassword(AbstractS3TokenIdentifier identifier) {
            return AbstractDelegationTokenBinding.getSecretManagerPasssword();
        }

        public byte[] retrievePassword(AbstractS3TokenIdentifier identifier) throws SecretManager.InvalidToken {
            return AbstractDelegationTokenBinding.getSecretManagerPasssword();
        }

        public AbstractS3TokenIdentifier createIdentifier() {
            try (DurationInfo ignored = new DurationInfo(LOG, true, "Creating Delegation Token Identifier", new Object[0]);){
                AbstractS3TokenIdentifier abstractS3TokenIdentifier = AbstractDelegationTokenBinding.this.createEmptyIdentifier();
                return abstractS3TokenIdentifier;
            }
        }
    }
}

