/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.commit.magic;

import com.aliyun.emr.fs.s3.commit.magic.MagicCommitPaths;
import com.aliyun.emr.fs.s3.commit.magic.PathCommitException;
import com.aliyun.emr.fs.s3.commit.magic.ValidationFailure;
import com.aliyun.emr.fs.s3.common.AbstractJindoShimsFileSystem;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommitUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CommitUtils.class);

    private CommitUtils() {
    }

    public static void verifyIsMagicCommitPath(AbstractJindoShimsFileSystem fs, Path path, String UUID2) throws PathCommitException {
        CommitUtils.verifyIsMagicCommitFS(fs);
        if (!MagicCommitPaths.isMagicCommitPath(path, UUID2)) {
            throw new PathCommitException(path, "Path does not represent a magic-commit path");
        }
    }

    public static void verifyIsMagicCommitFS(AbstractJindoShimsFileSystem fs) throws PathCommitException {
        if (!fs.isMagicCommitEnabled().booleanValue()) {
            String fsUri = fs.getUri().toString();
            LOG.error("{}: {}:\n{}", new Object[]{"Filesystem does not have support for 'magic' committer enabled in configuration option fs.s3.committer.magic.enabled", fsUri, fs});
            throw new PathCommitException(fsUri, "Filesystem does not have support for 'magic' committer enabled in configuration option fs.s3.committer.magic.enabled");
        }
    }

    public static void verifyIsCacheModeFS(FileSystem fs, Path path) throws PathCommitException {
        if (!(fs instanceof AbstractJindoShimsFileSystem) || !((AbstractJindoShimsFileSystem)fs).isCacheMode().booleanValue()) {
            throw new PathCommitException(path, "Output path is not on an S3 Filesystem");
        }
    }

    public static void validateCollectionClass(Iterable it, Class classname) throws ValidationFailure {
        for (Object o : it) {
            ValidationFailure.verify(o.getClass().equals(classname), "Collection element is not a %s: %s", classname, o.getClass());
        }
    }

    public static void writeStringToOutputStream(DataOutputStream dataOutputStream, String data) throws IOException {
        CommitUtils.writeBytesToOutputStream(dataOutputStream, data.getBytes());
    }

    public static String readStringFromInputStream(DataInputStream dataInputStream) throws IOException {
        return new String(CommitUtils.readBytesFromInputStream(dataInputStream));
    }

    public static void writeBytesToOutputStream(DataOutputStream dataOutputStream, byte[] bytes) throws IOException {
        dataOutputStream.writeInt(bytes.length);
        dataOutputStream.write(bytes);
    }

    public static byte[] readBytesFromInputStream(DataInputStream dataInputStream) throws IOException {
        int byteLength = dataInputStream.readInt();
        byte[] bytes = new byte[byteLength];
        dataInputStream.readFully(bytes);
        return bytes;
    }
}

