/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.commit.magic;

import com.aliyun.emr.fs.s3.commit.magic.CommitUtils;
import com.aliyun.emr.fs.s3.commit.magic.PersistentCommitData;
import com.aliyun.emr.fs.s3.commit.magic.ValidationFailure;
import com.aliyun.emr.fs.s3.internal.s3native.S3PartInfo;
import com.aliyun.emr.shade.google_guava.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SinglePendingCommit
extends PersistentCommitData
implements Iterable<S3PartInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(SinglePendingCommit.class);
    private static final long serialVersionUID = 65537L;
    private int version = 1;
    private String filename;
    private String uri = "";
    private String uploadId;
    private String bucket;
    private String destinationKey;
    private long created;
    private long saved;
    private String date;
    private String jobId = "";
    private String taskId = "";
    private String text = "";
    private List<S3PartInfo> partInfoList;
    private Map<String, String> extraData = new HashMap<String, String>(0);
    private long length;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SinglePendingCommit load(FileSystem fs, Path path) throws IOException {
        try (FSDataInputStream dataInputStream = fs.open(path);){
            SinglePendingCommit instance = SinglePendingCommit.fromDataInputStream((DataInputStream)dataInputStream);
            instance.filename = path.toString();
            instance.validate();
            SinglePendingCommit singlePendingCommit = instance;
            return singlePendingCommit;
        }
        catch (IOException e) {
            LOG.error("Failed to deserialize SingePendingCommit.", (Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SinglePendingCommit fromBytes(byte[] bytes) throws IOException {
        try (DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(bytes));){
            SinglePendingCommit singlePendingCommit = SinglePendingCommit.fromDataInputStream(inputStream);
            return singlePendingCommit;
        }
        catch (IOException e) {
            LOG.error("Failed to deserialize SingePendingCommit.", (Throwable)e);
            throw e;
        }
    }

    private static SinglePendingCommit fromDataInputStream(DataInputStream dataInputStream) throws IOException {
        SinglePendingCommit instance = new SinglePendingCommit();
        instance.version = dataInputStream.readInt();
        instance.uri = CommitUtils.readStringFromInputStream(dataInputStream);
        instance.bucket = CommitUtils.readStringFromInputStream(dataInputStream);
        instance.destinationKey = CommitUtils.readStringFromInputStream(dataInputStream);
        instance.uploadId = CommitUtils.readStringFromInputStream(dataInputStream);
        instance.created = dataInputStream.readLong();
        instance.saved = dataInputStream.readLong();
        instance.date = CommitUtils.readStringFromInputStream(dataInputStream);
        instance.jobId = CommitUtils.readStringFromInputStream(dataInputStream);
        instance.taskId = CommitUtils.readStringFromInputStream(dataInputStream);
        instance.text = CommitUtils.readStringFromInputStream(dataInputStream);
        int partListSize = dataInputStream.readInt();
        ArrayList<S3PartInfo> partInfoList = new ArrayList<S3PartInfo>(partListSize);
        for (int i = 0; i < partListSize; ++i) {
            byte[] bytes = CommitUtils.readBytesFromInputStream(dataInputStream);
            partInfoList.add(S3PartInfo.fromBytes(bytes));
        }
        instance.bindCommitData(partInfoList);
        instance.validate();
        return instance;
    }

    public void touch(long millis) {
        this.created = millis;
        this.saved = millis;
        this.date = new Date(millis).toString();
    }

    public void bindCommitData(List<S3PartInfo> parts) throws ValidationFailure {
        this.partInfoList = new ArrayList<S3PartInfo>(parts.size());
        this.partInfoList.addAll(parts);
    }

    @Override
    public void validate() throws ValidationFailure {
        ValidationFailure.verify(this.version == 1, "Wrong version: %s", this.version);
        ValidationFailure.verify(com.aliyun.emr.utils.StringUtils.isNotEmpty(this.bucket), "Empty bucket", new Object[0]);
        ValidationFailure.verify(com.aliyun.emr.utils.StringUtils.isNotEmpty(this.destinationKey), "Empty destination", new Object[0]);
        ValidationFailure.verify(com.aliyun.emr.utils.StringUtils.isNotEmpty(this.uploadId), "Empty uploadId", new Object[0]);
        ValidationFailure.verify(this.length >= 0L, "Invalid length: " + this.length, new Object[0]);
        this.destinationPath();
        ValidationFailure.verify(this.partInfoList != null, "No etag list", new Object[0]);
        CommitUtils.validateCollectionClass(this.partInfoList, S3PartInfo.class);
        for (S3PartInfo partInfo : this.partInfoList) {
            ValidationFailure.verify(com.aliyun.emr.utils.StringUtils.isNotEmpty(partInfo.getEtag()), "Empty etag", new Object[0]);
            ValidationFailure.verify(partInfo.getPartNum() >= 0, "Invalid part number", new Object[0]);
            ValidationFailure.verify(partInfo.getSize() >= 0L, "Invalid part number", new Object[0]);
        }
        if (this.extraData != null) {
            CommitUtils.validateCollectionClass(this.extraData.keySet(), String.class);
            CommitUtils.validateCollectionClass(this.extraData.values(), String.class);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DelayedCompleteData{");
        sb.append("version=").append(this.version);
        sb.append(", uri='").append(this.uri).append('\'');
        sb.append(", destination='").append(this.destinationKey).append('\'');
        sb.append(", uploadId='").append(this.uploadId).append('\'');
        sb.append(", created=").append(this.created);
        sb.append(", saved=").append(this.saved);
        sb.append(", size=").append(this.length);
        sb.append(", date='").append(this.date).append('\'');
        sb.append(", jobId='").append(this.jobId).append('\'');
        sb.append(", taskId='").append(this.taskId).append('\'');
        sb.append(", notes='").append(this.text).append('\'');
        if (this.partInfoList != null) {
            sb.append(", partInfoList=[");
            sb.append(StringUtils.join((CharSequence)",", this.partInfoList));
            sb.append(']');
        } else {
            sb.append(", partInfoList=null");
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public byte[] toBytes() throws IOException {
        this.validate();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        try {
            dataOutputStream.writeInt(this.version);
            CommitUtils.writeStringToOutputStream(dataOutputStream, this.uri);
            CommitUtils.writeStringToOutputStream(dataOutputStream, this.bucket);
            CommitUtils.writeStringToOutputStream(dataOutputStream, this.destinationKey);
            CommitUtils.writeStringToOutputStream(dataOutputStream, this.uploadId);
            dataOutputStream.writeLong(this.created);
            dataOutputStream.writeLong(this.saved);
            CommitUtils.writeStringToOutputStream(dataOutputStream, this.date);
            CommitUtils.writeStringToOutputStream(dataOutputStream, this.jobId);
            CommitUtils.writeStringToOutputStream(dataOutputStream, this.taskId);
            CommitUtils.writeStringToOutputStream(dataOutputStream, this.text);
            dataOutputStream.writeInt(this.partInfoList.size());
            for (int i = 0; i < this.partInfoList.size(); ++i) {
                byte[] partInfoBytes = this.partInfoList.get(i).toBytes();
                dataOutputStream.writeInt(partInfoBytes.length);
                dataOutputStream.write(partInfoBytes);
            }
            dataOutputStream.flush();
            byte[] i = outputStream.toByteArray();
            return i;
        }
        catch (IOException e) {
            LOG.error("Failed to serialize SingePendingCommit.", (Throwable)e);
            throw e;
        }
        finally {
            try {
                dataOutputStream.close();
                outputStream.close();
            }
            catch (IOException e) {
                LOG.warn("Failed to close OutputStream.", (Throwable)e);
            }
        }
    }

    @Override
    public void save(FileSystem fs, Path path, boolean overwrite) throws IOException {
        try (FSDataOutputStream outputStream = fs.create(path, overwrite);){
            outputStream.write(this.toBytes());
        }
    }

    public Path destinationPath() {
        Preconditions.checkState(com.aliyun.emr.utils.StringUtils.isNotEmpty(this.uri), "Empty uri");
        return new Path(this.uri);
    }

    public int getPartCount() {
        return this.partInfoList.size();
    }

    @Override
    public Iterator<S3PartInfo> iterator() {
        return this.partInfoList.iterator();
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getDestinationKey() {
        return this.destinationKey;
    }

    public void setDestinationKey(String destinationKey) {
        this.destinationKey = destinationKey;
    }

    public long getCreated() {
        return this.created;
    }

    public void setCreated(long created) {
        this.created = created;
    }

    public long getSaved() {
        return this.saved;
    }

    public void setSaved(long saved) {
        this.saved = saved;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public List<S3PartInfo> getPartInfoList() {
        return this.partInfoList;
    }

    public void setPartInfoList(List<S3PartInfo> partInfoList) {
        this.partInfoList = partInfoList;
    }

    public Map<String, String> getExtraData() {
        return this.extraData;
    }

    public void setExtraData(Map<String, String> extraData) {
        this.extraData = extraData;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }
}

