/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.common;

import bigboot.protocol.type.FileletStatus;
import com.aliyun.emr.compatibility.StopWatch;
import com.aliyun.emr.fs.s3.common.FsStats;
import com.aliyun.emr.fs.s3.common.Utils;
import com.aliyun.emr.fs.s3.common.WrappedRemoteIterator;
import com.aliyun.emr.fs.s3.internal.AbstractFileSystemStore;
import com.aliyun.emr.fs.s3.internal.JindoCryptoPolicy;
import com.aliyun.emr.fs.s3.internal.JindoPathResolver;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJindoShimsFileSystem
extends FileSystem {
    static final Logger LOG = LoggerFactory.getLogger(AbstractJindoShimsFileSystem.class);
    private static boolean logLevelInitialized = false;
    public static AtomicLong totalS3ReadTime = new AtomicLong(0L);
    public static AtomicLong s3ReadCount = new AtomicLong(0L);
    public static AtomicLong totalCacheReadTime = new AtomicLong(0L);
    public static AtomicLong cacheReadCount = new AtomicLong(0L);
    protected AbstractFileSystemStore store;
    protected Path workingDir;
    protected URI uri;
    private JindoPathResolver pathResolver;
    protected Configuration conf;
    protected String logName;
    protected boolean isCmd;
    private FsPermission uMask;

    public static long getS3Average() {
        long time = totalS3ReadTime.get();
        long count = s3ReadCount.get();
        if (count <= 0L) {
            return -1L;
        }
        return time / count;
    }

    public static long getCacheAverage() {
        long time = totalCacheReadTime.get();
        long count = cacheReadCount.get();
        if (count <= 0L) {
            return -1L;
        }
        return time / count;
    }

    public static long getS3Percent() {
        long cacheCount;
        long s3Count = s3ReadCount.get();
        long totalCount = s3Count + (cacheCount = cacheReadCount.get());
        if (totalCount <= 0L) {
            return 0L;
        }
        return 100L * s3Count / totalCount;
    }

    public void initialize(URI uri, Configuration conf) throws IOException {
        this.conf = conf;
        this.uri = uri.getAuthority() != null ? URI.create(uri.getScheme() + "://" + uri.getAuthority()) : URI.create(uri.getScheme() + ":///");
        super.initialize(uri, conf);
        AbstractJindoShimsFileSystem.initLogLevel();
        this.workingDir = new Path("/user", System.getProperty("user.name")).makeQualified(this.uri, this.getWorkingDirectory());
        this.setConf(conf);
        this.uMask = FsPermission.getUMask((Configuration)conf);
        this.isCmd = conf.getBoolean("fs.jfs.isCmd", false);
        this.pathResolver = new JindoPathResolver(conf, uri.getAuthority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initLogLevel() {
        if (logLevelInitialized) return;
        Class<AbstractJindoShimsFileSystem> clazz = AbstractJindoShimsFileSystem.class;
        synchronized (AbstractJindoShimsFileSystem.class) {
            if (logLevelInitialized) return;
            try {
                StackTraceElement[] stacks;
                boolean interactive = false;
                for (StackTraceElement caller : stacks = Thread.currentThread().getStackTrace()) {
                    if (!caller.getClassName().equals("org.apache.hadoop.fs.FsShell")) continue;
                    interactive = true;
                    break;
                }
                if (!interactive) return;
                LogManager.getLogger((String)"com.aliyun.emr").setLevel(Level.WARN);
                LogManager.getLogger((String)"com.alibaba.jboot").setLevel(Level.WARN);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                logLevelInitialized = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    protected abstract FSDataInputStream openCore(Path var1, int var2) throws IOException;

    protected abstract FSDataOutputStream createCore(Path var1, FsPermission var2, boolean var3, int var4, short var5, long var6, Progressable var8) throws IOException;

    protected abstract FileStatus getFileStatusCore(Path var1) throws IOException;

    protected abstract boolean renameCore(Path var1, Path var2) throws IOException;

    protected abstract boolean deleteCore(Path var1, boolean var2, boolean var3) throws IOException;

    protected abstract FileStatus[] listStatusCore(Path var1) throws IOException;

    protected abstract boolean mkdirsCore(Path var1, FsPermission var2) throws IOException;

    protected abstract BlockLocation[] getFileBlockLocationsCore(FileStatus var1, long var2, long var4) throws IOException;

    protected abstract byte[] getXAttrCore(Path var1, String var2) throws IOException;

    protected abstract Map<String, byte[]> getXAttrsCore(Path var1) throws IOException;

    protected abstract Map<String, byte[]> getXAttrsCore(Path var1, List<String> var2) throws IOException;

    protected abstract void setXAttrCore(Path var1, String var2, byte[] var3) throws IOException;

    protected abstract List<String> listXAttrsCore(Path var1) throws IOException;

    protected abstract void removeXAttrCore(Path var1, String var2) throws IOException;

    protected abstract void checkPermissionCore(Path var1, FsAction var2) throws IOException;

    protected FileChecksum getFileChecksumCore(Path path) throws IOException {
        return this.store.getFileChecksum(path);
    }

    protected FileChecksum getFileChecksum2Core(Path path) throws IOException {
        return this.store.getFileChecksum2(path);
    }

    protected FileChecksum getFileChecksum2Core(Path path, long blockSize) throws IOException {
        return this.store.getFileChecksum2(path, blockSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        JindoPathResolver.JindoShimsPath jindoPath = this.pathResolver.getJindoShimsPath(f);
        if (jindoPath != null) {
            return jindoPath.getTargetFS().create(jindoPath.getTargetPath(), permission, overwrite, bufferSize, replication, blockSize, progress);
        }
        StopWatch sw = new StopWatch().start();
        Path qualifiedPath = Utils.qualifyPath(f, this.uri, this.workingDir);
        try {
            FsPermission masked = this.applyUMask(permission);
            FSDataOutputStream fSDataOutputStream = this.createCore(qualifiedPath, masked, overwrite, bufferSize, replication, blockSize, progress);
            return fSDataOutputStream;
        }
        finally {
            FsStats.logStats("create", qualifiedPath, null, 0L, null, sw.stop().now(), "3.7.2");
        }
    }

    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        JindoPathResolver.JindoShimsPath jindoPath = this.pathResolver.getJindoShimsPath(f);
        if (jindoPath != null) {
            return jindoPath.getTargetFS().create(jindoPath.getTargetPath(), permission, flags, bufferSize, replication, blockSize, progress);
        }
        EnumSet<CreateFlag> createflags = EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE);
        boolean overwrite = flags.containsAll(createflags);
        return this.create(f, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        FSDataInputStream fSDataInputStream;
        JindoPathResolver.JindoShimsPath jindoPath = this.pathResolver.getJindoShimsPath(path);
        if (jindoPath != null) {
            return jindoPath.getTargetFS().open(jindoPath.getTargetPath(), bufferSize);
        }
        StopWatch sw = new StopWatch().start();
        Path qualifyPath = Utils.qualifyPath(path, this.uri, this.workingDir);
        FSDataInputStream inputStream = null;
        try {
            fSDataInputStream = inputStream = this.openCore(qualifyPath, bufferSize);
            FsStats.logStats("open", qualifyPath, null, inputStream != null ? (long)inputStream.available() : -1L, null, sw.stop().now(), "3.7.2");
        }
        catch (Throwable throwable) {
            FsStats.logStats("open", qualifyPath, null, inputStream != null ? (long)inputStream.available() : -1L, null, sw.stop().now(), "3.7.2");
            throw throwable;
        }
        return fSDataInputStream;
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        JindoPathResolver.JindoShimsPath jindoPath = this.pathResolver.getJindoShimsPath(f);
        if (jindoPath != null) {
            return jindoPath.getTargetFS().append(jindoPath.getTargetPath(), bufferSize, progress);
        }
        throw new IOException("Not supported append operation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rename(Path src, Path dst) throws IOException {
        JindoPathResolver.JindoShimsPath jindoPathSrc = this.pathResolver.getJindoShimsPath(src);
        JindoPathResolver.JindoShimsPath jindoPathDst = this.pathResolver.getJindoShimsPath(dst);
        if (jindoPathSrc != null && jindoPathDst != null) {
            if (!Objects.equals(jindoPathSrc.getTargetFS().getUri().getAuthority(), jindoPathDst.getTargetFS().getUri().getAuthority())) {
                throw new UnsupportedOperationException("can not support rename acrs3 filesystem. srcfs: " + jindoPathSrc.getTargetFS().getUri() + ", dstfs: " + jindoPathDst.getTargetFS().getUri());
            }
            return jindoPathSrc.getTargetFS().rename(jindoPathSrc.getTargetPath(), jindoPathDst.getTargetPath());
        }
        if (jindoPathSrc != null || jindoPathDst != null) {
            throw new UnsupportedOperationException("can not support rename acrs3 filesystem");
        }
        StopWatch sw = new StopWatch().start();
        Path srcQualifyPath = Utils.qualifyPath(src, this.uri, this.workingDir);
        Path dstQualifyPath = Utils.qualifyPath(dst, this.uri, this.workingDir);
        try {
            boolean bl = this.renameCore(srcQualifyPath, dstQualifyPath);
            return bl;
        }
        finally {
            FsStats.logStats("rename", srcQualifyPath, dstQualifyPath, 0L, "", sw.stop().now(), "3.7.2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(Path f, boolean recursive) throws IOException {
        JindoPathResolver.JindoShimsPath jindoPath = this.pathResolver.getJindoShimsPath(f);
        if (jindoPath != null) {
            return jindoPath.getTargetFS().delete(jindoPath.getTargetPath(), recursive);
        }
        StopWatch sw = new StopWatch().start();
        Path qualifyPath = Utils.qualifyPath(f, this.uri, this.workingDir);
        try {
            boolean bl = this.deleteCore(qualifyPath, recursive, false);
            return bl;
        }
        finally {
            FsStats.logStats("delete", qualifyPath, null, 0L, "recurse:" + recursive, sw.stop().now(), "3.7.2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(Path f, boolean recursive, boolean deleteVersions) throws IOException {
        JindoPathResolver.JindoShimsPath jindoPath = this.pathResolver.getJindoShimsPath(f);
        if (jindoPath != null) {
            return jindoPath.getTargetFS().delete(jindoPath.getTargetPath(), recursive);
        }
        StopWatch sw = new StopWatch().start();
        Path qualifyPath = Utils.qualifyPath(f, this.uri, this.workingDir);
        try {
            boolean bl = this.deleteCore(qualifyPath, recursive, deleteVersions);
            return bl;
        }
        finally {
            FsStats.logStats("deleteVersions", qualifyPath, null, 0L, "recurse:" + recursive, sw.stop().now(), "3.7.2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        FileStatus[] fileStatusArray;
        JindoPathResolver.JindoShimsPath jindoPath = this.pathResolver.getJindoShimsPath(f);
        if (jindoPath != null) {
            FileStatus[] fileStatuses = jindoPath.getTargetFS().listStatus(jindoPath.getTargetPath());
            for (int i = 0; i < fileStatuses.length; ++i) {
                fileStatuses[i].setPath(jindoPath.rewriteToSrcPath(fileStatuses[i].getPath(), this.getUri()));
            }
            return fileStatuses;
        }
        StopWatch sw = new StopWatch().start();
        Path qualifyPath = Utils.qualifyPath(f, this.uri, this.workingDir);
        FileStatus[] filelist = null;
        try {
            fileStatusArray = filelist = this.listStatusCore(qualifyPath);
            FsStats.logStats("listStatus", qualifyPath, null, filelist != null ? (long)filelist.length : 0L, "", sw.stop().now(), "3.7.2");
        }
        catch (Throwable throwable) {
            FsStats.logStats("listStatus", qualifyPath, null, filelist != null ? (long)filelist.length : 0L, "", sw.stop().now(), "3.7.2");
            throw throwable;
        }
        return fileStatusArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStatus getFileStatus(Path f) throws IOException {
        FileStatus fileStatus;
        JindoPathResolver.JindoShimsPath jindoPath = this.pathResolver.getJindoShimsPath(f);
        if (jindoPath != null) {
            FileStatus fileStatus2 = jindoPath.getTargetFS().getFileStatus(jindoPath.getTargetPath());
            fileStatus2.setPath(f);
            return fileStatus2;
        }
        StopWatch sw = new StopWatch().start();
        Path qualifiedPath = Utils.qualifyPath(f, this.uri, this.workingDir);
        FileStatus status = null;
        try {
            fileStatus = status = this.getFileStatusCore(qualifiedPath);
            FsStats.logStats("getFileStatus", qualifiedPath, null, status == null ? -1L : status.getLen(), null, sw.stop().now(), "3.7.2");
        }
        catch (Throwable throwable) {
            FsStats.logStats("getFileStatus", qualifiedPath, null, status == null ? -1L : status.getLen(), null, sw.stop().now(), "3.7.2");
            throw throwable;
        }
        return fileStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        JindoPathResolver.JindoShimsPath jindoPath = this.pathResolver.getJindoShimsPath(f);
        if (jindoPath != null) {
            return jindoPath.getTargetFS().mkdirs(jindoPath.getTargetPath(), permission);
        }
        StopWatch sw = new StopWatch().start();
        Path qualifiedPath = Utils.qualifyPath(f, this.uri, this.workingDir);
        try {
            FsPermission masked = this.applyUMask(permission);
            boolean bl = this.mkdirsCore(qualifiedPath, masked);
            return bl;
        }
        finally {
            FsStats.logStats("mkdirs", qualifiedPath, null, 0L, "FsPermission:" + permission, sw.stop().now(), "3.7.2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        BlockLocation[] blockLocationArray;
        BlockLocation[] locations;
        StopWatch sw;
        block6: {
            JindoPathResolver.JindoShimsPath jindoPath = this.pathResolver.getJindoShimsPath(file.getPath());
            if (jindoPath != null) {
                return jindoPath.getTargetFS().getFileBlockLocations(jindoPath.getTargetPath(), start, len);
            }
            sw = new StopWatch().start();
            locations = null;
            locations = this.getFileBlockLocationsCore(file, start, len);
            if (locations != null && locations.length > 0) break block6;
            BlockLocation[] blockLocationArray2 = super.getFileBlockLocations(file, start, len);
            FsStats.logStats("getFileBlockLocations", file.getPath(), null, locations == null ? -1L : (long)locations.length, "", sw.stop().now(), "3.7.2");
            return blockLocationArray2;
        }
        try {
            blockLocationArray = locations;
        }
        catch (IOException e) {
            BlockLocation[] blockLocationArray3;
            try {
                blockLocationArray3 = super.getFileBlockLocations(file, start, len);
            }
            catch (Throwable throwable) {
                FsStats.logStats("getFileBlockLocations", file.getPath(), null, locations == null ? -1L : (long)locations.length, "", sw.stop().now(), "3.7.2");
                throw throwable;
            }
            FsStats.logStats("getFileBlockLocations", file.getPath(), null, locations == null ? -1L : (long)locations.length, "", sw.stop().now(), "3.7.2");
            return blockLocationArray3;
        }
        FsStats.logStats("getFileBlockLocations", file.getPath(), null, locations == null ? -1L : (long)locations.length, "", sw.stop().now(), "3.7.2");
        return blockLocationArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getXAttr(Path path, String name) throws IOException {
        JindoPathResolver.JindoShimsPath jindoPath = this.pathResolver.getJindoShimsPath(path);
        if (jindoPath != null) {
            return jindoPath.getTargetFS().getXAttr(jindoPath.getTargetPath(), name);
        }
        StopWatch sw = new StopWatch().start();
        try {
            byte[] byArray = this.getXAttrCore(path, name);
            return byArray;
        }
        catch (UnsupportedOperationException e) {
            byte[] byArray = super.getXAttr(path, name);
            return byArray;
        }
        finally {
            FsStats.logStats("getXAttr", path, null, 0L, "", sw.stop().now(), "3.7.2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        JindoPathResolver.JindoShimsPath jindoPath = this.pathResolver.getJindoShimsPath(path);
        if (jindoPath != null) {
            return jindoPath.getTargetFS().getXAttrs(jindoPath.getTargetPath());
        }
        StopWatch sw = new StopWatch().start();
        try {
            Map<String, byte[]> map = this.getXAttrsCore(path);
            return map;
        }
        catch (UnsupportedOperationException e) {
            Map map = super.getXAttrs(path);
            return map;
        }
        finally {
            FsStats.logStats("getXAttrs", path, null, 0L, "", sw.stop().now(), "3.7.2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        JindoPathResolver.JindoShimsPath jindoPath = this.pathResolver.getJindoShimsPath(path);
        if (jindoPath != null) {
            return jindoPath.getTargetFS().getXAttrs(jindoPath.getTargetPath(), names);
        }
        StopWatch sw = new StopWatch().start();
        try {
            Map<String, byte[]> map = this.getXAttrsCore(path, names);
            return map;
        }
        catch (UnsupportedOperationException e) {
            Map map = super.getXAttrs(path, names);
            return map;
        }
        finally {
            FsStats.logStats("getXAttrs", path, null, 0L, "", sw.stop().now(), "3.7.2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXAttr(Path path, String name, byte[] value) throws IOException {
        JindoPathResolver.JindoShimsPath jindoPath = this.pathResolver.getJindoShimsPath(path);
        if (jindoPath != null) {
            jindoPath.getTargetFS().setXAttr(jindoPath.getTargetPath(), name, value);
            return;
        }
        StopWatch sw = new StopWatch().start();
        try {
            this.setXAttrCore(path, name, value);
        }
        catch (UnsupportedOperationException e) {
            super.setXAttr(path, name, value);
        }
        finally {
            FsStats.logStats("setXAttr", path, null, 0L, "", sw.stop().now(), "3.7.2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listXAttrs(Path path) throws IOException {
        JindoPathResolver.JindoShimsPath jindoPath = this.pathResolver.getJindoShimsPath(path);
        if (jindoPath != null) {
            return jindoPath.getTargetFS().listXAttrs(jindoPath.getTargetPath());
        }
        StopWatch sw = new StopWatch().start();
        try {
            List<String> list = this.listXAttrsCore(path);
            return list;
        }
        catch (UnsupportedOperationException e) {
            List list = super.listXAttrs(path);
            return list;
        }
        finally {
            FsStats.logStats("listXAttrs", path, null, 0L, "", sw.stop().now(), "3.7.2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeXAttr(Path path, String name) throws IOException {
        JindoPathResolver.JindoShimsPath jindoPath = this.pathResolver.getJindoShimsPath(path);
        if (jindoPath != null) {
            jindoPath.getTargetFS().removeXAttr(jindoPath.getTargetPath(), name);
            return;
        }
        StopWatch sw = new StopWatch().start();
        try {
            this.removeXAttrCore(path, name);
        }
        catch (UnsupportedOperationException e) {
            super.removeXAttr(path, name);
        }
        finally {
            FsStats.logStats("removeXAttr", path, null, 0L, "", sw.stop().now(), "3.7.2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentSummary getContentSummary(Path path) throws IOException {
        JindoPathResolver.JindoShimsPath jindoPath = this.pathResolver.getJindoShimsPath(path);
        if (jindoPath != null) {
            return jindoPath.getTargetFS().getContentSummary(jindoPath.getTargetPath());
        }
        StopWatch sw = new StopWatch().start();
        Path qualifyPath = Utils.qualifyPath(path, this.uri, this.workingDir);
        try {
            ContentSummary contentSummary = this.getContentSummaryCore(qualifyPath);
            return contentSummary;
        }
        finally {
            FsStats.logStats("getContentSummary", qualifyPath, null, 0L, "", sw.stop().now(), "3.7.2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChecksum getFileChecksum(Path path) throws IOException {
        StopWatch sw = new StopWatch().start();
        Path qualifiedPath = Utils.qualifyPath(path, this.uri, this.workingDir);
        try {
            FileChecksum fileChecksum = this.getFileChecksumCore(qualifiedPath);
            return fileChecksum;
        }
        catch (UnsupportedOperationException e) {
            FileChecksum fileChecksum = super.getFileChecksum(path);
            return fileChecksum;
        }
        finally {
            FsStats.logStats("getFileChecksum", path, null, 0L, "", sw.stop().now(), "3.7.2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChecksum getFileChecksum2(Path path) throws IOException {
        StopWatch sw = new StopWatch().start();
        Path qualifiedPath = Utils.qualifyPath(path, this.uri, this.workingDir);
        try {
            FileChecksum fileChecksum = this.getFileChecksum2Core(qualifiedPath);
            return fileChecksum;
        }
        catch (UnsupportedOperationException e) {
            FileChecksum fileChecksum = super.getFileChecksum(path);
            return fileChecksum;
        }
        finally {
            FsStats.logStats("getFileChecksum2", path, null, 0L, "", sw.stop().now(), "3.7.2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChecksum getFileChecksum2(Path path, long blockSize) throws IOException {
        StopWatch sw = new StopWatch().start();
        Path qualifiedPath = Utils.qualifyPath(path, this.uri, this.workingDir);
        try {
            FileChecksum fileChecksum = this.getFileChecksum2Core(qualifiedPath, blockSize);
            return fileChecksum;
        }
        catch (UnsupportedOperationException e) {
            FileChecksum fileChecksum = super.getFileChecksum(path);
            return fileChecksum;
        }
        finally {
            FsStats.logStats("getFileChecksum2", path, null, 0L, "", sw.stop().now(), "3.7.2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void access(Path path, FsAction mode) throws IOException {
        JindoPathResolver.JindoShimsPath jindoPath = this.pathResolver.getJindoShimsPath(path);
        if (jindoPath != null) {
            jindoPath.getTargetFS().access(jindoPath.getTargetPath(), mode);
            return;
        }
        StopWatch sw = new StopWatch().start();
        try {
            this.checkPermissionCore(path, mode);
        }
        finally {
            FsStats.logStats("checkPermission", path, null, 0L, "", sw.stop().now(), "3.7.2");
        }
    }

    protected RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f, PathFilter filter) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(f);
        if (newPath == null) {
            if (!this.conf.getBoolean("fs.jfs.list-located.enable", true)) {
                return super.listLocatedStatus(f, filter);
            }
            return this.store.listLocatedStatus(f, filter);
        }
        Class<?> classType = newPath.getTargetFS().getClass();
        Method method = null;
        try {
            method = classType.getDeclaredMethod("listLocatedStatus", Path.class, PathFilter.class);
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("Not implemented listLocatedStatus(Path p, final PathFilter filter)", e);
        }
        method.setAccessible(true);
        try {
            return new WrappedRemoteIterator<LocatedFileStatus>((RemoteIterator)method.invoke((Object)newPath.getTargetFS(), newPath.getTargetPath(), filter), locatedFileStatus -> {
                Path originPath = newPath.rewriteToSrcPath(locatedFileStatus.getPath(), this.getUri());
                locatedFileStatus.setPath(originPath);
                return locatedFileStatus;
            });
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException("Not implemented listLocatedStatus(Path p, final PathFilter filter)", e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IOException) {
                throw (IOException)e.getTargetException();
            }
            throw new UnsupportedOperationException("Not implemented listLocatedStatus(Path p, final PathFilter filter)", e);
        }
    }

    public Path getHomeDirectory() {
        try {
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            return this.makeQualified(new Path("/user/" + ugi.getShortUserName()));
        }
        catch (IOException e) {
            LOG.warn("", (Throwable)e);
            return super.getHomeDirectory();
        }
    }

    private FsPermission applyUMask(FsPermission permission) {
        if (permission == null) {
            permission = FsPermission.getFileDefault();
        }
        return permission.applyUMask(this.uMask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameFiles(Path srcFolder, Path destFolder, boolean errorOnExists) throws IOException {
        StopWatch sw = new StopWatch().start();
        try {
            boolean bl = this.renameFilesCore(srcFolder, destFolder, errorOnExists);
            return bl;
        }
        finally {
            FsStats.logStats("renameFiles", srcFolder, destFolder, 0L, "errorOnExists:" + errorOnExists, sw.stop().now(), "3.7.2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveToAppropriateTrash(Path p) throws IOException {
        StopWatch sw = new StopWatch().start();
        try {
            boolean bl = this.moveToAppropriateTrashCore(p);
            return bl;
        }
        finally {
            FsStats.logStats("moveToAppropriateTrash", p, null, 0L, null, sw.stop().now(), "3.7.2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFiles(Path p) throws IOException {
        StopWatch sw = new StopWatch().start();
        try {
            boolean bl = this.deleteFilesCore(p);
            return bl;
        }
        finally {
            FsStats.logStats("deleteFiles", p, null, 0L, null, sw.stop().now(), "3.7.2");
        }
    }

    public abstract boolean renameFilesCore(Path var1, Path var2, boolean var3) throws IOException;

    public abstract boolean moveToAppropriateTrashCore(Path var1) throws IOException;

    public abstract boolean deleteFilesCore(Path var1) throws IOException;

    protected abstract ContentSummary getContentSummaryCore(Path var1) throws IOException;

    public abstract String getScheme();

    public URI getUri() {
        return this.uri;
    }

    public void setWorkingDirectory(Path newDir) {
        this.workingDir = newDir;
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public void close() throws IOException {
        super.close();
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
    }

    public AbstractFileSystemStore getStore() {
        return this.store;
    }

    public void setStatistics(FileSystem.Statistics statistics) {
        this.store.setStatistics(statistics);
    }

    public Boolean isBatchIOSupported() {
        return false;
    }

    public abstract Boolean isCacheMode();

    public abstract Boolean isMagicCommitEnabled();

    protected abstract void unCacheCore(Path var1) throws IOException;

    protected abstract void cacheCore(Path var1, CacheOpContext var2) throws IOException;

    protected void atomicCacheCore(Path path, CacheOpContext opContext) throws IOException {
        this.store.atomicCache(path, opContext);
    }

    protected abstract FileletStatus[] checkProgressCore(Path var1, boolean var2) throws IOException;

    protected void setCryptoPolicyCore(Path path, String keyIdName, byte cipherSuite) throws IOException {
        this.store.setCryptoPolicy(path, keyIdName, cipherSuite);
    }

    protected JindoCryptoPolicy getCryptoPolicyCore(Path path) throws IOException {
        return this.store.getCryptoPolicy(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCryptoPolicy(Path path, String keyIdName, byte cipherSuite) throws IOException {
        JindoPathResolver.JindoShimsPath jindoPath = this.pathResolver.getJindoShimsPath(path);
        if (jindoPath != null) {
            try {
                FileSystem targetFS = jindoPath.getTargetFS();
                if (targetFS instanceof AbstractJindoShimsFileSystem) {
                    ((AbstractJindoShimsFileSystem)targetFS).setCryptoPolicy(jindoPath.getTargetPath(), keyIdName, cipherSuite);
                    return;
                }
                throw new UnsupportedOperationException("setCryptoPolicy only support for JindoFS, the target path is " + jindoPath.getTargetPath());
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("setCryptoPolicy only support for JindoFS, the target path is " + jindoPath.getTargetPath(), e);
            }
        }
        StopWatch sw = new StopWatch().start();
        Path qualifiedPath = Utils.qualifyPath(path, this.uri, this.workingDir);
        try {
            this.setCryptoPolicyCore(qualifiedPath, keyIdName, cipherSuite);
        }
        finally {
            FsStats.logStats("setCryptoPolicy", path, null, 0L, "", sw.stop().now(), "3.7.2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JindoCryptoPolicy getCryptoPolicy(Path path) throws IOException {
        JindoPathResolver.JindoShimsPath jindoPath = this.pathResolver.getJindoShimsPath(path);
        if (jindoPath != null) {
            try {
                FileSystem targetFS = jindoPath.getTargetFS();
                if (targetFS instanceof AbstractJindoShimsFileSystem) {
                    return ((AbstractJindoShimsFileSystem)targetFS).getCryptoPolicy(jindoPath.getTargetPath());
                }
                throw new UnsupportedOperationException("getCryptoPolicy only support for JindoFS, the target path is " + jindoPath.getTargetPath());
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("getCryptoPolicy only support for JindoFS, the target path is " + jindoPath.getTargetPath(), e);
            }
        }
        StopWatch sw = new StopWatch().start();
        Path qualifiedPath = Utils.qualifyPath(path, this.uri, this.workingDir);
        try {
            JindoCryptoPolicy jindoCryptoPolicy = this.getCryptoPolicyCore(qualifiedPath);
            return jindoCryptoPolicy;
        }
        finally {
            FsStats.logStats("getCryptoPolicy", path, null, 0L, "", sw.stop().now(), "3.7.2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unCache(Path path) throws IOException {
        JindoPathResolver.JindoShimsPath jindoPath = this.pathResolver.getJindoShimsPath(path);
        if (jindoPath != null) {
            try {
                FileSystem targetFS = jindoPath.getTargetFS();
                if (targetFS instanceof AbstractJindoShimsFileSystem) {
                    ((AbstractJindoShimsFileSystem)targetFS).unCache(jindoPath.getTargetPath());
                    return;
                }
                throw new UnsupportedOperationException("unCache only support for JindoFS, the target path is " + jindoPath.getTargetPath());
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("unCache only support for JindoFS, the target path is " + jindoPath.getTargetPath(), e);
            }
        }
        StopWatch sw = new StopWatch().start();
        Path qualifiedPath = Utils.qualifyPath(path, this.uri, this.workingDir);
        try {
            this.unCacheCore(qualifiedPath);
        }
        finally {
            FsStats.logStats("unCache", path, null, 0L, "", sw.stop().now(), "3.7.2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cache(Path path, CacheOpContext opContext) throws IOException {
        JindoPathResolver.JindoShimsPath jindoPath = this.pathResolver.getJindoShimsPath(path);
        if (jindoPath != null) {
            try {
                FileSystem targetFS = jindoPath.getTargetFS();
                if (targetFS instanceof AbstractJindoShimsFileSystem) {
                    ((AbstractJindoShimsFileSystem)targetFS).cacheCore(path, opContext);
                    return;
                }
                throw new UnsupportedOperationException("cache only support for JindoFS, the target path is " + jindoPath.getTargetPath());
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("cache only support for JindoFS, the target path is " + jindoPath.getTargetPath(), e);
            }
        }
        StopWatch sw = new StopWatch().start();
        Path qualifiedPath = Utils.qualifyPath(path, this.uri, this.workingDir);
        try {
            this.cacheCore(qualifiedPath, opContext);
        }
        finally {
            FsStats.logStats("cache", path, null, 0L, "", sw.stop().now(), "3.7.2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void atomicCache(Path path, CacheOpContext opContext) throws IOException {
        JindoPathResolver.JindoShimsPath jindoPath = this.pathResolver.getJindoShimsPath(path);
        if (jindoPath != null) {
            try {
                FileSystem targetFS = jindoPath.getTargetFS();
                if (targetFS instanceof AbstractJindoShimsFileSystem) {
                    ((AbstractJindoShimsFileSystem)targetFS).atomicCache(path, opContext);
                    return;
                }
                throw new UnsupportedOperationException("cache only support for JindoFS, the target path is " + jindoPath.getTargetPath());
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("cache only support for JindoFS, the target path is " + jindoPath.getTargetPath(), e);
            }
        }
        StopWatch sw = new StopWatch().start();
        Path qualifiedPath = Utils.qualifyPath(path, this.uri, this.workingDir);
        try {
            this.atomicCacheCore(qualifiedPath, opContext);
        }
        finally {
            FsStats.logStats("atomicCache", path, null, 0L, "", sw.stop().now(), "3.7.2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileletStatus[] checkProgress(Path path, boolean detailed) throws IOException {
        JindoPathResolver.JindoShimsPath jindoPath = this.pathResolver.getJindoShimsPath(path);
        if (jindoPath != null) {
            try {
                FileSystem targetFS = jindoPath.getTargetFS();
                if (targetFS instanceof AbstractJindoShimsFileSystem) {
                    return ((AbstractJindoShimsFileSystem)targetFS).checkProgressCore(path, detailed);
                }
                throw new UnsupportedOperationException("checkProgress only support for JindoFS, the target path is " + jindoPath.getTargetPath());
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("checkProgress only support for JindoFS, the target path is " + jindoPath.getTargetPath(), e);
            }
        }
        StopWatch sw = new StopWatch().start();
        Path qualifiedPath = Utils.qualifyPath(path, this.uri, this.workingDir);
        try {
            FileletStatus[] fileletStatusArray = this.checkProgressCore(qualifiedPath, detailed);
            return fileletStatusArray;
        }
        finally {
            FsStats.logStats("checkProgress", path, null, 0L, "", sw.stop().now(), "3.7.2");
        }
    }

    public static class CacheOpContext {
        public boolean shouldPin = false;
        public boolean shouldLoadMemory = false;
        public boolean sync = false;
        public boolean smallfile = false;
        public int fileBatchSize = 2000000;
        public int replica = 1;
        public boolean recursive = true;
        public boolean dataCache = true;
    }
}

