/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JindoPathResolver
implements Closeable {
    static final Logger LOG = LoggerFactory.getLogger(JindoPathResolver.class);
    private static final String CONFIG_HDFS_PREFIX = "fs.jindo.shim.path-rewrite";
    private static final String CONFIG_SOURCE = "source";
    private static final String CONFIG_TARGET = "target";
    private static final String CONFIG_HDFS_DEFAULT_SHIMES_TABLE = "default";
    private Map<String, JindoShimsRewriteRule> rewriteRule = new HashMap<String, JindoShimsRewriteRule>();
    private Map<String, List<JindoShimsRewriteRule>> rewriteRoot = new HashMap<String, List<JindoShimsRewriteRule>>();

    private List<Pair<String, String>> getRuleRewriteRule(Configuration config, String viewName) {
        ArrayList<Pair<String, String>> pathRewriteRule = new ArrayList<Pair<String, String>>();
        HashMap<String, String> pathSource = new HashMap<String, String>();
        HashMap pathTarget = new HashMap();
        String shimsTableName = viewName;
        if (shimsTableName == null) {
            shimsTableName = CONFIG_HDFS_DEFAULT_SHIMES_TABLE;
        }
        String shimesTablePrefix = "fs.jindo.shim.path-rewrite.";
        for (Map.Entry si : config) {
            String ruleName;
            String key = (String)si.getKey();
            if (!key.startsWith("fs.jindo.shim.path-rewrite.")) continue;
            String src = key.substring("fs.jindo.shim.path-rewrite.".length());
            if (src.endsWith(CONFIG_SOURCE)) {
                ruleName = src.substring(0, CONFIG_SOURCE.length() - 1);
                String pathStr = (String)si.getValue();
                URI uri = URI.create(pathStr);
                if (shimsTableName.equals(uri.getAuthority())) {
                    String pathPrefix = uri.getPath();
                    if (pathPrefix.endsWith("/") && !pathPrefix.trim().equals("/")) {
                        pathPrefix = pathPrefix.substring(0, pathPrefix.length() - 1);
                    }
                    pathSource.put(ruleName, pathPrefix);
                }
            }
            if (!src.endsWith(CONFIG_TARGET)) continue;
            ruleName = src.substring(0, CONFIG_TARGET.length() - 1);
            pathTarget.put(ruleName, si.getValue());
        }
        for (Map.Entry entry : pathSource.entrySet()) {
            String ruleName = (String)entry.getKey();
            String target = (String)pathTarget.get(ruleName);
            if (target == null || target.isEmpty()) continue;
            pathRewriteRule.add(new Pair(entry.getValue(), target));
        }
        return pathRewriteRule;
    }

    private List<Pair<String, String>> initRule(List<Pair<String, String>> pathRewriteRules) throws IOException {
        ArrayList<Pair<String, String>> mappingPaths = new ArrayList<Pair<String, String>>();
        Collections.sort(pathRewriteRules, Comparator.comparingInt(p -> ((String)p.getKey()).length()));
        for (int i = 0; i < pathRewriteRules.size(); ++i) {
            String target = pathRewriteRules.get(i).getValue();
            String source = pathRewriteRules.get(i).getKey();
            URI.create(target);
            boolean conflict = mappingPaths.stream().map(Pair::getKey).filter(mp -> source.equals(mp) || source.startsWith((String)mp) && source.substring(mp.length()).startsWith("/")).map(mp -> {
                LOG.warn("source: " + source + " is ignored by other rule: " + mp);
                return mp;
            }).findFirst().isPresent();
            if (conflict) continue;
            mappingPaths.add(pathRewriteRules.get(i));
            LOG.info(pathRewriteRules.get(i).getKey() + "->" + pathRewriteRules.get(i).getValue());
        }
        return mappingPaths;
    }

    public JindoPathResolver(Configuration conf, String authority) throws IOException {
        for (Pair<String, String> p : this.initRule(this.getRuleRewriteRule(conf, authority))) {
            Path fromPath = new Path(p.getKey());
            String fromPathStr = fromPath.toString();
            Path toRawPath = new Path(p.getValue());
            String toPath = toRawPath.toUri().getPath();
            LOG.info("Initializing path-rewrite rule: " + fromPathStr + " -> " + toRawPath);
            JindoShimsRewriteRule rule = new JindoShimsRewriteRule(fromPathStr, toPath, () -> {
                try {
                    return toRawPath.getFileSystem(conf);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            this.rewriteRule.put(p.getKey(), rule);
            String parentPathStr = fromPath.getParent().toString();
            if (!this.rewriteRoot.containsKey(parentPathStr)) {
                this.rewriteRoot.put(parentPathStr, new ArrayList());
            }
            this.rewriteRoot.get(parentPathStr).add(rule);
        }
    }

    public JindoShimsPath getJindoShimsPath(Path path) {
        if (this.rewriteRule.size() == 0) {
            return null;
        }
        String inputPath = path.toUri().getPath();
        for (String source : this.rewriteRule.keySet()) {
            String subPath;
            if (!inputPath.startsWith(source) || (subPath = inputPath.substring(source.length())).length() != 0 && !subPath.startsWith("/")) continue;
            return new JindoShimsPath(this.rewriteRule.get(source), subPath);
        }
        return null;
    }

    public List<JindoShimsPath> getJindoShimsPathList(Path path) {
        String pathStr = path.toUri().getPath();
        ArrayList<JindoShimsPath> pathList = new ArrayList<JindoShimsPath>();
        List<JindoShimsRewriteRule> rules = this.rewriteRoot.get(pathStr);
        if (rules != null) {
            for (JindoShimsRewriteRule rule : rules) {
                JindoShimsPath shimsPath = new JindoShimsPath(rule, null);
                try {
                    if (shimsPath.getTargetFS().exists(shimsPath.getTargetPath())) {
                        pathList.add(shimsPath);
                        continue;
                    }
                    LOG.warn("WARNING: Path-rewrite target path : " + shimsPath.getTargetPath() + " does not exist. Please set the right path for the source path : " + shimsPath.getRewriteRule().getFromPath());
                }
                catch (IOException e) {
                    LOG.warn("WARNING: Failed to rewrite path by " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return pathList;
    }

    @Override
    public void close() throws IOException {
        IOException ex = null;
        for (JindoShimsRewriteRule value : this.rewriteRule.values()) {
            try {
                if (value.toFileSystem == null) continue;
                value.toFileSystem.close();
            }
            catch (IOException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    static class Pair<K, V>
    implements Serializable {
        private K key;
        private V value;

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        public int hashCode() {
            return this.key.hashCode() * 13 + (this.value == null ? 0 : this.value.hashCode());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Pair) {
                Pair pair = (Pair)o;
                if (this.key != null ? !this.key.equals(pair.key) : pair.key != null) {
                    return false;
                }
                return !(this.value != null ? !this.value.equals(pair.value) : pair.value != null);
            }
            return false;
        }
    }

    public static class JindoShimsRewriteRule {
        String fromPath;
        String toPath;
        Supplier<FileSystem> toFileSystemSupplier;
        FileSystem toFileSystem = null;

        public JindoShimsRewriteRule(String from, String to, Supplier<FileSystem> toFileSystem) {
            this.fromPath = from;
            this.toPath = to;
            this.toFileSystemSupplier = toFileSystem;
        }

        public String getFromPath() {
            return this.fromPath;
        }

        public String getToPath() {
            return this.toPath;
        }

        public FileSystem getToFileSystem() throws IOException {
            if (this.toFileSystem != null) {
                return this.toFileSystem;
            }
            this.initToFileSystem();
            return this.toFileSystem;
        }

        private synchronized void initToFileSystem() throws IOException {
            if (this.toFileSystem == null) {
                try {
                    this.toFileSystem = this.toFileSystemSupplier.get();
                }
                catch (RuntimeException e) {
                    throw new IOException(e.getCause());
                }
            }
        }
    }

    public static class JindoShimsPath {
        JindoShimsRewriteRule rule;
        String sourcePath;

        public JindoShimsPath(JindoShimsRewriteRule rule, String sourcePath) {
            this.rule = rule;
            this.sourcePath = sourcePath;
        }

        public JindoShimsRewriteRule getRewriteRule() {
            return this.rule;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public FileSystem getTargetFS() throws IOException {
            return this.rule.getToFileSystem();
        }

        public Path getTargetPath() {
            if (this.sourcePath == null || this.sourcePath.trim().length() == 0) {
                return new Path(this.rule.toPath);
            }
            return new Path(this.rule.toPath, this.sourcePath.substring(1));
        }

        public Path rewriteToSrcPath(Path path, URI initUri) {
            String currentPath = path.toUri().getPath();
            String fromPrefix = this.getRewriteRule().getToPath();
            String targetPrefix = this.getRewriteRule().getFromPath();
            String remainPart = currentPath.substring(fromPrefix.length());
            if (remainPart.startsWith("/")) {
                remainPart = remainPart.substring(1);
            }
            Path targetPrefixPath = new Path(initUri.getScheme(), initUri.getAuthority(), targetPrefix);
            return new Path(targetPrefixPath, remainPart);
        }
    }
}

