/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.internal.s3;

import com.aliyun.emr.shade.apache_commons_codec.binary.Hex;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.security.MessageDigest;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3Utils {
    static final Logger LOG = LoggerFactory.getLogger(S3Utils.class);
    public static final PathFilter ACCEPT_ALL = new PathFilter(){

        public boolean accept(Path file) {
            return true;
        }

        public String toString() {
            return "ACCEPT_ALL";
        }
    };

    static boolean shouldIgnore(Exception exception) {
        String eMessage = exception.getMessage();
        if (eMessage == null) {
            eMessage = "";
        }
        return eMessage.contains("NoSuchKey");
    }

    static void handleException(String message, Exception e) throws IOException {
        LOG.error(message, (Throwable)e);
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        Throwable cause = e.getCause();
        if (cause != null && cause instanceof IOException) {
            throw (IOException)cause;
        }
        throw new IOException(message, e);
    }

    static Path keyToPath(String key) {
        return new Path(key);
    }

    public static String hashFilePath(String prefix, Path filePath) {
        String fileDir;
        String fileUri = filePath.toUri().toString();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            fileDir = Hex.encodeHexString(md.digest(fileUri.getBytes()));
        }
        catch (Exception e) {
            fileDir = fileUri.replaceAll("/", "_").replace(":", "_");
        }
        String result = prefix + "-" + fileDir;
        return result;
    }

    static String convertToCacheDir(String ... cacheDirParts) {
        boolean skippedFirst = false;
        StringBuilder path = new StringBuilder();
        for (String key : cacheDirParts) {
            if (skippedFirst) {
                path.append("-");
            } else {
                skippedFirst = true;
            }
            path.append(S3Utils.normalize(key));
        }
        return path.toString();
    }

    private static String normalize(String text) {
        return text == null ? "" : text.toLowerCase().trim();
    }

    public static void closeAll(Closeable ... closeables) {
        for (Closeable c : closeables) {
            if (c == null) continue;
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Closing {}", (Object)c);
                }
                c.close();
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Exception in closing {}", (Object)c, (Object)e);
            }
        }
    }

    public static boolean objectRepresentsDirectory(String name, long size) {
        return !name.isEmpty() && name.charAt(name.length() - 1) == '/' && size == 0L;
    }

    public static String maybeAddTrailingSlash(String key) {
        if (!key.isEmpty() && !key.endsWith("/")) {
            return key + '/';
        }
        return key;
    }

    public static String pathToKey(Path path) {
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("Path must be absolute: " + path);
        }
        String absolutePath = path.toUri().getPath();
        return absolutePath.substring(1);
    }

    public static String printS3Path(Path path) {
        if (path == null) {
            return null;
        }
        URI uri = path.toUri();
        LOG.debug("path: " + path + ", uri: " + uri + ", schema :" + uri.getScheme() + ", authority: " + uri.getAuthority() + ", host: " + uri.getHost());
        if (uri.getScheme() != null) {
            return uri.getScheme() + "://" + uri.getHost() + uri.getPath();
        }
        return uri.getPath();
    }
}

