/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.internal.s3native;

import com.alibaba.jboot.JbootS3Writer;
import com.alibaba.jboot.buffer.JbootBufferFactory;
import com.aliyun.emr.buffer.ChunkBuffer;
import com.aliyun.emr.compatibility.StopWatch;
import com.aliyun.emr.fs.s3.common.FsStats;
import com.aliyun.emr.fs.s3.internal.s3native.S3OpContext;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JindoS3OutputStream
extends OutputStream {
    static final Logger LOG = LoggerFactory.getLogger(JindoS3OutputStream.class);
    private boolean closed;
    private final byte[] singleByteBuf = new byte[1];
    private ChunkBuffer writeBuffer;
    private boolean flushed = false;
    private long byteWriten = 0L;
    private long writeElapsedNanos = 0L;
    private S3WriteContext context;

    public JindoS3OutputStream(S3WriteContext context) throws IOException {
        this.context = context;
        this.writeBuffer = new ChunkBuffer(JbootBufferFactory.allocateBuffer(context.bufferSize));
    }

    @Override
    public synchronized void flush() throws IOException {
        LOG.info("Not real flush");
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            if (this.writeBuffer == null) {
                LOG.warn("Write buffer has been released because of former write failure, just do some clean up");
                return;
            }
            if (this.flushed) {
                this.writeOutBuffer();
            } else {
                this.directUpload();
            }
            StopWatch sw = new StopWatch().start();
            this.context.jbootWriter.finalizeFile();
            this.writeElapsedNanos += sw.stop().now();
        }
        catch (IOException e) {
            LOG.error("Close " + this.context.path + " error " + e.getMessage(), (Throwable)e);
            throw new IOException("Close stream " + this.context.path + " error " + e.getMessage(), e);
        }
        finally {
            this.closed = true;
            FsStats.logStats("upload", this.context.path, null, this.byteWriten, null, this.writeElapsedNanos, "3.7.2");
            this.cleanUp();
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.checkStatus();
        this.singleByteBuf[0] = (byte)b;
        this.write(this.singleByteBuf, 0, 1);
    }

    @Override
    public synchronized void write(byte[] buffer, int off, int len) throws IOException {
        this.checkStatus();
        int nWritten = this.writeBuffer.write(buffer, off, len);
        if (nWritten < len) {
            try {
                this.writeOutBuffer();
            }
            catch (Exception e) {
                this.cleanUp();
                throw new IOException("Write offset " + off + ", length " + len + " error: " + e.getMessage(), e);
            }
            this.write(buffer, off + nWritten, len - nWritten);
        }
    }

    protected void finalize() {
        this.cleanUp();
    }

    private void writeOutBuffer() throws IOException {
        this.flushed = true;
        StopWatch sw = new StopWatch().start();
        this.writeBuffer.buffer().flip();
        if (this.writeBuffer.buffer().remaining() > 0) {
            this.context.jbootWriter.write(this.writeBuffer.buffer());
        }
        this.writeBuffer.buffer().position(0);
        this.writeElapsedNanos += sw.stop().now();
        this.byteWriten += (long)this.writeBuffer.buffer().remaining();
    }

    private void directUpload() throws IOException {
        StopWatch sw = new StopWatch().start();
        this.writeBuffer.buffer().flip();
        if (this.writeBuffer.buffer().remaining() > 0) {
            this.context.jbootWriter.directUpload(this.writeBuffer.buffer());
        }
        this.writeBuffer.buffer().position(0);
        this.writeElapsedNanos += sw.stop().now();
        this.byteWriten += (long)this.writeBuffer.buffer().remaining();
    }

    private void checkStatus() throws IOException {
        if (this.closed) {
            throw new IOException("Output stream closed.");
        }
    }

    private void cleanUp() {
        this.context.jbootWriter.close();
        if (this.writeBuffer != null) {
            JbootBufferFactory.returnBuffer(this.writeBuffer.buffer());
            this.writeBuffer = null;
        }
    }

    public static class S3WriteContext
    extends S3OpContext {
        public Path path;
        public int bufferSize;
        public JbootS3Writer jbootWriter;
    }
}

