/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.internal.s3native;

import bigboot.protocol.type.BlockInfoList;
import bigboot.protocol.type.CltGetFileChecksum2Reply;
import bigboot.protocol.type.CltGetFileChecksumReply;
import bigboot.protocol.type.CltInitUploadReply;
import bigboot.protocol.type.CltListMultiUploadReply;
import bigboot.protocol.type.CltUploadPartReply;
import bigboot.protocol.type.FileletCreateReply;
import bigboot.protocol.type.FileletOpenReply;
import bigboot.protocol.type.FileletStatus;
import bigboot.protocol.type.FileletStatusList;
import bigboot.protocol.type.FileletSummary;
import com.alibaba.jboot.JbootFuture;
import com.alibaba.jboot.JbootS3;
import com.alibaba.jboot.JbootS3Reader;
import com.alibaba.jboot.JbootS3Writer;
import com.alibaba.jboot.JbootUtils;
import com.alibaba.jboot.buffer.JbootBufferFactory;
import com.alibaba.jboot.exception.ShouldIgnoreException;
import com.alibaba.jboot.exception.ShouldReturnFalseException;
import com.alibaba.jboot.future.ByteBufferFuture;
import com.alibaba.jboot.protocols.ClientAbortUploadRequestWrapper;
import com.alibaba.jboot.protocols.ClientAtomicCacheRequestWrapper;
import com.alibaba.jboot.protocols.ClientCacheRequestWrapper;
import com.alibaba.jboot.protocols.ClientCheckPermissionRequestWrapper;
import com.alibaba.jboot.protocols.ClientCompleteUploadRequestWrapper;
import com.alibaba.jboot.protocols.ClientDeleteRequestWrapper;
import com.alibaba.jboot.protocols.ClientGetFileChecksum2Wrapper;
import com.alibaba.jboot.protocols.ClientGetFileChecksumWrapper;
import com.alibaba.jboot.protocols.ClientInitUploadRequestWrapper;
import com.alibaba.jboot.protocols.ClientListMultiUploadRequestWrapper;
import com.alibaba.jboot.protocols.ClientListRequestWrapper;
import com.alibaba.jboot.protocols.ClientMkdirRequestWrapper;
import com.alibaba.jboot.protocols.ClientRenameRequestWrapper;
import com.alibaba.jboot.protocols.ClientStatusRequestWrapper;
import com.alibaba.jboot.protocols.ClientUncacheRequestWrapper;
import com.alibaba.jboot.protocols.ClientUploadPartRequestWrapper;
import com.alibaba.jboot.protocols.ClientWriteRequestWrapper;
import com.alibaba.jboot.protocols.FileletCacheCreateRequestWrapper;
import com.alibaba.jboot.protocols.FileletCacheOpenRequestWrapper;
import com.alibaba.jboot.protocols.FileletCheckProgressRequestWrapper;
import com.alibaba.jboot.protocols.GetCacheBlockLocationsRequestWrapper;
import com.alibaba.jfs.JfsSystemBase;
import com.alibaba.jfs.JindoRequestPath;
import com.alibaba.jfs.OssAtomicRenameContext;
import com.alibaba.jfs.OssFlushContext;
import com.aliyun.emr.fs.s3.common.AbstractJindoShimsFileSystem;
import com.aliyun.emr.fs.s3.internal.s3native.HadoopLoginUserInfo;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.FileAlreadyExistsException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class S3FileletSystem
extends JfsSystemBase {
    private JbootS3 jbootS3 = new JbootS3();

    public S3FileletSystem() {
        super(new HadoopLoginUserInfo());
    }

    public void write(JindoRequestPath path, ByteBuffer buffer) throws IOException {
        if (JbootUtils.isEmpty(path.getPath())) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new ClientWriteRequestWrapper(this.ugi, path).toDirectBuffer();
        JbootFuture f = this.asyncWrite(request, buffer);
        try {
            f.get();
            return;
        }
        catch (ExecutionException ee) {
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException("Write failed: " + path.getPath() + " . " + buffer.position() + ":" + buffer.limit(), e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public JbootFuture asyncWrite(ByteBuffer request, ByteBuffer buffer) throws IOException {
        JbootFuture jbootFuture;
        JbootFuture future = jbootFuture = this.jbootS3.putObject(request, buffer);
        return future;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String initUpload(JindoRequestPath path) throws IOException {
        String string;
        if (JbootUtils.isEmpty(path.getPath())) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new ClientInitUploadRequestWrapper(this.ugi, path).toDirectBuffer();
        ByteBuffer result = null;
        try {
            ByteBufferFuture f = new ByteBufferFuture(this.jbootS3.initUploadObject(request));
            result = f.get();
            CltInitUploadReply reply = CltInitUploadReply.getRootAsCltInitUploadReply(result);
            string = reply.uploadId();
        }
        catch (ExecutionException ee) {
            try {
                throw new IOException(ee.getCause());
                catch (Exception e) {
                    throw new IOException("Init upload failed", e);
                }
            }
            catch (Throwable throwable) {
                JbootBufferFactory.returnBuffer(request);
                if (result != null) {
                    JbootBufferFactory.returnBuffer(result);
                }
                throw throwable;
            }
        }
        JbootBufferFactory.returnBuffer(request);
        if (result != null) {
            JbootBufferFactory.returnBuffer(result);
        }
        return string;
    }

    public CltUploadPartReply uploadPart(JindoRequestPath path, String uploadId, int partNum, ByteBuffer buffer) throws IOException {
        if (JbootUtils.isEmpty(path.getPath()) || JbootUtils.isEmpty(uploadId) || partNum < 0) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new ClientUploadPartRequestWrapper(this.ugi, path, uploadId, partNum).toDirectBuffer();
        try {
            ByteBufferFuture f = new ByteBufferFuture(this.jbootS3.uploadPart(request, buffer));
            ByteBuffer result = f.get();
            CltUploadPartReply cltUploadPartReply = CltUploadPartReply.getRootAsCltUploadPartReply(result);
            return cltUploadPartReply;
        }
        catch (ExecutionException ee) {
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException("Upload part failed", e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public void completeUpload(JindoRequestPath path, String uploadId, ByteBuffer partList) throws IOException {
        if (JbootUtils.isEmpty(path.getPath()) || JbootUtils.isEmpty(uploadId) || partList == null) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new ClientCompleteUploadRequestWrapper(this.ugi, path, uploadId, partList).toDirectBuffer();
        try {
            JbootFuture f = this.jbootS3.completeUploadObject(request);
            f.get();
            return;
        }
        catch (ExecutionException ee) {
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException("Complete upload failed", e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public CltListMultiUploadReply listMultipartUpload(JindoRequestPath path) throws IOException {
        if (JbootUtils.isEmpty(path.getPath())) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new ClientListMultiUploadRequestWrapper(this.ugi, path).toDirectBuffer();
        try {
            ByteBufferFuture f = new ByteBufferFuture(this.jbootS3.listMultipartUpload(request));
            ByteBuffer result = f.get();
            CltListMultiUploadReply cltListMultiUploadReply = CltListMultiUploadReply.getRootAsCltListMultiUploadReply(result);
            return cltListMultiUploadReply;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof FileNotFoundException) {
                throw (FileNotFoundException)ee.getCause();
            }
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException("Get status failed", e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public void abortUpload(JindoRequestPath path, String uploadId) throws IOException {
        if (JbootUtils.isEmpty(path.getPath()) || JbootUtils.isEmpty(uploadId)) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new ClientAbortUploadRequestWrapper(this.ugi, path, uploadId).toDirectBuffer();
        try {
            JbootFuture f = this.jbootS3.abortUploadObject(request);
            f.get();
            return;
        }
        catch (ExecutionException ee) {
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException("Abort upload failed", e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public void mkdir(JindoRequestPath path) throws IOException {
        if (JbootUtils.isEmpty(path.getPath())) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new ClientMkdirRequestWrapper(this.ugi, path).toDirectBuffer();
        try {
            JbootFuture f = this.jbootS3.mkdir(request);
            f.get();
            return;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof FileAlreadyExistsException) {
                throw (FileAlreadyExistsException)ee.getCause();
            }
            throw new IOException("Mkdir failed on :" + path.getPath(), ee.getCause());
        }
        catch (Exception e) {
            throw new IOException("Mkdir failed on :" + path.getPath(), e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public boolean rename(JindoRequestPath srcPath, String dstPath, long copyPartSize, boolean atomicRename, boolean appendName, boolean ignoreHidden, int batchSize, boolean prefixLink, OssAtomicRenameContext s3AtomicRenameContext) throws IOException {
        if (JbootUtils.isEmpty(srcPath.getPath()) || JbootUtils.isEmpty(dstPath)) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new ClientRenameRequestWrapper(this.ugi, srcPath, dstPath, appendName, ignoreHidden, copyPartSize, atomicRename, batchSize, prefixLink, s3AtomicRenameContext).toDirectBuffer();
        try {
            JbootFuture f = this.jbootS3.rename(request);
            f.get();
            boolean bl = true;
            return bl;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof FileNotFoundException) {
                boolean bl = false;
                return bl;
            }
            if (ee.getCause() instanceof FileAlreadyExistsException) {
                throw (FileAlreadyExistsException)ee.getCause();
            }
            if (ee.getCause() instanceof ShouldReturnFalseException) {
                boolean bl = false;
                return bl;
            }
            if (ee.getCause() instanceof ShouldIgnoreException) {
                boolean bl = true;
                return bl;
            }
            throw new IOException("rename src:" + srcPath.getPath() + ", dst:" + dstPath + "," + ee.getMessage(), ee.getCause());
        }
        catch (Exception e) {
            throw new IOException("Rename failed", e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public boolean delete(JindoRequestPath path, boolean recursive, boolean deleteWithVersions) throws IOException {
        if (JbootUtils.isEmpty(path.getPath())) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new ClientDeleteRequestWrapper(this.ugi, path, recursive, false, deleteWithVersions).toDirectBuffer();
        try {
            JbootFuture f = this.jbootS3.delete(request);
            f.get();
            boolean bl = true;
            return bl;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof FileNotFoundException) {
                throw (FileNotFoundException)ee.getCause();
            }
            if (ee.getCause() instanceof ShouldReturnFalseException) {
                boolean bl = false;
                return bl;
            }
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException("Delete failed", e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public FileletCreateReply create(JindoRequestPath path, JbootS3Writer jbootWriter, String storageOption, OssFlushContext flushContext, int bufferSize) throws IOException {
        if (JbootUtils.isEmpty(path.getPath())) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new FileletCacheCreateRequestWrapper(this.ugi, path, storageOption, flushContext, bufferSize).toDirectBuffer();
        ByteBuffer result = null;
        try {
            ByteBufferFuture f = new ByteBufferFuture(this.jbootS3.create(request, jbootWriter));
            result = f.get();
            FileletCreateReply fileletCreateReply = FileletCreateReply.getRootAsFileletCreateReply(result);
            return fileletCreateReply;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof FileNotFoundException) {
                throw (FileNotFoundException)ee.getCause();
            }
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException("Create failed", e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public FileletCreateReply create(JindoRequestPath path, JbootS3Writer jbootWriter, String storageOption, String checksumInfo, OssFlushContext flushContext, int bufferSize) throws IOException {
        if (JbootUtils.isEmpty(path.getPath())) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new FileletCacheCreateRequestWrapper(this.ugi, path, storageOption, checksumInfo, flushContext, bufferSize).toDirectBuffer();
        ByteBuffer result = null;
        try {
            ByteBufferFuture f = new ByteBufferFuture(this.jbootS3.create(request, jbootWriter));
            result = f.get();
            FileletCreateReply fileletCreateReply = FileletCreateReply.getRootAsFileletCreateReply(result);
            return fileletCreateReply;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof FileNotFoundException) {
                throw (FileNotFoundException)ee.getCause();
            }
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException("Open failed", e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public FileletOpenReply open(JindoRequestPath path, JbootS3Reader jbootReader, boolean s3Only, boolean dataVerify, int bufferSize) throws IOException {
        if (JbootUtils.isEmpty(path.getPath())) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new FileletCacheOpenRequestWrapper(this.ugi, path, s3Only, dataVerify, bufferSize).toDirectBuffer();
        try {
            ByteBufferFuture f = new ByteBufferFuture(this.jbootS3.open(request, jbootReader));
            ByteBuffer result = f.get();
            FileletOpenReply fileletOpenReply = FileletOpenReply.getRootAsFileletOpenReply(result);
            return fileletOpenReply;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof FileNotFoundException) {
                throw (FileNotFoundException)ee.getCause();
            }
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException("Open failed", e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public FileletStatus getStatus(JindoRequestPath path, boolean lsExtend) throws IOException {
        if (JbootUtils.isEmpty(path.getPath())) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new ClientStatusRequestWrapper(this.ugi, path, lsExtend).toDirectBuffer();
        try {
            FileletStatus s;
            ByteBufferFuture f = new ByteBufferFuture(this.jbootS3.getStatus(request));
            ByteBuffer result = f.get();
            FileletStatus fileletStatus = s = FileletStatus.getRootAsFileletStatus(result);
            return fileletStatus;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof FileNotFoundException) {
                throw (FileNotFoundException)ee.getCause();
            }
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException("Get status failed", e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public FileletStatusList listStatus(JindoRequestPath path, boolean recursive, boolean isSummary) throws IOException {
        if (JbootUtils.isEmpty(path.getPath())) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new ClientListRequestWrapper(this.ugi, path, recursive, isSummary).toDirectBuffer();
        try {
            ByteBufferFuture f = new ByteBufferFuture(this.jbootS3.list(request));
            ByteBuffer result = f.get();
            FileletStatusList fileletStatusList = FileletStatusList.getRootAsFileletStatusList(result);
            return fileletStatusList;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof FileNotFoundException) {
                throw (FileNotFoundException)ee.getCause();
            }
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException("Get status failed", e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public BlockInfoList getFileBlockLocations(JindoRequestPath path, String etag, long start, long len, long logicBlockSize) throws IOException {
        ByteBuffer request = new GetCacheBlockLocationsRequestWrapper(this.ugi, path, etag, start, len, logicBlockSize).toDirectBuffer();
        try {
            ByteBufferFuture future = new ByteBufferFuture(this.jbootS3.getFileBlockLocations(request));
            ByteBuffer result = future.get(60L, TimeUnit.SECONDS);
            if (result == null) {
                BlockInfoList blockInfoList = null;
                return blockInfoList;
            }
            BlockInfoList blockInfoList = BlockInfoList.getRootAsBlockInfoList(result);
            return blockInfoList;
        }
        catch (ExecutionException ee) {
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public boolean checkPermission(JindoRequestPath path, boolean doCheckOwner, short parentAccess, short access) throws IOException {
        if (JbootUtils.isEmpty(path.getPath())) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new ClientCheckPermissionRequestWrapper(this.ugi, path, doCheckOwner, parentAccess, access).toDirectBuffer();
        try {
            JbootFuture jbootFuture;
            JbootFuture f = jbootFuture = this.jbootS3.checkPermission(request);
            f.get(60L, TimeUnit.SECONDS);
            boolean bl = true;
            return bl;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof FileNotFoundException) {
                throw (FileNotFoundException)ee.getCause();
            }
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException("Get status failed", e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public boolean cache(JindoRequestPath path, AbstractJindoShimsFileSystem.CacheOpContext opContext, long timeoutInSeconds) throws IOException {
        ByteBuffer request = new ClientCacheRequestWrapper(this.ugi, path, opContext.shouldPin, opContext.shouldLoadMemory, opContext.sync, opContext.smallfile, opContext.fileBatchSize, opContext.replica).toDirectBuffer();
        boolean rpc_succeed = false;
        try {
            JbootFuture jbootFuture;
            int retryCount = 0;
            JbootFuture future = jbootFuture = this.jbootS3.cache(request);
            try {
                JbootFuture.checkFuture(future, timeoutInSeconds);
                rpc_succeed = true;
                JbootUtils.logRetrySuccess("cache", retryCount);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                IOException lastException = e;
                throw lastException;
            }
        }
        finally {
            if (rpc_succeed) {
                JbootBufferFactory.returnBuffer(request);
            }
        }
    }

    public boolean atomicCache(JindoRequestPath path, AbstractJindoShimsFileSystem.CacheOpContext opContext, long timeoutInSeconds) throws IOException {
        ByteBuffer request = new ClientAtomicCacheRequestWrapper(this.ugi, path, opContext.recursive, opContext.shouldPin, opContext.shouldLoadMemory, opContext.smallfile, opContext.replica, opContext.dataCache).toDirectBuffer();
        boolean rpc_succeed = false;
        try {
            JbootFuture jbootFuture;
            int retryCount = 0;
            JbootFuture future = jbootFuture = this.jbootS3.atomicCache(request);
            try {
                JbootFuture.checkFuture(future, timeoutInSeconds);
                rpc_succeed = true;
                JbootUtils.logRetrySuccess("atomicCache", retryCount);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                IOException lastException = e;
                throw lastException;
            }
        }
        finally {
            if (rpc_succeed) {
                JbootBufferFactory.returnBuffer(request);
            }
        }
    }

    public boolean uncache(JindoRequestPath path, long timeoutInSeconds) throws IOException {
        ByteBuffer request = new ClientUncacheRequestWrapper(this.ugi, path).toDirectBuffer();
        boolean rpc_succeed = false;
        try {
            JbootFuture jbootFuture;
            int retryCount = 0;
            JbootFuture future = jbootFuture = this.jbootS3.uncache(request);
            try {
                JbootFuture.checkFuture(future, timeoutInSeconds);
                rpc_succeed = true;
                JbootUtils.logRetrySuccess("uncache", retryCount);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                IOException lastException = e;
                throw lastException;
            }
        }
        finally {
            if (rpc_succeed) {
                JbootBufferFactory.returnBuffer(request);
            }
        }
    }

    public FileletStatusList checkProgress(JindoRequestPath path, boolean detailed, long timeoutInSeconds) throws IOException {
        if (JbootUtils.isEmpty(path.getPath())) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new FileletCheckProgressRequestWrapper(this.ugi, path, detailed).toDirectBuffer();
        try {
            ByteBufferFuture f = new ByteBufferFuture(this.jbootS3.checkProgress(request));
            ByteBuffer result = f.get();
            FileletStatusList fileletStatusList = FileletStatusList.getRootAsFileletStatusList(result);
            return fileletStatusList;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof FileNotFoundException) {
                throw (FileNotFoundException)ee.getCause();
            }
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException("List failed", e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    /*
     * Exception decompiling
     */
    public FileletSummary getContentSummary(JindoRequestPath path, int batchSize) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getFileChecksum(JindoRequestPath path) throws IOException {
        if (JbootUtils.isEmpty(path.getPath())) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new ClientGetFileChecksumWrapper(this.ugi, path).toDirectBuffer();
        try {
            ByteBufferFuture f = new ByteBufferFuture(this.jbootS3.getFileChecksum(request));
            ByteBuffer result = f.get();
            CltGetFileChecksumReply reply = CltGetFileChecksumReply.getRootAsCltGetFileChecksumReply(result);
            String string = reply.checksum();
            return string;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof FileNotFoundException) {
                throw (FileNotFoundException)ee.getCause();
            }
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException("getFileChecksum failed", e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public String getFileChecksum2(JindoRequestPath path) throws IOException {
        if (JbootUtils.isEmpty(path.getPath())) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new ClientGetFileChecksum2Wrapper(this.ugi, path).toDirectBuffer();
        try {
            ByteBufferFuture f = new ByteBufferFuture(this.jbootS3.getFileChecksum2(request));
            ByteBuffer result = f.get();
            CltGetFileChecksum2Reply reply = CltGetFileChecksum2Reply.getRootAsCltGetFileChecksum2Reply(result);
            String string = reply.checksum();
            return string;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof FileNotFoundException) {
                throw (FileNotFoundException)ee.getCause();
            }
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException("getFileChecksum2 failed", e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public IOException wrapIOException(ExecutionException ee) {
        if (ee.getCause() instanceof IOException) {
            return (IOException)ee.getCause();
        }
        return new IOException(ee.getCause());
    }
}

