/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.internal.s3native;

import com.alibaba.jfs.CredentialContext;
import com.alibaba.jfs.JindoRequestPath;
import com.aliyun.emr.fs.s3.internal.s3native.S3OpContext;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3GetFileChecksumOp {
    static final Logger LOG = LoggerFactory.getLogger(S3GetFileChecksumOp.class);
    private final S3OpContext context;
    private final FileSystem fs;
    private final CredentialContext s3Context;

    public S3GetFileChecksumOp(S3OpContext context, FileSystem fs, CredentialContext s3Context) {
        this.context = context;
        this.fs = fs;
        this.s3Context = s3Context;
    }

    public String getFileChecksum(Path f, CredentialContext s3Context) throws IOException {
        try {
            return this.context.s3FileletSystem.getFileChecksum(new JindoRequestPath(f.toString(), s3Context));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }
}

