/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.internal.s3native;

import bigboot.protocol.type.BlockInfo;
import bigboot.protocol.type.BlockInfoList;
import bigboot.protocol.type.FileletCreateReply;
import bigboot.protocol.type.FileletOpenReply;
import bigboot.protocol.type.FileletStatus;
import bigboot.protocol.type.FileletStatusList;
import bigboot.protocol.type.FileletSummary;
import bigboot.protocol.type.StringList;
import com.alibaba.jboot.JbootNative;
import com.alibaba.jboot.JbootS3Reader;
import com.alibaba.jboot.JbootS3Writer;
import com.alibaba.jboot.buffer.JbootBufferFactory;
import com.alibaba.jboot.google.flatbuffers.Table;
import com.alibaba.jfs.CredentialContext;
import com.alibaba.jfs.JindoRequestPath;
import com.alibaba.jfs.OssAtomicRenameContext;
import com.alibaba.jfs.OssFlushContext;
import com.aliyun.emr.fs.s3.auth.AuthUtils;
import com.aliyun.emr.fs.s3.auth.S3CredentialProviderList;
import com.aliyun.emr.fs.s3.auth.S3CredentialsProvider;
import com.aliyun.emr.fs.s3.commit.magic.JindoS3MagicOutputStream;
import com.aliyun.emr.fs.s3.commit.magic.MagicCommitPaths;
import com.aliyun.emr.fs.s3.common.AbstractJindoShimsFileSystem;
import com.aliyun.emr.fs.s3.common.Utils;
import com.aliyun.emr.fs.s3.internal.AbstractFileSystemStore;
import com.aliyun.emr.fs.s3.internal.jfs.Crc32FileChecksum;
import com.aliyun.emr.fs.s3.internal.jfs.Crc64FileChecksum;
import com.aliyun.emr.fs.s3.internal.s3.S3Utils;
import com.aliyun.emr.fs.s3.internal.s3native.JindoS3InputStream;
import com.aliyun.emr.fs.s3.internal.s3native.JindoS3OutputStream;
import com.aliyun.emr.fs.s3.internal.s3native.JindoS3RecoverableOutputStream;
import com.aliyun.emr.fs.s3.internal.s3native.S3CredentialUtils;
import com.aliyun.emr.fs.s3.internal.s3native.S3DeleteOp;
import com.aliyun.emr.fs.s3.internal.s3native.S3FileStatus;
import com.aliyun.emr.fs.s3.internal.s3native.S3FileletSystem;
import com.aliyun.emr.fs.s3.internal.s3native.S3GetFileChecksum2Op;
import com.aliyun.emr.fs.s3.internal.s3native.S3GetFileChecksumOp;
import com.aliyun.emr.fs.s3.internal.s3native.S3GetFileStatusOp;
import com.aliyun.emr.fs.s3.internal.s3native.S3ListStatusOp;
import com.aliyun.emr.fs.s3.internal.s3native.S3OpContext;
import com.aliyun.emr.fs.s3.internal.s3native.S3RenameOp;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3NativeStore
extends AbstractFileSystemStore {
    public static final Logger LOG = LoggerFactory.getLogger(S3NativeStore.class);
    private int writeBufferSize;
    private int readBufferSize;
    private boolean enableBlockLocation;
    private long logicBlockSize;
    private boolean magicEnabled = false;
    private String magicUUID = null;
    private int contentSummaryBatchCount;
    private boolean dataVerify;
    private boolean allowFileOverwriteFolder;
    private S3OpBuilder s3OpBuilder;
    private final String version = "3.7.2";
    private Context context;
    private URI finalUri;
    private S3CredentialProviderList providers = null;
    private CredentialContext s3Context;
    private boolean isToken = false;
    private OssFlushContext flushContext = null;

    public S3NativeStore(FileSystem fs, Configuration conf, Context context) throws IOException {
        super(fs, conf, context);
        this.context = context;
        try {
            String logName = JbootNative.instance().getLogName();
            LOG.info("Jboot log name is {}", (Object)logName);
            this.context.logName = logName;
        }
        catch (Throwable e) {
            LOG.info("NativeLibrary of Jindo is not available, you can ignore if you are not using jindo fs and cache.");
        }
        if (context.credentialProviders != null) {
            this.providers = context.credentialProviders;
        } else if (fs.getScheme().equals("s3") || fs.getScheme().equals("s3a") || fs.getScheme().equals("s3n") || fs.getScheme().equals("cos") || fs.getScheme().equals("obs")) {
            this.providers = AuthUtils.createCredentialProviderSet(context.uri, conf, S3CredentialsProvider.CredentialType.S3);
        } else if (fs.getScheme().equals("jfs")) {
            this.providers = AuthUtils.createCredentialProviderSet(context.uri, conf, S3CredentialsProvider.CredentialType.JFS);
        } else {
            throw new IOException("Unsupported file system: " + fs.getScheme());
        }
        LOG.debug("Using credential provider {}", (Object)this.providers);
        this.s3Context = S3CredentialUtils.createS3CredentialContext(conf, context.uri, this.providers);
        this.finalUri = S3CredentialUtils.createFinallyURI(context.uri, conf, fs.getScheme(), this.s3Context);
        this.s3OpBuilder = new S3OpBuilder();
        int bufferSize = conf.getInt("fs.jfs.cache.write.buffer.size", 0x100000);
        this.writeBufferSize = this.allignBufferSize(bufferSize);
        bufferSize = conf.getInt("fs.jfs.cache.read.buffer.size", 0x100000);
        this.readBufferSize = this.allignBufferSize(bufferSize);
        this.enableBlockLocation = conf.getBoolean("fs.jfs.cache.block.location.enable", false);
        this.logicBlockSize = conf.getLong("fs.jfs.cache.s3-blocksize", 0x8000000L);
        this.magicEnabled = conf.getBoolean("fs.s3.committer.magic.enabled", false);
        this.magicUUID = conf.get("fs.s3.committer.magic.job.uuid", null);
        this.allowFileOverwriteFolder = conf.getBoolean("fs.jfs.cache.allow-file-overwrite-folder", true);
        this.contentSummaryBatchCount = conf.getInt("fs.jfs.cache.get-summary.batch-size", 1000);
        this.dataVerify = conf.getBoolean("fs.jfs.cache.data.verify.enable", true);
        if (this.contentSummaryBatchCount > 1000) {
            LOG.info("fs.jfs.cache.get-summary.batch-size=" + this.contentSummaryBatchCount + ", is larger than maxValue: " + 1000);
            this.contentSummaryBatchCount = 1000;
        }
        boolean usePool = conf.getBoolean("fs.jfs.cache.buffer.pool", false);
        JbootBufferFactory.setUsePool(usePool);
        this.s3Context.enableHiveFastRename = conf.getBoolean("fs.jfs.cache.hive-fast-move", false);
        this.s3Context.useSLD = conf.getBoolean("fs.jfs.cache.use-second-level-domain", false);
        LOG.info("Filesystem support for magic committers {} enabled, write buffer size {}, read buffer size {}", new Object[]{this.magicEnabled ? "is" : "is not", this.writeBufferSize, this.readBufferSize});
    }

    public Path qualifyPath(Path path) {
        if (this.fs.getScheme().equals("jfs")) {
            return path;
        }
        Path finalPath = Utils.qualifyPath(path, this.finalUri, this.context.workingDir);
        return finalPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FSDataOutputStream create(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress, String storageOption) throws IOException {
        Path finalPath = this.qualifyPath(path);
        this.checkFileWritable(finalPath, overwrite);
        Table reply = null;
        try {
            OutputStream outputStream;
            if (this.magicEnabled && MagicCommitPaths.isMagicCommitPath(finalPath, this.magicUUID)) {
                Path destPath = MagicCommitPaths.pathOfFinalDestination(finalPath, this.finalUri.getAuthority(), this.magicUUID);
                String pendingSetPath = finalPath.toString() + ".pending";
                JindoS3MagicOutputStream.S3MagicWriteContext magicWriteContext = new JindoS3MagicOutputStream.S3MagicWriteContext();
                JbootS3Writer jbootWriter = new JbootS3Writer(this.context.s3FileletSystem.getUgi(), new JindoRequestPath(destPath.toString(), this.s3Context));
                reply = this.context.s3FileletSystem.create(new JindoRequestPath(destPath.toString(), this.s3Context), jbootWriter, storageOption, this.flushContext, this.writeBufferSize);
                int realBufferSize = ((FileletCreateReply)reply).bufferSize();
                this.initContext(magicWriteContext);
                magicWriteContext.bucket = this.context.uri.getHost();
                magicWriteContext.path = finalPath.toString();
                magicWriteContext.destPath = destPath.toString();
                magicWriteContext.pendingPath = pendingSetPath;
                magicWriteContext.jbootWriter = jbootWriter;
                magicWriteContext.bufferSize = realBufferSize;
                outputStream = new JindoS3MagicOutputStream(magicWriteContext, this.s3Context);
            } else {
                JbootS3Writer jbootWriter = new JbootS3Writer(this.context.s3FileletSystem.getUgi(), new JindoRequestPath(finalPath.toString(), this.s3Context));
                reply = this.context.s3FileletSystem.create(new JindoRequestPath(finalPath.toString(), this.s3Context), jbootWriter, storageOption, this.flushContext, this.writeBufferSize);
                int realBufferSize = ((FileletCreateReply)reply).bufferSize();
                JindoS3OutputStream.S3WriteContext writeContext = new JindoS3OutputStream.S3WriteContext();
                this.initContext(writeContext);
                writeContext.path = finalPath;
                writeContext.key = S3Utils.pathToKey(finalPath);
                writeContext.bufferSize = realBufferSize;
                writeContext.jbootWriter = jbootWriter;
                outputStream = new JindoS3OutputStream(writeContext);
            }
            FSDataOutputStream fSDataOutputStream = new FSDataOutputStream(outputStream, this.context.statistics);
            return fSDataOutputStream;
        }
        finally {
            if (reply != null) {
                JbootBufferFactory.returnBuffer(reply.getByteBuffer());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FSDataOutputStream create(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress, String storageOption, String checksumInfo) throws IOException {
        Path finalPath = this.qualifyPath(path);
        this.checkFileWritable(finalPath, overwrite);
        Table reply = null;
        try {
            OutputStream outputStream;
            if (this.magicEnabled && MagicCommitPaths.isMagicCommitPath(finalPath, this.magicUUID)) {
                Path destPath = MagicCommitPaths.pathOfFinalDestination(finalPath, this.finalUri.getAuthority(), this.magicUUID);
                String pendingSetPath = finalPath.toString() + ".pending";
                JindoS3MagicOutputStream.S3MagicWriteContext magicWriteContext = new JindoS3MagicOutputStream.S3MagicWriteContext();
                JbootS3Writer jbootWriter = new JbootS3Writer(this.context.s3FileletSystem.getUgi(), new JindoRequestPath(destPath.toString(), this.s3Context));
                reply = this.context.s3FileletSystem.create(new JindoRequestPath(destPath.toString(), this.s3Context), jbootWriter, storageOption, checksumInfo, this.flushContext, this.writeBufferSize);
                int realBufferSize = ((FileletCreateReply)reply).bufferSize();
                this.initContext(magicWriteContext);
                magicWriteContext.bucket = this.context.uri.getHost();
                magicWriteContext.path = finalPath.toString();
                magicWriteContext.destPath = destPath.toString();
                magicWriteContext.pendingPath = pendingSetPath;
                magicWriteContext.jbootWriter = jbootWriter;
                magicWriteContext.bufferSize = realBufferSize;
                outputStream = new JindoS3MagicOutputStream(magicWriteContext, this.s3Context);
            } else if (this.flushContext.flushEnabled) {
                JbootS3Writer jbootWriter = new JbootS3Writer(this.context.s3FileletSystem.getUgi(), new JindoRequestPath(finalPath.toString(), this.s3Context));
                reply = this.context.s3FileletSystem.create(new JindoRequestPath(finalPath.toString(), this.s3Context), jbootWriter, storageOption, checksumInfo, this.flushContext, this.writeBufferSize);
                int realBufferSize = ((FileletCreateReply)reply).bufferSize();
                JindoS3RecoverableOutputStream.S3WriteContext writeContext = new JindoS3RecoverableOutputStream.S3WriteContext();
                this.initContext(writeContext);
                writeContext.path = finalPath;
                writeContext.key = S3Utils.pathToKey(finalPath);
                writeContext.bufferSize = realBufferSize;
                writeContext.jbootWriter = jbootWriter;
                outputStream = new JindoS3RecoverableOutputStream(writeContext);
            } else {
                JbootS3Writer jbootWriter = new JbootS3Writer(this.context.s3FileletSystem.getUgi(), new JindoRequestPath(finalPath.toString(), this.s3Context));
                reply = this.context.s3FileletSystem.create(new JindoRequestPath(finalPath.toString(), this.s3Context), jbootWriter, storageOption, checksumInfo, this.flushContext, this.writeBufferSize);
                int realBufferSize = ((FileletCreateReply)reply).bufferSize();
                JindoS3OutputStream.S3WriteContext writeContext = new JindoS3OutputStream.S3WriteContext();
                this.initContext(writeContext);
                writeContext.path = finalPath;
                writeContext.key = S3Utils.pathToKey(finalPath);
                writeContext.bufferSize = realBufferSize;
                writeContext.jbootWriter = jbootWriter;
                outputStream = new JindoS3OutputStream(writeContext);
            }
            FSDataOutputStream fSDataOutputStream = new FSDataOutputStream(outputStream, this.context.statistics);
            return fSDataOutputStream;
        }
        finally {
            if (reply != null) {
                JbootBufferFactory.returnBuffer(reply.getByteBuffer());
            }
        }
    }

    private void checkFileWritable(Path f, boolean overwrite) throws IOException {
        if (overwrite && this.allowFileOverwriteFolder) {
            return;
        }
        try {
            S3FileStatus status = this.getFileStatusInternal(f, false);
            if (status.isDir()) {
                throw new FileAlreadyExistsException(f + " is a directory");
            }
            if (!overwrite) {
                throw new FileAlreadyExistsException(f + " already exists");
            }
            this.getFileStatusInternal(f, false);
            throw new FileAlreadyExistsException(f + " already exists");
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
    }

    @Override
    public boolean delete(Path path, boolean recurse, boolean ignoreHidden, boolean deleteVersion) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        return this.deleteInternal(qualifiedPath, recurse, deleteVersion);
    }

    public boolean deleteInternal(Path f, boolean recurse, boolean deleteVersion) throws IOException {
        try {
            return this.s3OpBuilder.createDeleteOperation().delete(f, recurse, false, this.s3Context);
        }
        catch (FileNotFoundException e) {
            LOG.debug("Delete called for '" + f + "' but file does not exist, so returning false");
            return false;
        }
    }

    private static List<String> getJindoPathComponents(String path) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        for (String component : path.split("/")) {
            if (component.isEmpty()) continue;
            ret.add(component);
        }
        return ret;
    }

    @Override
    public FileStatus getFileStatus(Path path) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        S3FileStatus fileStatus = this.getFileStatusInternal(qualifiedPath, false);
        this.qualifyStatusResult(fileStatus);
        return fileStatus;
    }

    public S3FileStatus getS3FileStatus(Path path) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        S3FileStatus fileStatus = this.getFileStatusInternal(qualifiedPath, true);
        this.qualifyStatusResult(fileStatus);
        return fileStatus;
    }

    private S3FileStatus getFileStatusInternal(Path qualifiedPath, boolean lsExtend) throws IOException {
        if (qualifiedPath.toString().endsWith("/") && qualifiedPath.getParent() != null) {
            qualifiedPath = qualifiedPath.getParent();
        }
        return this.s3OpBuilder.createGetFileStatusOperation().getFileStatus(qualifiedPath, lsExtend);
    }

    private void qualifyStatusResult(FileStatus fileStatus) {
        Path finalPath = Utils.qualifyPath(fileStatus.getPath(), this.context.uri, this.context.workingDir);
        fileStatus.setPath(finalPath);
    }

    @Override
    public FileStatus[] listStatus(Path path, boolean recursive, boolean isCmd) throws IOException {
        FileStatus[] result;
        if (recursive) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support recursive listStatus.");
        }
        Path qualifiedPath = this.qualifyPath(path);
        for (FileStatus status : result = this.s3OpBuilder.createListStatusOperation().listStatus(qualifiedPath)) {
            this.qualifyStatusResult(status);
        }
        return result;
    }

    private FileStatus[] listStatusWithoutCreateTime(Path path) throws IOException {
        FileStatus[] result;
        Path qualifiedPath = this.qualifyPath(path);
        for (FileStatus status : result = this.s3OpBuilder.createListStatusOperation().listStatus(qualifiedPath, false, false, true)) {
            this.qualifyStatusResult(status);
        }
        return result;
    }

    @Override
    public RemoteIterator<LocatedFileStatus> listLocatedStatus(final Path qualifiedPath, final PathFilter filter) throws IOException {
        return new RemoteIterator<LocatedFileStatus>(){
            private final FileStatus[] stats;
            private int i;
            {
                this.stats = S3NativeStore.this.listStatus(qualifiedPath, false, false);
                this.i = 0;
            }

            public boolean hasNext() {
                while (this.i < this.stats.length) {
                    if (filter.accept(this.stats[this.i].getPath())) {
                        return true;
                    }
                    ++this.i;
                }
                return false;
            }

            public LocatedFileStatus next() throws IOException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more entry in " + qualifiedPath);
                }
                FileStatus result = this.stats[this.i++];
                BlockLocation[] locs = null;
                if (result.isFile()) {
                    if (S3NativeStore.this.enableBlockLocation) {
                        locs = S3NativeStore.this.getFileBlockLocations(result, 0L, result.getLen());
                    }
                    if (locs == null) {
                        String[] name = new String[]{"localhost:50010"};
                        String[] host = new String[]{"localhost"};
                        locs = new BlockLocation[]{new BlockLocation(name, host, 0L, result.getLen())};
                    }
                }
                return new LocatedFileStatus(result, locs);
            }
        };
    }

    @Override
    public boolean mkdirs(Path path, FsPermission permission) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        try {
            this.context.s3FileletSystem.mkdir(new JindoRequestPath(qualifiedPath.toString(), this.s3Context));
            return true;
        }
        catch (java.nio.file.FileAlreadyExistsException e) {
            throw new FileAlreadyExistsException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        int realBufferSize;
        Path qualifiedPath = this.qualifyPath(f);
        Table reply = null;
        S3FileStatus status = null;
        JbootS3Reader jbootReader = new JbootS3Reader(this.context.s3FileletSystem.getUgi(), new JindoRequestPath(qualifiedPath.toString(), this.s3Context));
        try {
            reply = this.context.s3FileletSystem.open(new JindoRequestPath(qualifiedPath.toString(), this.s3Context), jbootReader, false, this.dataVerify, this.readBufferSize);
            FileletStatus fileletStatus = ((FileletOpenReply)reply).statusAsFileletStatus();
            status = new S3FileStatus(fileletStatus, this.conf);
            realBufferSize = ((FileletOpenReply)reply).bufferSize();
        }
        finally {
            if (reply != null) {
                JbootBufferFactory.returnBuffer(reply.getByteBuffer());
            }
        }
        if (status.isDir()) {
            throw new FileNotFoundException("'" + f + "' is a directory");
        }
        LOG.debug("Opening ' {} ' for reading, size: {}", (Object)f, (Object)status.getLen());
        JindoS3InputStream.S3ReadContext readContext = new JindoS3InputStream.S3ReadContext();
        this.initContext(readContext.s3Ctx);
        readContext.stats = this.context.statistics;
        readContext.path = qualifiedPath;
        readContext.s3Ctx.key = S3Utils.pathToKey(qualifiedPath);
        readContext.fileSize = status.getLen();
        readContext.bufferSize = realBufferSize;
        int bufferNum = (int)(readContext.fileSize / (long)readContext.bufferSize);
        readContext.totalBuffers = readContext.fileSize % (long)readContext.bufferSize == 0L ? (long)bufferNum : (long)(bufferNum + 1);
        readContext.timeoutInSecond = this.conf.getInt("fs.jfs.cache.timeout.second", 10);
        JindoS3InputStream fsInputStream = new JindoS3InputStream(readContext, jbootReader);
        return new FSDataInputStream((InputStream)((Object)fsInputStream));
    }

    @Override
    public boolean rename(Path srcPath, Path dstPath, boolean appendName, boolean ignoreHidden) throws IOException {
        Path parent;
        Path qualifiedSrcPath = this.qualifyPath(srcPath);
        Path qualifiedDstPath = this.qualifyPath(dstPath);
        String srcKey = S3Utils.pathToKey(qualifiedSrcPath);
        if (srcKey.length() == 0) {
            return false;
        }
        for (parent = qualifiedDstPath.getParent(); parent != null && !qualifiedSrcPath.equals((Object)parent); parent = parent.getParent()) {
        }
        if (parent != null) {
            return false;
        }
        String debugPreamble = "Renaming '" + qualifiedSrcPath + "' to '" + qualifiedDstPath + "' - ";
        if (qualifiedSrcPath.equals((Object)qualifiedDstPath)) {
            try {
                FileStatus srcFileStatus = this.getFileStatus(qualifiedSrcPath);
                boolean srcIsFile = srcFileStatus.isFile();
                return srcIsFile;
            }
            catch (FileNotFoundException e) {
                LOG.debug("src is not found, maybe an *");
            }
        }
        S3RenameOp renameOperation = this.s3OpBuilder.createRenameOperation();
        boolean result = false;
        try {
            result = this.s3Context.enableHiveFastRename && S3NativeStore.verifyDst(qualifiedDstPath.toString()) ? renameOperation.rename(qualifiedSrcPath.toString(), qualifiedDstPath.toString(), appendName, ignoreHidden, true, this.s3Context) : renameOperation.rename(qualifiedSrcPath.toString(), qualifiedDstPath.toString(), appendName, ignoreHidden, false, this.s3Context);
        }
        catch (java.nio.file.FileAlreadyExistsException e) {
            return false;
        }
        return result;
    }

    private static boolean verifyDst(String OriginPath) {
        String path = "";
        if (OriginPath.startsWith("s3://")) {
            path = OriginPath.replace("s3://", "/");
        } else if (OriginPath.startsWith("s3a://")) {
            path = OriginPath.replace("s3a://", "/");
        } else if (OriginPath.startsWith("s3n://")) {
            path = OriginPath.replace("s3n://", "/");
        } else if (OriginPath.startsWith("cos://")) {
            path = OriginPath.replace("cos://", "/");
        } else if (OriginPath.startsWith("obs://")) {
            path = OriginPath.replace("obs://", "/");
        } else {
            return false;
        }
        try {
            boolean foundHiveStagingComponent = false;
            boolean foundHiveStagingDstComponent = false;
            List<String> components = S3NativeStore.getJindoPathComponents(path);
            String bucketPrefix = "";
            for (String comp : components) {
                if (bucketPrefix == "") {
                    bucketPrefix = comp;
                }
                if (comp.startsWith(".hive-staging_hive_")) {
                    if (!foundHiveStagingComponent) {
                        foundHiveStagingComponent = true;
                        continue;
                    }
                    foundHiveStagingComponent = false;
                    break;
                }
                if (comp.startsWith("-ext-100")) {
                    if (!foundHiveStagingDstComponent) {
                        foundHiveStagingDstComponent = true;
                        continue;
                    }
                    foundHiveStagingDstComponent = false;
                    break;
                }
                if (!foundHiveStagingComponent || !foundHiveStagingDstComponent) continue;
                return false;
            }
            if (foundHiveStagingComponent && foundHiveStagingDstComponent) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (!this.enableBlockLocation) {
            return null;
        }
        Path qualifiedPath = this.qualifyPath(file.getPath());
        String path = Utils.pathToJindoPath(qualifiedPath);
        if (file == null) {
            LOG.debug("getFileBlockLocations({}, {}, {}) returned null", new Object[]{path, start, len});
            return null;
        }
        if (!(file instanceof S3FileStatus)) {
            LOG.warn("FileStatus is not S3FileStatus for path {}, cannot getFileBlockLocations", (Object)path);
            return null;
        }
        S3FileStatus s3FileStatus = (S3FileStatus)file;
        String etag = s3FileStatus.getEtag();
        LOG.debug("GetFileBlockLocations start : {}, {}, {}, {}, {}", new Object[]{path, etag, start, len, this.logicBlockSize});
        Table list = null;
        try {
            list = this.context.s3FileletSystem.getFileBlockLocations(new JindoRequestPath(path, this.s3Context), etag, start, len, this.logicBlockSize);
            LOG.debug("GetFileBlockLocations end : {}, {}, {}, {} returned {}", new Object[]{path, start, len, this.logicBlockSize, list == null ? null : Integer.valueOf(((BlockInfoList)list).blocksLength())});
            BlockLocation[] blockLocationArray = this.getBlockLocation((BlockInfoList)list, file.getLen());
            return blockLocationArray;
        }
        finally {
            if (list != null) {
                JbootBufferFactory.returnBuffer(list.getByteBuffer());
            }
        }
    }

    private BlockLocation[] getBlockLocation(BlockInfoList list, long fileSize) {
        if (list != null && list.blocksLength() > 0) {
            BlockLocation[] blockLocations = new BlockLocation[list.blocksLength()];
            for (int i = 0; i < list.blocksLength(); ++i) {
                BlockInfo info = list.blocks(i);
                ArrayList<String> hosts = new ArrayList<String>();
                ArrayList<String> names = new ArrayList<String>();
                StringList blockHosts = StringList.getRootAsStringList(info.locationsAsByteBuffer());
                for (int j = 0; j < blockHosts.stringsLength(); ++j) {
                    String ip;
                    String host;
                    String hostAndPort = blockHosts.strings(j);
                    String[] hostPort = hostAndPort.split(":");
                    String hostName = hostPort[0];
                    String port = hostPort.length > 1 ? hostPort[1] : "6101";
                    try {
                        InetAddress addr = InetAddress.getByName(hostName);
                        addr.getHostAddress();
                        host = addr.getHostName();
                        ip = addr.getHostAddress();
                    }
                    catch (Exception e) {
                        host = hostName;
                        ip = hostName;
                    }
                    String ipAndPort = ip + ":" + port;
                    hosts.add(host);
                    names.add(ipAndPort);
                }
                long blockOffset = info.start();
                long remainingSize = fileSize - blockOffset;
                long blockLength = Math.min(remainingSize, this.logicBlockSize);
                blockLocations[i] = new BlockLocation(names.toArray(new String[blockHosts.stringsLength()]), hosts.toArray(new String[blockHosts.stringsLength()]), blockOffset, blockLength);
            }
            return blockLocations;
        }
        return null;
    }

    @Override
    public byte[] getXAttr(Path path, String name) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support removeXAttr");
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support removeXAttr");
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support removeXAttr");
    }

    @Override
    public void setXAttr(Path path, String name, byte[] value) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support removeXAttr");
    }

    @Override
    public List<String> listXAttrs(Path path) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support removeXAttr");
    }

    @Override
    public void removeXAttr(Path path, String name) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support removeXAttr");
    }

    @Override
    public void checkPermission(Path path, FsAction mode) throws IOException {
        Path qualifiedPath = path.makeQualified(this.context.uri, this.context.workingDir);
        String key = Utils.pathToJindoPath(qualifiedPath);
        boolean result = false;
        try {
            LOG.debug("checkPermission for path {}", (Object)key);
            result = this.context.s3FileletSystem.checkPermission(new JindoRequestPath(key, this.s3Context), false, (short)0, (short)mode.ordinal());
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            LOG.info("checkPermission for path {} result {}", (Object)key, (Object)result);
        }
    }

    @Override
    public void setPermission(Path p, FsPermission permission) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support setPermission");
    }

    @Override
    public void processPermissionDelta(Path path, short permission, short permissionDelta, boolean recursive) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support processPermissionDelta");
    }

    @Override
    public void setOwner(Path path, String username, String groupName, boolean recursive) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support processPermissionDelta");
    }

    @Override
    public void setOwner(Path p, String username, String groupName) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support setOwner");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentSummary getContentSummary(Path path) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        String key = Utils.pathToJindoPath(qualifiedPath);
        Table fileletSummary = null;
        try {
            fileletSummary = this.context.s3FileletSystem.getContentSummary(new JindoRequestPath(key, this.s3Context), this.contentSummaryBatchCount);
            if (fileletSummary != null) {
                ContentSummary contentSummary = new ContentSummary(((FileletSummary)fileletSummary).fileLength(), ((FileletSummary)fileletSummary).fileCount(), ((FileletSummary)fileletSummary).directoryCount(), -1L, ((FileletSummary)fileletSummary).fileLength(), -1L);
                return contentSummary;
            }
            ContentSummary contentSummary = new ContentSummary();
            return contentSummary;
        }
        finally {
            if (fileletSummary != null && fileletSummary.getByteBuffer() != null) {
                JbootBufferFactory.returnBuffer(fileletSummary.getByteBuffer());
            }
        }
    }

    @Override
    public FileChecksum getFileChecksum(Path path) throws IOException {
        String checksum = this.s3OpBuilder.createGetFileChecksumOperation().getFileChecksum(path, this.s3Context);
        return new Crc64FileChecksum(checksum);
    }

    @Override
    public FileChecksum getFileChecksum2(Path path) throws IOException {
        String checksum = this.s3OpBuilder.createGetFileChecksum2Operation().getFileChecksum2(path, this.s3Context);
        return new Crc32FileChecksum(checksum);
    }

    @Override
    public FileChecksum getFileChecksum2(Path path, long blockSize) throws IOException {
        return this.getFileChecksum2(path);
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public Boolean isMagicCommitEnabled() {
        return this.magicEnabled;
    }

    private void initContext(S3OpContext s3OpContext) {
        s3OpContext.s3FileletSystem = this.context.s3FileletSystem;
        s3OpContext.conf = this.conf;
        s3OpContext.stats = this.context.statistics;
    }

    public S3OpBuilder getS3OpBuilder() {
        return this.s3OpBuilder;
    }

    public S3FileletSystem getS3FileletSystem() {
        return this.context.s3FileletSystem;
    }

    public CredentialContext getS3Context() {
        return this.s3Context;
    }

    @Override
    public void cache(Path path, AbstractJindoShimsFileSystem.CacheOpContext opContext) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        String filePath = Utils.pathToJindoPath(qualifiedPath);
        try {
            this.context.s3FileletSystem.cache(new JindoRequestPath(filePath, this.s3Context), opContext, 36000L);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to cache " + filePath);
            throw e;
        }
    }

    @Override
    public void atomicCache(Path path, AbstractJindoShimsFileSystem.CacheOpContext opContext) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        String filePath = Utils.pathToJindoPath(qualifiedPath);
        try {
            this.context.s3FileletSystem.atomicCache(new JindoRequestPath(filePath, this.s3Context), opContext, 36000L);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to cache " + filePath);
            throw e;
        }
    }

    @Override
    public void uncache(Path path) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        String filePath = Utils.pathToJindoPath(qualifiedPath);
        try {
            this.context.s3FileletSystem.uncache(new JindoRequestPath(filePath, this.s3Context), 10000L);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to uncache " + filePath);
            throw e;
        }
    }

    @Override
    public FileletStatus[] checkProgress(Path path, boolean detailed) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        String filePath = Utils.pathToJindoPath(qualifiedPath);
        try {
            FileletStatusList list = this.context.s3FileletSystem.checkProgress(new JindoRequestPath(filePath, this.s3Context), detailed, 10000L);
            FileletStatus[] fileStatuses = new FileletStatus[list.filesLength()];
            for (int i = 0; i < list.filesLength(); ++i) {
                fileStatuses[i] = list.files(i);
            }
            JbootBufferFactory.returnBuffer(list.getByteBuffer());
            return fileStatuses;
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to checkProgress " + filePath);
            return null;
        }
    }

    @Override
    public boolean close2(JindoRequestPath path, List<String> paths, boolean abort) throws IOException {
        throw new IOException("Not Support close2 for s3 native");
    }

    public class S3OpBuilder {
        public S3RenameOp createRenameOperation() throws IOException {
            OssAtomicRenameContext atomicRenameContext;
            S3RenameOp.S3RenameContext context = new S3RenameOp.S3RenameContext();
            S3NativeStore.this.initContext(context);
            context.maxSimpleCopySize = S3NativeStore.this.conf.getLong("fs.jfs.cache.copy.simple.max.byte", -1L);
            context.batchSize = S3NativeStore.this.conf.getInt("fs.jfs.cache.batch-copy.size", 0);
            context.atomicRenameContext = atomicRenameContext = new OssAtomicRenameContext();
            return new S3RenameOp(context);
        }

        public S3DeleteOp createDeleteOperation() {
            S3OpContext context = new S3OpContext();
            S3NativeStore.this.initContext(context);
            return new S3DeleteOp(context, S3NativeStore.this.fs, S3NativeStore.this.s3Context);
        }

        public S3ListStatusOp createListStatusOperation() {
            S3OpContext context = new S3OpContext();
            S3NativeStore.this.initContext(context);
            return new S3ListStatusOp(context, S3NativeStore.this.fs, S3NativeStore.this.s3Context);
        }

        public S3GetFileStatusOp createGetFileStatusOperation() {
            S3OpContext context = new S3OpContext();
            S3NativeStore.this.initContext(context);
            return new S3GetFileStatusOp(context, S3NativeStore.this.fs, S3NativeStore.this.s3Context);
        }

        public S3GetFileChecksumOp createGetFileChecksumOperation() {
            S3OpContext context = new S3OpContext();
            S3NativeStore.this.initContext(context);
            return new S3GetFileChecksumOp(context, S3NativeStore.this.fs, S3NativeStore.this.s3Context);
        }

        public S3GetFileChecksum2Op createGetFileChecksum2Operation() {
            S3OpContext context = new S3OpContext();
            S3NativeStore.this.initContext(context);
            return new S3GetFileChecksum2Op(context, S3NativeStore.this.fs, S3NativeStore.this.s3Context);
        }
    }

    public static class Context
    extends AbstractFileSystemStore.Context {
        public final S3FileletSystem s3FileletSystem = new S3FileletSystem();
        public String prefix;
        public long namespaceConnectId = 0L;
        public S3CredentialProviderList credentialProviders;
    }
}

