/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.internal.s3native;

import bigboot.protocol.type.PartInfo;
import bigboot.protocol.type.PartList;
import com.alibaba.jboot.google.flatbuffers.FlatBufferBuilder;
import com.aliyun.emr.fs.s3.commit.magic.CommitUtils;
import com.aliyun.emr.shade.google_guava.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3PartInfo {
    private static Logger LOG = LoggerFactory.getLogger(S3PartInfo.class);
    int partNum;
    long size;
    String etag;

    public void setPartNum(int partNum) {
        this.partNum = partNum;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setEtag(String etag) {
        this.etag = etag;
    }

    public int getPartNum() {
        return this.partNum;
    }

    public long getSize() {
        return this.size;
    }

    public String getEtag() {
        return this.etag;
    }

    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        try {
            dataOutputStream.writeInt(this.partNum);
            dataOutputStream.writeLong(this.size);
            CommitUtils.writeStringToOutputStream(dataOutputStream, this.etag);
            dataOutputStream.flush();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            LOG.error("Failed to serialize S3PartInfo.", (Throwable)e);
            throw e;
        }
        finally {
            try {
                dataOutputStream.close();
                outputStream.close();
            }
            catch (IOException e) {
                LOG.warn("Failed to close OutputStream.", (Throwable)e);
            }
        }
    }

    public static S3PartInfo fromBytes(byte[] bytes) throws IOException {
        Preconditions.checkArgument(bytes.length > 0, "Empty input byte array.");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            S3PartInfo partInfo = new S3PartInfo();
            partInfo.partNum = dataInputStream.readInt();
            partInfo.size = dataInputStream.readLong();
            partInfo.etag = CommitUtils.readStringFromInputStream(dataInputStream);
            S3PartInfo s3PartInfo = partInfo;
            return s3PartInfo;
        }
        catch (IOException e) {
            LOG.error("Failed to deserialize S3PartInfo.", (Throwable)e);
            throw e;
        }
        finally {
            try {
                dataInputStream.close();
                inputStream.close();
            }
            catch (IOException e) {
                LOG.warn("Failed to close InputStream.", (Throwable)e);
            }
        }
    }

    public static List<S3PartInfo> fromPartList(PartList partList) {
        if (partList == null) {
            return null;
        }
        ArrayList<S3PartInfo> result = new ArrayList<S3PartInfo>(partList.partsLength());
        for (int i = 0; i < partList.partsLength(); ++i) {
            PartInfo partInfo = partList.parts(i);
            result.add(new S3PartInfo(partInfo.partNum(), partInfo.size(), partInfo.eTag()));
        }
        return result;
    }

    public static ByteBuffer createPartList(List<S3PartInfo> partInfos) {
        if (partInfos == null || partInfos.isEmpty()) {
            return null;
        }
        int size = partInfos.size();
        int[] partList = new int[size];
        FlatBufferBuilder builder = new FlatBufferBuilder();
        int i = 0;
        for (S3PartInfo partInfo : partInfos) {
            int etagOffset = builder.createString(partInfo.etag);
            partList[i] = PartInfo.createPartInfo(builder, partInfo.partNum, partInfo.size, etagOffset);
            ++i;
        }
        int partListOffset = builder.createVectorOfTables(partList);
        PartList.startPartList(builder);
        PartList.addParts(builder, partListOffset);
        builder.finish(PartList.endPartList(builder));
        ByteBuffer partListBuffer = builder.dataBuffer();
        return partListBuffer;
    }

    public S3PartInfo(int partNum, long size, String etag) {
        this.partNum = partNum;
        this.size = size;
        this.etag = etag;
    }

    public S3PartInfo(PartInfo partInfo) {
        this.partNum = partInfo.partNum();
        this.size = partInfo.size();
        this.etag = partInfo.eTag();
    }

    public S3PartInfo() {
    }
}

