/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.internal.s3native;

import com.alibaba.jfs.CredentialContext;
import com.alibaba.jfs.JindoRequestPath;
import com.alibaba.jfs.OssAtomicRenameContext;
import com.aliyun.emr.fs.s3.internal.s3native.S3OpContext;
import java.io.IOException;
import org.apache.hadoop.fs.Path;

public class S3RenameOp {
    private final S3RenameContext context;

    public S3RenameOp(S3RenameContext context) {
        this.context = context;
    }

    public boolean rename(String srcPath, String dstPath, boolean appendName, boolean ignoreHidden, boolean prefixLink, CredentialContext s3Context) throws IOException {
        return this.context.s3FileletSystem.rename(new JindoRequestPath(srcPath, s3Context), dstPath, this.context.maxSimpleCopySize, false, appendName, ignoreHidden, this.context.batchSize, prefixLink, this.context.atomicRenameContext);
    }

    public static class S3RenameContext
    extends S3OpContext {
        public Path path;
        public Long maxSimpleCopySize;
        public int batchSize;
        public OssAtomicRenameContext atomicRenameContext;
    }
}

