/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.shade.google_guava.math;

import com.aliyun.emr.shade.google_guava.annotations.Beta;
import com.aliyun.emr.shade.google_guava.annotations.VisibleForTesting;
import com.aliyun.emr.shade.google_guava.base.Preconditions;
import com.aliyun.emr.shade.google_guava.math.IntMath;
import com.aliyun.emr.shade.google_guava.math.MathPreconditions;
import java.math.RoundingMode;

@Beta
public final class LongMath {
    @VisibleForTesting
    static final long MAX_POWER_OF_SQRT2_UNSIGNED = -5402926248376769404L;
    @VisibleForTesting
    static final long[] POWERS_OF_10 = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    @VisibleForTesting
    static final long[] HALF_POWERS_OF_10 = new long[]{3L, 31L, 316L, 3162L, 31622L, 316227L, 3162277L, 31622776L, 316227766L, 3162277660L, 31622776601L, 316227766016L, 3162277660168L, 31622776601683L, 316227766016837L, 3162277660168379L, 31622776601683793L, 316227766016837933L, 3162277660168379331L};
    @VisibleForTesting
    static final long FLOOR_SQRT_MAX_LONG = 3037000499L;
    static final long[] FACTORIALS = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};
    static final int[] BIGGEST_BINOMIALS = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 3810779, 121977, 16175, 4337, 1733, 887, 534, 361, 265, 206, 169, 143, 125, 111, 101, 94, 88, 83, 79, 76, 74, 72, 70, 69, 68, 67, 67, 66, 66, 66, 66};
    @VisibleForTesting
    static final int[] BIGGEST_SIMPLE_BINOMIALS = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 2642246, 86251, 11724, 3218, 1313, 684, 419, 287, 214, 169, 139, 119, 105, 95, 87, 81, 76, 73, 70, 68, 66, 64, 63, 62, 62, 61, 61, 61};

    public static boolean isPowerOfTwo(long x) {
        return x > 0L & (x & x - 1L) == 0L;
    }

    public static int log2(long x, RoundingMode mode) {
        MathPreconditions.checkPositive("x", x);
        switch (mode) {
            case UNNECESSARY: {
                MathPreconditions.checkRoundingUnnecessary(LongMath.isPowerOfTwo(x));
            }
            case DOWN: 
            case FLOOR: {
                return 63 - Long.numberOfLeadingZeros(x);
            }
            case UP: 
            case CEILING: {
                return 64 - Long.numberOfLeadingZeros(x - 1L);
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int leadingZeros = Long.numberOfLeadingZeros(x);
                long cmp = -5402926248376769404L >>> leadingZeros;
                int logFloor = 63 - leadingZeros;
                return x <= cmp ? logFloor : logFloor + 1;
            }
        }
        throw new AssertionError((Object)"impossible");
    }

    public static int log10(long x, RoundingMode mode) {
        MathPreconditions.checkPositive("x", x);
        if (LongMath.fitsInInt(x)) {
            return IntMath.log10((int)x, mode);
        }
        int logFloor = LongMath.log10Floor(x);
        long floorPow = POWERS_OF_10[logFloor];
        switch (mode) {
            case UNNECESSARY: {
                MathPreconditions.checkRoundingUnnecessary(x == floorPow);
            }
            case DOWN: 
            case FLOOR: {
                return logFloor;
            }
            case UP: 
            case CEILING: {
                return x == floorPow ? logFloor : logFloor + 1;
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                return x <= HALF_POWERS_OF_10[logFloor] ? logFloor : logFloor + 1;
            }
        }
        throw new AssertionError();
    }

    static int log10Floor(long x) {
        for (int i = 1; i < POWERS_OF_10.length; ++i) {
            if (x >= POWERS_OF_10[i]) continue;
            return i - 1;
        }
        return POWERS_OF_10.length - 1;
    }

    public static long pow(long b, int k) {
        MathPreconditions.checkNonNegative("exponent", k);
        if (-2L <= b && b <= 2L) {
            switch ((int)b) {
                case 0: {
                    return k == 0 ? 1L : 0L;
                }
                case 1: {
                    return 1L;
                }
                case -1: {
                    return (k & 1) == 0 ? 1L : -1L;
                }
                case 2: {
                    return k < 64 ? 1L << k : 0L;
                }
                case -2: {
                    if (k < 64) {
                        return (k & 1) == 0 ? 1L << k : -(1L << k);
                    }
                    return 0L;
                }
            }
        }
        long accum = 1L;
        while (true) {
            switch (k) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return accum * b;
                }
            }
            accum *= (k & 1) == 0 ? 1L : b;
            b *= b;
            k >>= 1;
        }
    }

    public static long sqrt(long x, RoundingMode mode) {
        MathPreconditions.checkNonNegative("x", x);
        if (LongMath.fitsInInt(x)) {
            return IntMath.sqrt((int)x, mode);
        }
        long sqrtFloor = LongMath.sqrtFloor(x);
        switch (mode) {
            case UNNECESSARY: {
                MathPreconditions.checkRoundingUnnecessary(sqrtFloor * sqrtFloor == x);
            }
            case DOWN: 
            case FLOOR: {
                return sqrtFloor;
            }
            case UP: 
            case CEILING: {
                return sqrtFloor * sqrtFloor == x ? sqrtFloor : sqrtFloor + 1L;
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                long halfSquare = sqrtFloor * sqrtFloor + sqrtFloor;
                return halfSquare >= x | halfSquare < 0L ? sqrtFloor : sqrtFloor + 1L;
            }
        }
        throw new AssertionError();
    }

    private static long sqrtFloor(long x) {
        long sqrt0 = (long)Math.sqrt(x);
        long sqrt1 = sqrt0 + x / sqrt0 >> 1;
        if (sqrt1 == sqrt0) {
            return sqrt0;
        }
        while ((sqrt1 = (sqrt0 = sqrt1) + x / sqrt0 >> 1) < sqrt0) {
        }
        return sqrt0;
    }

    public static long divide(long p, long q, RoundingMode mode) {
        boolean increment;
        Preconditions.checkNotNull(mode);
        long div = p / q;
        long rem = p - q * div;
        if (rem == 0L) {
            return div;
        }
        int signum = 1 | (int)((p ^ q) >> 63);
        switch (mode) {
            case UNNECESSARY: {
                MathPreconditions.checkRoundingUnnecessary(rem == 0L);
            }
            case DOWN: {
                increment = false;
                break;
            }
            case UP: {
                increment = true;
                break;
            }
            case CEILING: {
                increment = signum > 0;
                break;
            }
            case FLOOR: {
                increment = signum < 0;
                break;
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                long absRem = Math.abs(rem);
                long cmpRemToHalfDivisor = absRem - (Math.abs(q) - absRem);
                if (cmpRemToHalfDivisor == 0L) {
                    increment = mode == RoundingMode.HALF_UP | mode == RoundingMode.HALF_EVEN & (div & 1L) != 0L;
                    break;
                }
                increment = cmpRemToHalfDivisor > 0L;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return increment ? div + (long)signum : div;
    }

    public static int mod(long x, int m) {
        return (int)LongMath.mod(x, (long)m);
    }

    public static long mod(long x, long m) {
        if (m <= 0L) {
            throw new ArithmeticException("Modulus " + m + " must be > 0");
        }
        long result = x % m;
        return result >= 0L ? result : result + m;
    }

    public static long gcd(long a, long b) {
        MathPreconditions.checkNonNegative("a", a);
        MathPreconditions.checkNonNegative("b", b);
        if (a == 0L | b == 0L) {
            return a | b;
        }
        int aTwos = Long.numberOfTrailingZeros(a);
        a >>= aTwos;
        int bTwos = Long.numberOfTrailingZeros(b);
        b >>= bTwos;
        while (a != b) {
            if (a < b) {
                long t = b;
                b = a;
                a = t;
            }
            a -= b;
            a >>= Long.numberOfTrailingZeros(a);
        }
        return a << Math.min(aTwos, bTwos);
    }

    public static long checkedAdd(long a, long b) {
        long result = a + b;
        MathPreconditions.checkNoOverflow((a ^ b) < 0L | (a ^ result) >= 0L);
        return result;
    }

    public static long checkedSubtract(long a, long b) {
        long result = a - b;
        MathPreconditions.checkNoOverflow((a ^ b) >= 0L | (a ^ result) >= 0L);
        return result;
    }

    public static long checkedMultiply(long a, long b) {
        int leadingZeros = Long.numberOfLeadingZeros(a) + Long.numberOfLeadingZeros(a ^ 0xFFFFFFFFFFFFFFFFL) + Long.numberOfLeadingZeros(b) + Long.numberOfLeadingZeros(b ^ 0xFFFFFFFFFFFFFFFFL);
        if (leadingZeros > 65) {
            return a * b;
        }
        MathPreconditions.checkNoOverflow(leadingZeros >= 64);
        MathPreconditions.checkNoOverflow(a >= 0L | b != Long.MIN_VALUE);
        long result = a * b;
        MathPreconditions.checkNoOverflow(a == 0L || result / a == b);
        return result;
    }

    public static long checkedPow(long b, int k) {
        MathPreconditions.checkNonNegative("exponent", k);
        if (b >= -2L & b <= 2L) {
            switch ((int)b) {
                case 0: {
                    return k == 0 ? 1L : 0L;
                }
                case 1: {
                    return 1L;
                }
                case -1: {
                    return (k & 1) == 0 ? 1L : -1L;
                }
                case 2: {
                    MathPreconditions.checkNoOverflow(k < 63);
                    return 1L << k;
                }
                case -2: {
                    MathPreconditions.checkNoOverflow(k < 64);
                    return (k & 1) == 0 ? 1L << k : -1L << k;
                }
            }
        }
        long accum = 1L;
        while (true) {
            switch (k) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return LongMath.checkedMultiply(accum, b);
                }
            }
            if ((k & 1) != 0) {
                accum = LongMath.checkedMultiply(accum, b);
            }
            if ((k >>= 1) <= 0) continue;
            MathPreconditions.checkNoOverflow(b <= 3037000499L);
            b *= b;
        }
    }

    public static long factorial(int n) {
        MathPreconditions.checkNonNegative("n", n);
        return n < FACTORIALS.length ? FACTORIALS[n] : Long.MAX_VALUE;
    }

    public static long binomial(int n, int k) {
        MathPreconditions.checkNonNegative("n", n);
        MathPreconditions.checkNonNegative("k", k);
        Preconditions.checkArgument(k <= n, "k (%s) > n (%s)", k, n);
        if (k > n >> 1) {
            k = n - k;
        }
        if (k >= BIGGEST_BINOMIALS.length || n > BIGGEST_BINOMIALS[k]) {
            return Long.MAX_VALUE;
        }
        long result = 1L;
        if (k < BIGGEST_SIMPLE_BINOMIALS.length && n <= BIGGEST_SIMPLE_BINOMIALS[k]) {
            for (int i = 0; i < k; ++i) {
                result *= (long)(n - i);
                result /= (long)(i + 1);
            }
        } else {
            int i = 1;
            while (i <= k) {
                int d = IntMath.gcd(n, i);
                result /= (long)(i / d);
                result *= (long)(n / d);
                ++i;
                --n;
            }
        }
        return result;
    }

    static boolean fitsInInt(long x) {
        return (long)((int)x) == x;
    }

    private LongMath() {
    }
}

