/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import bigboot.protocol.type.CltRecoverReply;
import bigboot.protocol.type.KeyCreateReply;
import bigboot.protocol.type.KeyListReply;
import bigboot.protocol.type.KeyRollReply;
import bigboot.protocol.type.NssReportSummaryReply;
import com.alibaba.jboot.JbootUtils;
import com.alibaba.jboot.OssAdmin;
import com.alibaba.jboot.buffer.JbootBufferFactory;
import com.alibaba.jboot.future.ByteBufferFuture;
import com.alibaba.jboot.protocols.ClientRecoverRequestWrapper;
import com.alibaba.jboot.protocols.KeyCreateRequestWrapper;
import com.alibaba.jboot.protocols.KeyListRequestWrapper;
import com.alibaba.jboot.protocols.KeyRollRequestWrapper;
import com.alibaba.jboot.protocols.ReportSummaryRequestWrapper;
import com.alibaba.jfs.JfsSystemBase;
import com.alibaba.jfs.OssFlushContext;
import com.aliyun.emr.fs.internal.ossnative.HadoopLoginUserInfo;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class OssAdminTool
extends JfsSystemBase {
    private OssAdmin jbootAdmin = new OssAdmin();
    public long DEFAULT_FUTRUE_TIMEOUT = 180L;

    public OssAdminTool() {
        super(new HadoopLoginUserInfo());
    }

    public void archive(String path) throws IOException {
        this.archive(path, this.DEFAULT_FUTRUE_TIMEOUT);
    }

    /*
     * Exception decompiling
     */
    public void archive(String path, long timeoutInSeconds) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public KeyCreateReply keyCreate(String keyIdName, String keyIdVersion, String description, String encryptionKeyId) throws IOException {
        ByteBuffer request = new KeyCreateRequestWrapper(this.ugi, keyIdName, keyIdVersion, description, encryptionKeyId).toDirectBuffer();
        boolean rpc_succeed = false;
        try {
            int retryCount = 0;
            ByteBufferFuture future = new ByteBufferFuture(this.jbootAdmin.keyCreate(request));
            try {
                rpc_succeed = true;
                ByteBuffer result = future.get(this.DEFAULT_FUTRUE_TIMEOUT, TimeUnit.SECONDS);
                JbootUtils.logRetrySuccess("keyCreate", retryCount);
                KeyCreateReply keyCreateReply = KeyCreateReply.getRootAsKeyCreateReply(result);
                return keyCreateReply;
            }
            catch (Exception e) {
                IOException lastException = new IOException(e);
                throw lastException;
            }
        }
        finally {
            if (rpc_succeed) {
                JbootBufferFactory.returnBuffer(request);
            }
        }
    }

    public KeyListReply keyList() throws IOException {
        ByteBuffer request = new KeyListRequestWrapper(this.ugi).toDirectBuffer();
        boolean rpc_succeed = false;
        try {
            int retryCount = 0;
            ByteBufferFuture future = new ByteBufferFuture(this.jbootAdmin.keyList(request));
            try {
                rpc_succeed = true;
                ByteBuffer result = future.get(this.DEFAULT_FUTRUE_TIMEOUT, TimeUnit.SECONDS);
                JbootUtils.logRetrySuccess("keyList", retryCount);
                KeyListReply keyListReply = KeyListReply.getRootAsKeyListReply(result);
                return keyListReply;
            }
            catch (Exception e) {
                IOException lastException = new IOException(e);
                throw lastException;
            }
        }
        finally {
            if (rpc_succeed) {
                JbootBufferFactory.returnBuffer(request);
            }
        }
    }

    public KeyRollReply keyRoll(String keyIdName) throws IOException {
        ByteBuffer request = new KeyRollRequestWrapper(this.ugi, keyIdName).toDirectBuffer();
        boolean rpc_succeed = false;
        try {
            int retryCount = 0;
            ByteBufferFuture future = new ByteBufferFuture(this.jbootAdmin.keyRoll(request));
            try {
                rpc_succeed = true;
                ByteBuffer result = future.get(this.DEFAULT_FUTRUE_TIMEOUT, TimeUnit.SECONDS);
                JbootUtils.logRetrySuccess("keyRoll", retryCount);
                KeyRollReply keyRollReply = KeyRollReply.getRootAsKeyRollReply(result);
                return keyRollReply;
            }
            catch (Exception e) {
                IOException lastException = new IOException(e);
                throw lastException;
            }
        }
        finally {
            if (rpc_succeed) {
                JbootBufferFactory.returnBuffer(request);
            }
        }
    }

    public NssReportSummaryReply reportSummary() throws IOException {
        try {
            ByteBuffer request = new ReportSummaryRequestWrapper(this.ugi).toDirectBuffer();
            ByteBufferFuture future = new ByteBufferFuture(this.jbootAdmin.reportSummary(request));
            ByteBuffer result = future.get(this.DEFAULT_FUTRUE_TIMEOUT, TimeUnit.SECONDS);
            return NssReportSummaryReply.getRootAsNssReportSummaryReply(result);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public CltRecoverReply recover(String path, boolean recursive, OssFlushContext ossFlushContext) throws IOException {
        try {
            ByteBuffer request = new ClientRecoverRequestWrapper(this.ugi, path, recursive, ossFlushContext).toDirectBuffer();
            ByteBufferFuture future = new ByteBufferFuture(this.jbootAdmin.recover(request));
            ByteBuffer result = future.get(this.DEFAULT_FUTRUE_TIMEOUT, TimeUnit.SECONDS);
            return CltRecoverReply.getRootAsCltRecoverReply(result);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public IOException wrapIOException(ExecutionException ee) {
        if (ee.getCause() instanceof IOException) {
            return (IOException)ee.getCause();
        }
        return new IOException(ee.getCause());
    }
}

