/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import com.aliyun.emr.fs.internal.jfs.JfsFileStatus;
import com.aliyun.emr.fs.internal.ossnative.OssFileStatus;
import com.aliyun.emr.fs.oss.JindoOssFileSystem;
import com.aliyun.emr.shade.google_guava.io.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.FsCommandProvider;
import org.apache.hadoop.fs.shell.JindoFsCommandShims;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.fs.shell.PrintableString;
import org.apache.hadoop.util.StringUtils;

public class JfsLs
implements FsCommandProvider {
    @Override
    public Class<? extends FsCommand> getCommandClass() {
        return Ls.class;
    }

    private static PathData[] expandAsGlob(String pattern, Configuration conf) throws IOException {
        Path globPath = new Path(pattern);
        FileSystem fs = globPath.getFileSystem(conf);
        PathData[] result = PathData.expandAsGlob((String)pattern, (Configuration)conf);
        if (fs instanceof JindoOssFileSystem && result != null && result.length > 0) {
            for (PathData pd : result) {
                if (pd.stat == null || !pd.stat.isFile()) continue;
                OssFileStatus ossFileStatus = ((JindoOssFileSystem)fs).getOssFileStatus(pd.path);
                pd.stat = ossFileStatus;
            }
        }
        return result;
    }

    static class DirNode {
        String currentPath;
        String dataPath;
        int size;
        List<String> children = new LinkedList<String>();
        Set<Integer> offsets = new HashSet<Integer>();

        public DirNode(String currentPath, String filePath, int size) {
            this.currentPath = currentPath;
            this.dataPath = filePath;
            this.size = size;
        }

        public void addChild(String path, int offset) {
            this.children.add(path);
            this.offsets.add(offset);
        }
    }

    public static class Ls
    extends JindoFsCommandShims {
        boolean isRecursiveCommand = false;
        private static final String OPTION_PATHONLY = "C";
        private static final String OPTION_DIRECTORY = "d";
        private static final String OPTION_HUMAN = "h";
        private static final String OPTION_HIDENONPRINTABLE = "q";
        private static final String OPTION_RECURSIVE = "R";
        private static final String OPTION_REVERSE = "r";
        private static final String OPTION_MTIME = "t";
        private static final String OPTION_ATIME = "u";
        private static final String OPTION_SIZE = "S";
        private static final String OPTION_EXTENDED = "e";
        public static final String NAME = "ls";
        public static final String USAGE = "[-C] [-d] [-h] [-q] [-R] [-t] [-S] [-r] [-u] [-e] [<path> ...]";
        public static final String DESCRIPTION = "List the contents that match the specified file pattern. If path is not specified, the contents of /user/<currentUser> will be listed. For a directory a list of its direct children is returned (unless -d option is specified).\n\nDirectory entries are of the form:\n\tpermissions - userId groupId sizeOfDirectory(in bytes) modificationDate(yyyy-MM-dd HH:mm) directoryName\n\nand file entries are of the form:\n\tpermissions numberOfReplicas userId groupId sizeOfFile(in bytes) modificationDate(yyyy-MM-dd HH:mm) fileName\n\n  -C  Display the paths of files and directories only.\n  -d  Directories are listed as plain files.\n  -h  Formats the sizes of files in a human-readable fashion\n      rather than a number of bytes.\n  -q  Print ? instead of non-printable characters.\n  -R  Recursively list the contents of directories.\n  -t  Sort files by modification time (most recent first).\n  -S  Sort files by size.\n  -r  Reverse the order of the sort.\n  -u  Use time of last access instead of modification for\n      display and sorting.  -e  Show extended info(StorageClass) of files, only JindoFS (Including oss:// via JindoFS) support this.      To enable this feature by default, you can use ls2 instead of ls,           or set \"hadoop.shell.ls.show.extended.enabled\" with \"true\" to core-site.xml; \n";
        protected static ThreadLocal<DateFormat> dateFormat = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm");
            }
        };
        protected int maxRepl = 3;
        protected int maxLen = 10;
        protected int maxOwner = 0;
        protected int maxGroup = 0;
        protected int maxExtended = 0;
        protected String lineFormat;
        private boolean pathOnly;
        protected boolean dirRecurse;
        private boolean orderReverse;
        private boolean orderTime;
        private boolean orderSize;
        private boolean useAtime;
        private boolean showExtended;
        private Comparator<PathData> orderComparator;
        private Comparator<FileStatus> fsOrderComparator;
        protected boolean humanReadable = false;
        private boolean hideNonPrintable = false;
        int defaultParThreadNum = Integer.parseInt(System.getenv("DEFAULT_THREAD_NUM") == null ? "10" : System.getenv("DEFAULT_THREAD_NUM"));
        int maxThreadNum = Integer.parseInt(System.getenv("MAX_THREAD_NUM") == null ? "1000" : System.getenv("MAX_THREAD_NUM"));
        AtomicInteger totalThread = new AtomicInteger(0);
        Map<String, DirNode> tree = new ConcurrentHashMap<String, DirNode>();
        DirNode root;
        String dir;
        ThreadLocal<Integer> currentDep = new ThreadLocal<Integer>(this){
            final /* synthetic */ Ls this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected Integer initialValue() {
                return 0;
            }
        };

        public static void registerCommands(CommandFactory factory) {
            factory.addClass(Ls.class, new String[]{"-ls"});
            factory.addClass(Lsr.class, new String[]{"-lsr"});
            factory.addClass(Ls2.class, new String[]{"-ls2"});
        }

        protected Ls() {
        }

        protected Ls(Configuration conf) {
            super(conf);
        }

        public void setConf(Configuration conf) {
            super.setConf(conf);
            if (this.getConf() != null) {
                this.getConf().setBoolean("fs.jfs.isCmd", true);
            }
        }

        protected String formatSize(long size) {
            return this.humanReadable ? StringUtils.TraditionalBinaryPrefix.long2String((long)size, (String)"", (int)1) : String.valueOf(size);
        }

        @Override
        protected List<PathData> expandArgument(String arg) throws IOException {
            PathData[] items = JfsLs.expandAsGlob(arg, this.getConf());
            if (items.length == 0) {
                throw new PathNotFoundException(arg);
            }
            return Arrays.asList(items);
        }

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(0, Integer.MAX_VALUE, new String[]{OPTION_PATHONLY, OPTION_DIRECTORY, OPTION_HUMAN, OPTION_HIDENONPRINTABLE, OPTION_RECURSIVE, OPTION_REVERSE, OPTION_MTIME, OPTION_SIZE, OPTION_ATIME, OPTION_EXTENDED});
            cf.parse(args);
            this.pathOnly = cf.getOpt(OPTION_PATHONLY);
            this.dirRecurse = !cf.getOpt(OPTION_DIRECTORY);
            this.isRecursiveCommand = cf.getOpt(OPTION_RECURSIVE) && this.dirRecurse;
            this.humanReadable = cf.getOpt(OPTION_HUMAN);
            this.hideNonPrintable = cf.getOpt(OPTION_HIDENONPRINTABLE);
            this.orderReverse = cf.getOpt(OPTION_REVERSE);
            this.orderTime = cf.getOpt(OPTION_MTIME);
            this.orderSize = !this.orderTime && cf.getOpt(OPTION_SIZE);
            this.useAtime = cf.getOpt(OPTION_ATIME);
            boolean bl = this.showExtended = cf.getOpt(OPTION_EXTENDED) || this.getConf().getBoolean("hadoop.shell.ls.show.extended.enabled", false);
            if (args.isEmpty()) {
                args.add(".");
            }
            this.initialiseOrderComparator();
        }

        @InterfaceAudience.Private
        boolean isPathOnly() {
            return this.pathOnly;
        }

        @InterfaceAudience.Private
        boolean isDirRecurse() {
            return this.dirRecurse;
        }

        @InterfaceAudience.Private
        boolean isHumanReadable() {
            return this.humanReadable;
        }

        @InterfaceAudience.Private
        private boolean isHideNonPrintable() {
            return this.hideNonPrintable;
        }

        @InterfaceAudience.Private
        boolean isOrderReverse() {
            return this.orderReverse;
        }

        @InterfaceAudience.Private
        boolean isOrderTime() {
            return this.orderTime;
        }

        @InterfaceAudience.Private
        boolean isOrderSize() {
            return this.orderSize;
        }

        @InterfaceAudience.Private
        boolean isShowExtended() {
            return this.showExtended;
        }

        @InterfaceAudience.Private
        boolean isUseAtime() {
            return this.useAtime;
        }

        @Override
        protected void processPathArgument(PathData item) throws IOException {
            boolean isJinDoFS;
            if ("true".equalsIgnoreCase(System.getProperty("ISTEST"))) {
                this.runParallelLSR(item);
                return;
            }
            String schema = item.fs.getScheme();
            boolean bl = isJinDoFS = "jfs".equalsIgnoreCase(schema) || "oss".equalsIgnoreCase(schema);
            if (this.dirRecurse && item.stat.isDirectory() && !isJinDoFS) {
                this.runSingleThreadLSR(item);
            } else if (this.dirRecurse && item.stat.isDirectory() && isJinDoFS) {
                this.runParallelLSR(item);
            } else {
                this.setRecursive(this.isRecursiveCommand);
                super.processPathArgument(item);
                this.setRecursive(false);
            }
        }

        private void runSingleThreadLSR(PathData item) throws IOException {
            this.setRecursive(this.isRecursiveCommand);
            this.recursePath(item);
            this.setRecursive(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runParallelLSR(PathData item) throws IOException {
            boolean isSuccess = false;
            if ("true".equalsIgnoreCase(this.getConf().get("hadoop.shell.ls.parallel.enabled", "true")) && this.isRecursiveCommand) {
                try {
                    this.setRecursive(this.isRecursiveCommand);
                    this.dir = Files.createTempDir().getCanonicalPath();
                    this.printlnDebug("Tmp dir is " + this.dir);
                    this.parRecursePath(item);
                    isSuccess = true;
                    this.setRecursive(false);
                }
                catch (Exception e) {
                    if (System.getenv("DEBUG") != null) {
                        e.printStackTrace();
                    }
                    this.runSingleThreadLSR(item);
                }
                finally {
                    File file;
                    if (this.dir != null && (file = new File(this.dir)).exists()) {
                        file.delete();
                    }
                }
                if (isSuccess) {
                    this.printTree(this.root);
                }
                this.root = null;
            } else {
                this.runSingleThreadLSR(item);
            }
        }

        protected void parRecursePath(PathData item) throws IOException {
            FileSystem fileSystem = item.path.getFileSystem(this.getConf());
            this.printlnDebug("List path :" + item.path);
            item.stat.setPath(item.path);
            this.parProcessPaths(item.stat, fileSystem.listStatus(item.path));
        }

        protected void parRecursePath(FileStatus item) throws IOException {
            FileSystem fileSystem = item.getPath().getFileSystem(this.getConf());
            this.parProcessPaths(item, fileSystem.listStatus(item.getPath()));
        }

        protected void parProcessPaths(FileStatus parent, FileStatus ... items) throws IOException {
            this.sortFileStatus(items);
            int nThreads = Math.min(Math.max(this.defaultParThreadNum - this.currentDep.get(), 1), items.length);
            if (this.totalThread.addAndGet(nThreads) > this.maxThreadNum) {
                throw new RuntimeException("Total thread more than " + this.maxThreadNum + ", switch to normal ls R");
            }
            ExecutorService executorService = Executors.newFixedThreadPool(nThreads);
            ExecutorCompletionService<Object> ecs = new ExecutorCompletionService<Object>(executorService);
            this.printlnDebug("Current dep " + this.currentDep.get() + ", current thread number is :" + this.totalThread.get());
            DirNode dirNode = new DirNode(parent.getPath().toString(), this.dir + "/" + UUID.randomUUID(), items.length);
            if (this.root == null) {
                this.root = dirNode;
            }
            this.tree.put(parent.getPath().toString(), dirNode);
            try (DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(FileUtils.openOutputStream((File)new File(dirNode.dataPath))));){
                for (int i = 0; i < items.length; ++i) {
                    FileStatus item = items[i];
                    dataOutputStream.writeUTF(this.formatFileStatus(item));
                    if (!this.recursive || !item.isDirectory()) continue;
                    String path = item.getPath().toString();
                    dirNode.addChild(path, i);
                    int nextDep = this.currentDep.get() + 1;
                    ecs.submit(() -> {
                        try {
                            this.currentDep.set(nextDep);
                            long start = System.currentTimeMillis();
                            this.printlnDebug("Submit async task for path" + path);
                            this.parRecursePath(item);
                            this.printlnDebug("Task " + path + "take time: " + (System.currentTimeMillis() - start) + "MS");
                        }
                        catch (Throwable e) {
                            return e;
                        }
                        return null;
                    });
                }
            }
            for (int i = 0; i < dirNode.children.size(); ++i) {
                try {
                    Future take = ecs.take();
                    if (take.get() == null) continue;
                    executorService.shutdown();
                    throw new IOException((Throwable)take.get());
                }
                catch (InterruptedException | ExecutionException exception) {
                    this.printlnDebug(exception.getMessage());
                }
            }
            this.totalThread.addAndGet(-nThreads);
        }

        void printlnDebug(String s) {
            if (System.getenv("DEBUG") != null) {
                this.out.println(s);
            }
        }

        void printTree(DirNode node) throws IOException {
            try (DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(new File(node.dataPath))));){
                int currentChild = 0;
                Set<Integer> offsets = node.offsets;
                for (int i = 0; i < node.size; ++i) {
                    this.out.println(dataInputStream.readUTF());
                    if (!offsets.contains(i)) continue;
                    this.printTree(this.tree.get(node.children.get(currentChild)));
                    ++currentChild;
                }
            }
        }

        private void sortFileStatus(FileStatus[] fileStatuses) {
            if (!this.isRecursiveCommand && fileStatuses.length != 0) {
                if (!this.pathOnly) {
                    this.out.println("Found " + fileStatuses.length + " items");
                }
                Arrays.sort(fileStatuses, this.getFsOrderComparator());
            }
            if (!this.pathOnly) {
                this.adjustColumnWidths(fileStatuses);
            }
        }

        @Override
        protected void processPaths(PathData parent, PathData ... items) throws IOException {
            if (parent != null && !this.isRecursive() && items.length != 0) {
                if (!this.pathOnly) {
                    this.out.println("Found " + items.length + " items");
                }
                Arrays.sort(items, this.getOrderComparator());
            }
            if (!this.pathOnly) {
                this.adjustColumnWidths(items);
            }
            super.processPaths(parent, items);
        }

        @Override
        protected void processPath(PathData item) throws IOException {
            this.out.println(this.formatPathData(item));
        }

        public String formatPathData(PathData item) {
            if (this.pathOnly) {
                return item.toString();
            }
            FileStatus stat = item.stat;
            if (this.isShowExtended()) {
                String line = String.format(this.lineFormat, stat.isDirectory() ? OPTION_DIRECTORY : "-", stat.getPermission() + (stat.getPermission().getAclBit() ? "+" : " "), stat.isFile() ? Short.valueOf(stat.getReplication()) : "-", stat.getOwner(), stat.getGroup(), this.getExtendedAttr(stat), this.formatSize(stat.getLen()), dateFormat.get().format(new Date(this.isUseAtime() ? stat.getAccessTime() : stat.getModificationTime())), this.isHideNonPrintable() ? new PrintableString(item.toString()) : item);
                return line;
            }
            String line = String.format(this.lineFormat, stat.isDirectory() ? OPTION_DIRECTORY : "-", stat.getPermission() + (stat.getPermission().getAclBit() ? "+" : " "), stat.isFile() ? Short.valueOf(stat.getReplication()) : "-", stat.getOwner(), stat.getGroup(), this.formatSize(stat.getLen()), dateFormat.get().format(new Date(this.isUseAtime() ? stat.getAccessTime() : stat.getModificationTime())), this.isHideNonPrintable() ? new PrintableString(item.toString()) : item);
            return line;
        }

        public String formatFileStatus(FileStatus stat) {
            if (this.pathOnly) {
                return stat.getPath().toString();
            }
            if (this.isShowExtended()) {
                String line = String.format(this.lineFormat, stat.isDirectory() ? OPTION_DIRECTORY : "-", stat.getPermission() + (stat.getPermission().getAclBit() ? "+" : " "), stat.isFile() ? Short.valueOf(stat.getReplication()) : "-", stat.getOwner(), stat.getGroup(), this.getExtendedAttr(stat), this.formatSize(stat.getLen()), dateFormat.get().format(new Date(this.isUseAtime() ? stat.getAccessTime() : stat.getModificationTime())), stat.getPath());
                return line;
            }
            String line = String.format(this.lineFormat, stat.isDirectory() ? OPTION_DIRECTORY : "-", stat.getPermission() + (stat.getPermission().getAclBit() ? "+" : " "), stat.isFile() ? Short.valueOf(stat.getReplication()) : "-", stat.getOwner(), stat.getGroup(), this.formatSize(stat.getLen()), dateFormat.get().format(new Date(this.isUseAtime() ? stat.getAccessTime() : stat.getModificationTime())), stat.getPath());
            return line;
        }

        private void adjustColumnWidths(PathData[] items) {
            for (PathData item : items) {
                FileStatus stat = item.stat;
                this.maxRepl = this.maxLength(this.maxRepl, stat.getReplication());
                this.maxLen = this.maxLength(this.maxLen, stat.getLen());
                this.maxOwner = this.maxLength(this.maxOwner, stat.getOwner());
                this.maxGroup = this.maxLength(this.maxGroup, stat.getGroup());
                if (!this.isShowExtended()) continue;
                this.maxExtended = this.maxLength(this.maxExtended, this.getExtendedAttr(stat));
            }
            this.adjustColumnWidthsCore();
        }

        private void adjustColumnWidths(FileStatus[] fs) {
            for (FileStatus stat : fs) {
                this.maxRepl = this.maxLength(this.maxRepl, stat.getReplication());
                this.maxLen = this.maxLength(this.maxLen, stat.getLen());
                this.maxOwner = this.maxLength(this.maxOwner, stat.getOwner());
                this.maxGroup = this.maxLength(this.maxGroup, stat.getGroup());
                if (!this.isShowExtended()) continue;
                this.maxExtended = this.maxLength(this.maxExtended, this.getExtendedAttr(stat));
            }
            this.adjustColumnWidthsCore();
        }

        private void adjustColumnWidthsCore() {
            StringBuilder fmt = new StringBuilder();
            fmt.append("%s%s");
            fmt.append("%" + this.maxRepl + "s ");
            fmt.append(this.maxOwner > 0 ? "%-" + this.maxOwner + "s " : "%s");
            fmt.append(this.maxGroup > 0 ? "%-" + this.maxGroup + "s " : "%s");
            if (this.isShowExtended()) {
                fmt.append(this.maxExtended > 0 ? "%-" + this.maxExtended + "s " : "%s");
            }
            fmt.append("%" + this.maxLen + "s ");
            fmt.append("%s %s");
            this.lineFormat = fmt.toString();
        }

        private int maxLength(int n, Object value) {
            return Math.max(n, value != null ? String.valueOf(value).length() : 0);
        }

        private Comparator<PathData> getOrderComparator() {
            return this.orderComparator;
        }

        private Comparator<FileStatus> getFsOrderComparator() {
            return this.fsOrderComparator;
        }

        private void initialiseOrderComparator() {
            if (this.isOrderTime()) {
                this.orderComparator = new Comparator<PathData>(){

                    @Override
                    public int compare(PathData o1, PathData o2) {
                        Long o1Time = this.isUseAtime() ? o1.stat.getAccessTime() : o1.stat.getModificationTime();
                        Long o2Time = this.isUseAtime() ? o2.stat.getAccessTime() : o2.stat.getModificationTime();
                        return o2Time.compareTo(o1Time) * (this.isOrderReverse() ? -1 : 1);
                    }
                };
                this.fsOrderComparator = new Comparator<FileStatus>(){

                    @Override
                    public int compare(FileStatus o1, FileStatus o2) {
                        Long o1Time = this.isUseAtime() ? o1.getAccessTime() : o1.getModificationTime();
                        Long o2Time = this.isUseAtime() ? o2.getAccessTime() : o2.getModificationTime();
                        return o2Time.compareTo(o1Time) * (this.isOrderReverse() ? -1 : 1);
                    }
                };
            } else if (this.isOrderSize()) {
                this.orderComparator = new Comparator<PathData>(){

                    @Override
                    public int compare(PathData o1, PathData o2) {
                        Long o1Length = o1.stat.getLen();
                        Long o2Length = o2.stat.getLen();
                        return o2Length.compareTo(o1Length) * (this.isOrderReverse() ? -1 : 1);
                    }
                };
                this.fsOrderComparator = new Comparator<FileStatus>(){

                    @Override
                    public int compare(FileStatus o1, FileStatus o2) {
                        Long o1Length = o1.getLen();
                        Long o2Length = o2.getLen();
                        return o2Length.compareTo(o1Length) * (this.isOrderReverse() ? -1 : 1);
                    }
                };
            } else {
                this.orderComparator = new Comparator<PathData>(){

                    @Override
                    public int compare(PathData o1, PathData o2) {
                        return o1.compareTo(o2) * (this.isOrderReverse() ? -1 : 1);
                    }
                };
                this.fsOrderComparator = new Comparator<FileStatus>(){

                    @Override
                    public int compare(FileStatus o1, FileStatus o2) {
                        return o1.compareTo(o2) * (this.isOrderReverse() ? -1 : 1);
                    }
                };
            }
        }

        private String getExtendedAttr(FileStatus stat) {
            if (stat instanceof OssFileStatus) {
                return stat.isFile() ? ((OssFileStatus)stat).getStorageClass() : "-";
            }
            if (stat instanceof JfsFileStatus) {
                return this.getJfsExtendedAttr((JfsFileStatus)stat);
            }
            return "";
        }

        private String getJfsExtendedAttr(JfsFileStatus status) {
            if (status.isFile()) {
                if (status.getState() != null && status.getState().startsWith("To")) {
                    return status.getStorageClass() + "_ING";
                }
                return status.getStorageClass();
            }
            return "-";
        }

        public static class Ls2
        extends Ls {
            public static final String NAME = "ls2";
            public static final String USAGE = "[-C] [-d] [-h] [-q] [-R] [-t] [-S] [-r] [-u] [-e] [<path> ...]";
            public static final String DESCRIPTION = "List the contents that match the specified file pattern. If path is not specified, the contents of /user/<currentUser> will be listed. For a directory a list of its direct children is returned (unless -d option is specified).\n\nDirectory entries are of the form:\n\tpermissions - userId groupId sizeOfDirectory(in bytes) modificationDate(yyyy-MM-dd HH:mm) directoryName\n\nand file entries are of the form:\n\tpermissions numberOfReplicas userId groupId sizeOfFile(in bytes) modificationDate(yyyy-MM-dd HH:mm) fileName\n\n  -C  Display the paths of files and directories only.\n  -d  Directories are listed as plain files.\n  -h  Formats the sizes of files in a human-readable fashion\n      rather than a number of bytes.\n  -q  Print ? instead of non-printable characters.\n  -R  Recursively list the contents of directories.\n  -t  Sort files by modification time (most recent first).\n  -S  Sort files by size.\n  -r  Reverse the order of the sort.\n  -u  Use time of last access instead of modification for\n      display and sorting.  -e  Show extended info(StorageClass) of files, only JindoFS (Including oss:// via JindoFS) support this.      To enable this feature by default, you can use ls2 instead of ls,           or set \"hadoop.shell.ls.show.extended.enabled\" with \"true\" to core-site.xml; \n";

            @Override
            protected void processOptions(LinkedList<String> args) throws IOException {
                args.addFirst("-e");
                super.processOptions(args);
            }
        }

        public static class Lsr
        extends Ls {
            public static final String NAME = "lsr";
            public static final String USAGE = "[-C] [-d] [-h] [-q] [-R] [-t] [-S] [-r] [-u] [-e] [<path> ...]";
            public static final String DESCRIPTION = "List the contents that match the specified file pattern. If path is not specified, the contents of /user/<currentUser> will be listed. For a directory a list of its direct children is returned (unless -d option is specified).\n\nDirectory entries are of the form:\n\tpermissions - userId groupId sizeOfDirectory(in bytes) modificationDate(yyyy-MM-dd HH:mm) directoryName\n\nand file entries are of the form:\n\tpermissions numberOfReplicas userId groupId sizeOfFile(in bytes) modificationDate(yyyy-MM-dd HH:mm) fileName\n\n  -C  Display the paths of files and directories only.\n  -d  Directories are listed as plain files.\n  -h  Formats the sizes of files in a human-readable fashion\n      rather than a number of bytes.\n  -q  Print ? instead of non-printable characters.\n  -R  Recursively list the contents of directories.\n  -t  Sort files by modification time (most recent first).\n  -S  Sort files by size.\n  -r  Reverse the order of the sort.\n  -u  Use time of last access instead of modification for\n      display and sorting.  -e  Show extended info(StorageClass) of files, only JindoFS (Including oss:// via JindoFS) support this.      To enable this feature by default, you can use ls2 instead of ls,           or set \"hadoop.shell.ls.show.extended.enabled\" with \"true\" to core-site.xml; \n";

            @Override
            protected void processOptions(LinkedList<String> args) throws IOException {
                args.addFirst("-R");
                super.processOptions(args);
            }

            @Override
            public String getReplacementCommand() {
                return "ls -R";
            }
        }
    }
}

