/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import com.aliyun.emr.fs.jfs.JindoFileSystem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.FsCommandProvider;
import org.apache.hadoop.fs.shell.JfsChmodParser;
import org.apache.hadoop.fs.shell.JindoFsCommandShims;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.util.Shell;

public class JfsPermission
implements FsCommandProvider {
    @Override
    public Class<? extends FsCommand> getCommandClass() {
        return FsShellPermissions.class;
    }

    public static class FsShellPermissions
    extends FsCommand {
        boolean isRecursiveCommand = false;
        Set<PathData> jfsSpecPermissionPaths = new HashSet<PathData>();
        static Log LOG = LogFactory.getLog(FsShell.class);
        private static String allowedChars = Shell.WINDOWS ? "[-_./@a-zA-Z0-9 ]" : "[-_./@a-zA-Z0-9]";

        protected List<PathData> expandArgument(String arg) throws IOException {
            if (arg.endsWith("*") || this.isRecursiveCommand) {
                try {
                    Path argPath = new Path(arg);
                    boolean isJfsSpecPermission = JindoFsCommandShims.isJfsBlockMode(argPath.getFileSystem(this.getConf()));
                    String lastSectionName = argPath.getName();
                    if (isJfsSpecPermission && lastSectionName.indexOf("*") == lastSectionName.lastIndexOf("*")) {
                        String argPathParent = argPath.getParent().toString();
                        PathData[] items = PathData.expandAsGlob((String)argPathParent, (Configuration)this.getConf());
                        if (items.length == 0) {
                            throw new PathNotFoundException(argPathParent);
                        }
                        ArrayList<PathData> ret = new ArrayList<PathData>(items.length);
                        for (PathData pd : items) {
                            PathData npd = new PathData(new Path(pd.path, lastSectionName).toString(), this.getConf());
                            npd.exists = true;
                            npd.stat = new FileStatus();
                            this.jfsSpecPermissionPaths.add(npd);
                            ret.add(npd);
                        }
                        return ret;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return super.expandArgument(arg);
        }

        protected void processPathArgument(PathData item) throws IOException {
            if (this.jfsSpecPermissionPaths.contains(item) && item.fs instanceof JindoFileSystem) {
                super.processPathArgument(item);
            } else {
                this.setRecursive(this.isRecursiveCommand);
                super.processPathArgument(item);
                this.setRecursive(false);
            }
        }

        public static void registerCommands(CommandFactory factory) {
            factory.addClass(Chmod.class, new String[]{"-chmod"});
            factory.addClass(Chown.class, new String[]{"-chown"});
            factory.addClass(Chgrp.class, new String[]{"-chgrp"});
        }

        static /* synthetic */ String access$000() {
            return allowedChars;
        }

        public static class Chgrp
        extends Chown {
            public static final String NAME = "chgrp";
            public static final String USAGE = "[-R] GROUP PATH...";
            public static final String DESCRIPTION = "This is equivalent to -chown ... :GROUP ...";
            private static final Pattern chgrpPattern = Pattern.compile("^\\s*(" + FsShellPermissions.access$000() + "+)\\s*$");

            @Override
            protected void parseOwnerGroup(String groupStr) {
                Matcher matcher = chgrpPattern.matcher(groupStr);
                if (!matcher.matches()) {
                    throw new IllegalArgumentException("'" + groupStr + "' does not match expected pattern for group");
                }
                this.owner = null;
                this.group = matcher.group(1);
            }
        }

        public static class Chown
        extends FsShellPermissions {
            public static final String NAME = "chown";
            public static final String USAGE = "[-R] [OWNER][:[GROUP]] PATH...";
            public static final String DESCRIPTION = "Changes owner and group of a file. This is similar to the shell's chown command with a few exceptions.\n-R: modifies the files recursively. This is the only option currently supported.\n\nIf only the owner or group is specified, then only the owner or group is modified. The owner and group names may only consist of digits, alphabet, and any of " + FsShellPermissions.access$000() + ". The names are case sensitive.\n\nWARNING: Avoid using '.' to separate user name and group though Linux allows it. If user names have dots in them and you are using local file system, you might see surprising results since the shell command 'chown' is used for local files.";
            private static final Pattern chownPattern = Pattern.compile("^\\s*(" + FsShellPermissions.access$000() + "+)?([:](" + FsShellPermissions.access$000() + "*))?\\s*$");
            protected String owner = null;
            protected String group = null;

            protected void processOptions(LinkedList<String> args) throws IOException {
                CommandFormat cf = new CommandFormat(2, Integer.MAX_VALUE, new String[]{"R"});
                cf.parse(args);
                this.isRecursiveCommand = cf.getOpt("R");
                this.parseOwnerGroup(args.removeFirst());
            }

            protected void parseOwnerGroup(String ownerStr) {
                Matcher matcher = chownPattern.matcher(ownerStr);
                if (!matcher.matches()) {
                    throw new IllegalArgumentException("'" + ownerStr + "' does not match expected pattern for [owner][:group].");
                }
                this.owner = matcher.group(1);
                this.group = matcher.group(3);
                if (this.group != null && this.group.length() == 0) {
                    this.group = null;
                }
                if (this.owner == null && this.group == null) {
                    throw new IllegalArgumentException("'" + ownerStr + "' does not specify owner or group.");
                }
            }

            protected void processPath(PathData item) throws IOException {
                String newGroup;
                String newOwner = this.owner == null || this.owner.equals(item.stat.getOwner()) ? null : this.owner;
                String string = newGroup = this.group == null || this.group.equals(item.stat.getGroup()) ? null : this.group;
                if (newOwner != null || newGroup != null) {
                    try {
                        if (this.jfsSpecPermissionPaths.contains(item) && item.fs instanceof JindoFileSystem) {
                            JindoFileSystem jfs = (JindoFileSystem)item.fs;
                            jfs.setOwner(item.path, newOwner, newGroup, this.isRecursiveCommand);
                        } else {
                            item.fs.setOwner(item.path, newOwner, newGroup);
                        }
                    }
                    catch (IOException e) {
                        LOG.debug((Object)("Error changing ownership of " + item), (Throwable)e);
                        throw new IOException("changing ownership of '" + item + "': " + e.getMessage());
                    }
                }
            }
        }

        public static class Chmod
        extends FsShellPermissions {
            public static final String NAME = "chmod";
            public static final String USAGE = "[-R] <MODE[,MODE]... | OCTALMODE> PATH...";
            public static final String DESCRIPTION = "Changes permissions of a file. This works similar to the shell's chmod command with a few exceptions.\n-R: modifies the files recursively. This is the only option currently supported.\n<MODE>: Mode is the same as mode used for the shell's command. The only letters recognized are 'rwxXt', e.g. +t,a+r,g-w,+rwx,o=r.\n<OCTALMODE>: Mode specifed in 3 or 4 digits. If 4 digits, the first may be 1 or 0 to turn the sticky bit on or off, respectively.  Unlike the shell command, it is not possible to specify only part of the mode, e.g. 754 is same as u=rwx,g=rx,o=r.\n\nIf none of 'augo' is specified, 'a' is assumed and unlike the shell command, no umask is applied.";
            protected JfsChmodParser pp;

            protected void processOptions(LinkedList<String> args) throws IOException {
                CommandFormat cf = new CommandFormat(2, Integer.MAX_VALUE, new String[]{"R", null});
                cf.parse(args);
                this.isRecursiveCommand = cf.getOpt("R");
                String modeStr = args.removeFirst();
                try {
                    this.pp = new JfsChmodParser(modeStr);
                }
                catch (IllegalArgumentException iea) {
                    throw new IllegalArgumentException("chmod : mode '" + modeStr + "' does not match the expected pattern.");
                }
            }

            protected void processPath(PathData item) throws IOException {
                if (this.jfsSpecPermissionPaths.contains(item) && item.fs instanceof JindoFileSystem) {
                    JindoFileSystem jfs = (JindoFileSystem)item.fs;
                    jfs.setPermissionWithDelta(item.path, this.pp.getPermission(), this.pp.getDeta(), this.isRecursiveCommand);
                } else {
                    short newperms = this.pp.applyNewPermission(item.stat);
                    if (item.stat.getPermission().toShort() != newperms) {
                        try {
                            item.fs.setPermission(item.path, new FsPermission(newperms));
                        }
                        catch (IOException e) {
                            LOG.debug((Object)("Error changing permissions of " + item), (Throwable)e);
                            throw new IOException("changing permissions of '" + item + "': " + e.getMessage());
                        }
                    }
                }
            }
        }
    }
}

