/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.spark.sparksql;

import com.aliyun.odps.Odps;
import com.aliyun.odps.Partition;
import com.aliyun.odps.cupid.CupidSession;
import java.util.ArrayList;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;

public class JavaSparkSQL {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("SparkSQL-on-MaxCompute").config("spark.sql.broadcastTimeout", 1200L).config("spark.sql.crossJoin.enabled", true).config("odps.exec.dynamic.partition.mode", "nonstrict").getOrCreate();
        JavaSparkContext sparkContext = new JavaSparkContext(spark.sparkContext());
        String tableName = "mc_test_table";
        String tableNameCopy = "mc_test_table_copy";
        String ptTableName = "mc_test_pt_table";
        spark.sql("DROP TABLE IF EXISTS " + tableName);
        spark.sql("DROP TABLE IF EXISTS " + tableNameCopy);
        spark.sql("DROP TABLE IF EXISTS " + ptTableName);
        spark.sql("CREATE TABLE " + tableName + " (name STRING, num BIGINT)");
        spark.sql("CREATE TABLE " + ptTableName + " (name STRING, num BIGINT) PARTITIONED BY (pt1 STRING, pt2 STRING)");
        ArrayList<Integer> data = new ArrayList<Integer>();
        for (int i = 0; i < 100; ++i) {
            data.add(i);
        }
        JavaRDD dfRDD = sparkContext.parallelize(data, 2).map((Function)new Function<Integer, Row>(){

            public Row call(Integer i) {
                return RowFactory.create((Object[])new Object[]{"name-" + i.toString(), (long)i.intValue()});
            }
        });
        JavaRDD ptDfRDD = sparkContext.parallelize(data, 2).map((Function)new Function<Integer, Row>(){

            public Row call(Integer i) {
                return RowFactory.create((Object[])new Object[]{"name-" + i.toString(), (long)i.intValue(), "2018", "0601"});
            }
        });
        ArrayList<StructField> structFilelds = new ArrayList<StructField>();
        structFilelds.add(DataTypes.createStructField((String)"name", (DataType)DataTypes.StringType, (boolean)true));
        structFilelds.add(DataTypes.createStructField((String)"num", (DataType)DataTypes.LongType, (boolean)true));
        Dataset df = spark.createDataFrame(dfRDD, DataTypes.createStructType(structFilelds));
        structFilelds.add(DataTypes.createStructField((String)"pt1", (DataType)DataTypes.StringType, (boolean)true));
        structFilelds.add(DataTypes.createStructField((String)"pt2", (DataType)DataTypes.StringType, (boolean)true));
        Dataset ptDf = spark.createDataFrame(ptDfRDD, DataTypes.createStructType(structFilelds));
        df.write().insertInto(tableName);
        df.write().mode("overwrite").insertInto(tableName);
        Dataset rdf = spark.sql("select name, num from " + tableName);
        System.out.println("rdf count: " + rdf.count());
        rdf.printSchema();
        spark.sql("CREATE TABLE " + tableNameCopy + " AS SELECT name, num FROM " + tableName);
        spark.sql("SELECT * FROM " + tableNameCopy).show();
        df.registerTempTable(ptTableName + "_tmp_view");
        spark.sql("insert into table " + ptTableName + " partition (pt1='2018', pt2='0601') select * from " + ptTableName + "_tmp_view");
        spark.sql("insert overwrite table " + ptTableName + " partition (pt1='2018', pt2='0601') select * from " + ptTableName + "_tmp_view");
        ptDf.write().insertInto(ptTableName);
        ptDf.write().mode("overwrite").insertInto(ptTableName);
        Dataset rptdf = spark.sql("select name, num, pt1, pt2 from " + ptTableName + " where pt1 = '2018' and pt2 = '0601'");
        System.out.println("rptdf count: " + rptdf.count());
        rptdf.printSchema();
        Odps odps = CupidSession.get().odps();
        System.out.println(odps.tables().get(ptTableName).getPartitions().size());
        System.out.println(((Partition)odps.tables().get(ptTableName).getPartitions().get(0)).getPartitionSpec());
    }
}

