/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    public static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static ThreadLocal<SimpleDateFormat> simpleDateFormatThreadLocal = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };

    public static boolean before(String time1, String time2) {
        try {
            Date dateTime1 = TIME_FORMAT.parse(time1);
            Date dateTime2 = TIME_FORMAT.parse(time2);
            if (dateTime1.before(dateTime2)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean after(String time1, String time2) {
        try {
            Date dateTime1 = TIME_FORMAT.parse(time1);
            Date dateTime2 = TIME_FORMAT.parse(time2);
            if (dateTime1.after(dateTime2)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static int minus(String time1, String time2) {
        try {
            Date datetime1 = TIME_FORMAT.parse(time1);
            Date datetime2 = TIME_FORMAT.parse(time2);
            long millisecond = datetime1.getTime() - datetime2.getTime();
            return Integer.valueOf(String.valueOf(millisecond / 1000L));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static String getDateHour(String datetime) {
        String date = datetime.split(" ")[0];
        String hourMinuteSecond = datetime.split(" ")[1];
        String hour = hourMinuteSecond.split(":")[0];
        return date + "_" + hour;
    }

    public static String milliSecondsFormatTime(String time) {
        if (time == null || time.isEmpty()) {
            return "";
        }
        Date tmpDate = new Date();
        tmpDate.setTime(Long.parseLong(time));
        String dtime = simpleDateFormatThreadLocal.get().format(tmpDate);
        return dtime;
    }

    public static String getYesterdayDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(6, -1);
        Date date = cal.getTime();
        return DATE_FORMAT.format(date);
    }

    public static String getTodayDate() {
        return DATE_FORMAT.format(new Date());
    }

    public static String getTodayTime() {
        return simpleDateFormatThreadLocal.get().format(new Date());
    }

    public static String formatDate(Date date) {
        return DATE_FORMAT.format(date);
    }

    public static String formatTime(Date date) {
        return TIME_FORMAT.format(date);
    }

    public static Date parseTime(String time) {
        try {
            Date result = simpleDateFormatThreadLocal.get().parse(time);
            simpleDateFormatThreadLocal.remove();
            return result;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        Date date = new Date();
        System.out.println(date);
        System.out.println(DateUtils.parseTime("2020-03-30 11:45:18"));
        System.out.println(DateUtils.formatDate(date));
        System.out.println(DateUtils.formatTime(date));
        System.out.println(DateUtils.getYesterdayDate());
        String com = "005#";
        String[] strs = com.split("#");
        System.out.println("length is " + strs.length);
        System.out.println("0\u4f4d\u6570\u636e\u662f: " + strs[0]);
    }
}

