/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jboot;

import bigboot.protocol.type.CltFlushMultipartUploadReply;
import bigboot.protocol.type.CltOssDirectUploadResponse;
import bigboot.protocol.type.CltOssWriteCloseResponse;
import com.alibaba.jboot.JbootFuture;
import com.alibaba.jboot.UserLoginInfo;
import com.alibaba.jboot.buffer.JbootBufferFactory;
import com.alibaba.jboot.future.ByteBufferFuture;
import com.alibaba.jboot.jni.NativeClass;
import com.alibaba.jboot.protocols.CltWriterCacheRequestWrapper;
import com.alibaba.jboot.protocols.CommonJRequestWrapper;
import com.alibaba.jfs.JindoRequestPath;
import com.aliyun.emr.utils.StringUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class JbootS3Writer
extends NativeClass {
    private final JindoRequestPath path;
    private final UserLoginInfo ugi;
    private boolean closed = false;
    private ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private String requestId;
    private String etag;
    private String versionId;
    private int DEFAULT_FUTURE_TIMEOUT = 600;

    public JbootS3Writer(UserLoginInfo ugi, JindoRequestPath path) {
        this.ugi = ugi;
        this.path = path;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void write(ByteBuffer buffer) throws IOException {
        this.write(buffer, this.DEFAULT_FUTURE_TIMEOUT);
    }

    public void directUpload(ByteBuffer buffer) throws IOException {
        this.directUpload(buffer, this.DEFAULT_FUTURE_TIMEOUT);
    }

    public ReentrantReadWriteLock getWriterLock() {
        return this.rwl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDirect(ByteBuffer buffer, long blockIdx, boolean writeRam) throws IOException {
        JbootS3Writer jbootS3Writer = this;
        synchronized (jbootS3Writer) {
            if (this.closed) {
                throw new IOException("JbootBlockletWriter is closed");
            }
            ByteBuffer request = new CltWriterCacheRequestWrapper(this.ugi, this.path, blockIdx, true, true, writeRam).toDirectBuffer();
            try {
                JbootFuture f = this.writeDirect(request, buffer);
                f.get(this.DEFAULT_FUTURE_TIMEOUT, TimeUnit.SECONDS);
            }
            catch (ExecutionException ee) {
                throw new IOException(ee.getCause());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            finally {
                JbootBufferFactory.returnBuffer(request);
            }
        }
    }

    public void write(ByteBuffer buffer, int timeoutInSecond) throws IOException {
        ByteBuffer request = new CommonJRequestWrapper(this.ugi, this.path).toDirectBuffer();
        try {
            JbootFuture f = this.writeInternal(request, buffer);
            f.get(timeoutInSecond, TimeUnit.SECONDS);
        }
        catch (ExecutionException ee) {
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public void directUpload(ByteBuffer buffer, int timeoutInSecond) throws IOException {
        ByteBuffer request = new CommonJRequestWrapper(this.ugi, this.path).toDirectBuffer();
        try {
            ByteBufferFuture f = new ByteBufferFuture(this.directUpload(request, buffer));
            ByteBuffer result = f.get(timeoutInSecond, TimeUnit.SECONDS);
            CltOssDirectUploadResponse response = CltOssDirectUploadResponse.getRootAsCltOssDirectUploadResponse(result);
            this.requestId = response.requestId();
            this.etag = response.etag();
            this.versionId = response.versionId();
        }
        catch (ExecutionException ee) {
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public CltFlushMultipartUploadReply flushMultipartUpload() throws IOException {
        return this.flushMultipartUpload(this.DEFAULT_FUTURE_TIMEOUT);
    }

    public CltFlushMultipartUploadReply flushMultipartUpload(int timeoutInSecond) throws IOException {
        ByteBuffer request = new CommonJRequestWrapper(this.ugi, this.path).toDirectBuffer();
        try {
            ByteBufferFuture f = new ByteBufferFuture(this.flushMultipartUploadInternal(request));
            ByteBuffer result = f.get(timeoutInSecond, TimeUnit.SECONDS);
            CltFlushMultipartUploadReply cltFlushMultipartUploadReply = CltFlushMultipartUploadReply.getRootAsCltFlushMultipartUploadReply(result);
            return cltFlushMultipartUploadReply;
        }
        catch (ExecutionException ee) {
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushFile(int timeoutInSecond) throws IOException {
        IOException lastException;
        ByteBuffer request = new CommonJRequestWrapper(this.ugi, this.path).toDirectBuffer();
        try {
            JbootFuture f = this.flushInternal(request);
            f.get(timeoutInSecond, TimeUnit.SECONDS);
            return;
        }
        catch (ExecutionException ee) {
            lastException = new IOException(ee.getCause());
        }
        catch (Exception e) {
            lastException = new IOException(e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
        throw lastException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizeFile() throws IOException {
        JbootS3Writer jbootS3Writer = this;
        synchronized (jbootS3Writer) {
            this.finalizeFile(this.DEFAULT_FUTURE_TIMEOUT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizeFile(int timeoutInSecond) throws IOException {
        IOException lastException;
        ByteBuffer request = new CommonJRequestWrapper(this.ugi, this.path).toDirectBuffer();
        try {
            ByteBufferFuture f = new ByteBufferFuture(this.finalizeInternal(request));
            ByteBuffer result = f.get(timeoutInSecond, TimeUnit.SECONDS);
            CltOssWriteCloseResponse response = CltOssWriteCloseResponse.getRootAsCltOssWriteCloseResponse(result);
            if (!StringUtils.isEmpty(response.requestId())) {
                this.requestId = response.requestId();
                this.etag = response.etag();
                this.versionId = response.versionId();
            }
            return;
        }
        catch (ExecutionException ee) {
            lastException = new IOException(ee.getCause());
        }
        catch (Exception e) {
            lastException = new IOException(e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
        throw lastException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        JbootS3Writer jbootS3Writer = this;
        synchronized (jbootS3Writer) {
            if (this.closed) {
                return;
            }
            this.destroy();
            this.closed = true;
        }
    }

    public boolean isClose() {
        return this.closed;
    }

    private native JbootFuture writeInternal(ByteBuffer var1, ByteBuffer var2);

    private native JbootFuture writeDirect(ByteBuffer var1, ByteBuffer var2);

    private native JbootFuture flushInternal(ByteBuffer var1);

    private native JbootFuture finalizeInternal(ByteBuffer var1);

    private native JbootFuture flushMultipartUploadInternal(ByteBuffer var1);

    private native JbootFuture directUpload(ByteBuffer var1, ByteBuffer var2);

    @Override
    protected native void destroy();
}

