/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jboot.protocols;

import bigboot.protocol.type.CltFileChecksumRequest;
import com.alibaba.jboot.UserLoginInfo;
import com.alibaba.jboot.google.flatbuffers.FlatBufferBuilder;
import com.alibaba.jboot.google.flatbuffers.JbootFlatBufferBuilder;
import com.alibaba.jboot.protocols.JniRequestWrapper;
import com.alibaba.jfs.JindoRequestPath;
import java.nio.ByteBuffer;

public class FileChecksumRequestWrapper
extends JniRequestWrapper {
    private String path;
    private byte algorithm = 1;
    private long blockSize = 0x8000000L;

    public FileChecksumRequestWrapper(UserLoginInfo ugi, JindoRequestPath path, byte algorithm, long blockSize) {
        this.ugi = ugi;
        this.path = path.getPath();
        this.ossContext = path.getOssContext();
        this.nsConnectorPtr = path.getNsConnectorPtr();
        this.algorithm = algorithm;
        this.blockSize = blockSize;
    }

    @Override
    protected ByteBuffer toFbBuffer() {
        JbootFlatBufferBuilder builder = new JbootFlatBufferBuilder();
        int pathOffset = ((FlatBufferBuilder)builder).createString(this.path);
        int requestHeaderOffset = this.getRequestHeader(builder, this.getNsName(this.path), this.path);
        CltFileChecksumRequest.startCltFileChecksumRequest(builder);
        CltFileChecksumRequest.addPath(builder, pathOffset);
        CltFileChecksumRequest.addAlgorithm(builder, this.algorithm);
        CltFileChecksumRequest.addBlockSize(builder, this.blockSize);
        CltFileChecksumRequest.addRequestHeader(builder, requestHeaderOffset);
        builder.finish(CltFileChecksumRequest.endCltFileChecksumRequest(builder));
        ByteBuffer buffer = builder.dataBuffer();
        return buffer;
    }
}

