/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jboot.protocols;

import bigboot.protocol.type.NssFileletRenameRequest;
import com.alibaba.jboot.UserLoginInfo;
import com.alibaba.jboot.google.flatbuffers.FlatBufferBuilder;
import com.alibaba.jboot.google.flatbuffers.JbootFlatBufferBuilder;
import com.alibaba.jboot.protocols.JniRequestWrapper;
import com.alibaba.jfs.JindoRequestPath;
import java.nio.ByteBuffer;

public class FileletRenameRequestWrapper
extends JniRequestWrapper {
    private String oldPath;
    private String newPath;
    boolean appendName;
    boolean ignoreHidden;

    public FileletRenameRequestWrapper(UserLoginInfo ugi, JindoRequestPath oldPath, String newPath, boolean appendName, boolean ignoreHidden) {
        this.ugi = ugi;
        this.oldPath = oldPath.getPath();
        this.ossContext = oldPath.getOssContext();
        this.nsConnectorPtr = oldPath.getNsConnectorPtr();
        this.newPath = newPath;
        this.appendName = appendName;
        this.ignoreHidden = ignoreHidden;
    }

    @Override
    protected ByteBuffer toFbBuffer() {
        JbootFlatBufferBuilder builder = new JbootFlatBufferBuilder();
        int oldPathOffset = ((FlatBufferBuilder)builder).createString(this.oldPath);
        int newPathOffset = ((FlatBufferBuilder)builder).createString(this.newPath);
        int requestHeaderOffset = this.getRequestHeader(builder, this.getNsName(this.newPath), this.newPath);
        NssFileletRenameRequest.startNssFileletRenameRequest(builder);
        NssFileletRenameRequest.addSrcPath(builder, oldPathOffset);
        NssFileletRenameRequest.addDstPath(builder, newPathOffset);
        NssFileletRenameRequest.addAppendName(builder, this.appendName);
        NssFileletRenameRequest.addIgnoreHidden(builder, this.ignoreHidden);
        NssFileletRenameRequest.addRequestHeader(builder, requestHeaderOffset);
        builder.finish(NssFileletRenameRequest.endNssFileletRenameRequest(builder));
        ByteBuffer buffer = builder.dataBuffer();
        return buffer;
    }
}

