/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.buffer;

import com.aliyun.emr.utils.IOUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class SmartBuffer {
    private ByteBuffer buffer;

    public SmartBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public ByteBuffer release() {
        ByteBuffer tmp = this.buffer;
        this.buffer = null;
        return tmp;
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    public byte[] asArrayBuffer() {
        if (this.buffer.hasArray()) {
            return this.buffer.array();
        }
        throw new IllegalStateException("buffer isn't array backed");
    }

    public void storeInto(OutputStream outputStream) throws IOException {
        int remaining = this.buffer().remaining();
        IOUtils.write(Arrays.copyOfRange(this.buffer().array(), 0, remaining), outputStream);
    }

    public void readFrom(InputStream inputStream) throws IOException {
        try {
            IOUtils.readFully(inputStream, this.buffer().array());
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    protected void setBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }
}

