/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.auth.delegation;

import com.aliyun.emr.fs.auth.AliyunCredentialProviderList;
import com.aliyun.emr.fs.auth.AliyunCredentialsProvider;
import com.aliyun.emr.fs.auth.AuthUtils;
import com.aliyun.emr.fs.auth.MarshalledCredentialBinding;
import com.aliyun.emr.fs.auth.MarshalledCredentialProvider;
import com.aliyun.emr.fs.auth.MarshalledCredentials;
import com.aliyun.emr.fs.auth.delegation.AbstractDelegationTokenBinding;
import com.aliyun.emr.fs.auth.delegation.AbstractOssTokenIdentifier;
import com.aliyun.emr.fs.auth.delegation.DelegationConstants;
import com.aliyun.emr.fs.auth.delegation.FullCredentialsTokenIdentifier;
import com.aliyun.emr.fs.internal.oss.OssLoginHelper;
import com.aliyun.emr.shade.google_guava.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;

public class FullCredentialsTokenBinding
extends AbstractDelegationTokenBinding {
    private static final String NAME = "FullCredentials/001";
    public static final String FULL_TOKEN = "Full Delegation Token";
    private MarshalledCredentials aliyunCredentials;
    private String credentialOrigin;

    public FullCredentialsTokenBinding() {
        super(NAME, DelegationConstants.FULL_TOKEN_KIND);
    }

    @Override
    protected void serviceStart() throws Exception {
        super.serviceStart();
    }

    private void loadAliyunCredentials() throws IOException {
        this.credentialOrigin = AbstractOssTokenIdentifier.createDefaultOriginMessage();
        Configuration conf = this.getConfig();
        URI uri = this.getCanonicalUri();
        OssLoginHelper.Login secrets = AuthUtils.getAliyunAccessKeys(uri, conf, AliyunCredentialsProvider.CredentialType.OSS);
        if (secrets.hasLogin()) {
            this.aliyunCredentials = new MarshalledCredentials(secrets.getUser(), secrets.getPassword(), "");
            this.credentialOrigin = this.credentialOrigin + "; source = Hadoop configuration data";
        } else {
            this.aliyunCredentials = MarshalledCredentialBinding.fromEnvironment(System.getenv());
            this.credentialOrigin = this.aliyunCredentials.isValid(MarshalledCredentials.CredentialTypeRequired.AnyNonEmpty) ? this.credentialOrigin + "; source = Environment variables" : "no credentials in configuration or environment variables";
        }
        this.aliyunCredentials.validate(this.credentialOrigin + ": ", MarshalledCredentials.CredentialTypeRequired.AnyNonEmpty);
    }

    @Override
    public AliyunCredentialProviderList deployUnbonded() throws IOException {
        this.requireServiceStarted();
        this.loadAliyunCredentials();
        return new AliyunCredentialProviderList("Full Credentials Token Binding", new MarshalledCredentialProvider(FULL_TOKEN, this.getCanonicalUri(), this.getConfig(), this.aliyunCredentials, MarshalledCredentials.CredentialTypeRequired.AnyNonEmpty));
    }

    @Override
    public AbstractOssTokenIdentifier createTokenIdentifier(Text renewer) throws IOException {
        this.requireServiceStarted();
        Preconditions.checkNotNull(this.aliyunCredentials, "No ALIYUN credentials to use for a delegation token");
        return new FullCredentialsTokenIdentifier(this.getCanonicalUri(), this.getOwnerText(), renewer, this.aliyunCredentials, this.credentialOrigin);
    }

    @Override
    public AliyunCredentialProviderList bindToTokenIdentifier(AbstractOssTokenIdentifier retrievedIdentifier) throws IOException {
        FullCredentialsTokenIdentifier tokenIdentifier = this.convertTokenIdentifier(retrievedIdentifier, FullCredentialsTokenIdentifier.class);
        return new AliyunCredentialProviderList("Full Credentials Token Binding", new MarshalledCredentialProvider(FULL_TOKEN, this.getCanonicalUri(), this.getConfig(), tokenIdentifier.getMarshalledCredentials(), MarshalledCredentials.CredentialTypeRequired.AnyNonEmpty));
    }

    @Override
    public AbstractOssTokenIdentifier createEmptyIdentifier() {
        return new FullCredentialsTokenIdentifier();
    }
}

