/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.bench;

import com.aliyun.emr.fs.bench.RandomStringUtils;
import com.aliyun.emr.fs.jfs.JindoFileSystem;
import java.io.IOException;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;

public class NNBenchWithoutMR {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hdfs.NNBench");
    private static long startTime = 0L;
    private static int numFiles = 0;
    private static long threads = 1L;
    private static long filesPerReport = 1L;
    private static long blocksPerFile = 0L;
    private static long bytesPerFile = 1L;
    private static short replicationFactorPerFile = 1;
    private static AtomicInteger totalSuccess = new AtomicInteger(0);
    private static AtomicInteger totalException = new AtomicInteger(0);
    private static Path baseDir = null;
    private static FileSystem fileSys = null;
    private static ThreadLocal<Path> taskDir = ThreadLocal.withInitial(() -> {
        String randomString = RandomStringUtils.randomAlphabetic(10);
        return new Path(baseDir, randomString);
    });
    private static ThreadLocal<Integer> threadIndex = new ThreadLocal();
    private static byte[] buffer;
    private static long maxExceptionsPerFile;
    static SimpleDateFormat df;
    static long lastReportTime;
    static LinkedList<Integer> history;

    static void barrier() {
        long sleepTime;
        while ((sleepTime = startTime - System.currentTimeMillis()) > 0L) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static void handleException(String operation, Throwable e, int singleFileExceptions) {
        LOG.warn((Object)("Exception while " + operation + ": " + StringUtils.stringifyException((Throwable)e)));
        if ((long)singleFileExceptions >= maxExceptionsPerFile) {
            throw new RuntimeException(singleFileExceptions + " exceptions for a single file exceeds threshold. Aborting");
        }
    }

    static int createWrite() {
        int totalExceptions = 0;
        FSDataOutputStream out = null;
        for (int index = 0; index < numFiles; ++index) {
            boolean success;
            int singleFileExceptions = 0;
            do {
                try {
                    out = fileSys.create(new Path(taskDir.get(), "" + index), false, 512, replicationFactorPerFile, -1L);
                    long toBeWritten = bytesPerFile;
                    int nbytes = (int)Math.min((long)buffer.length, toBeWritten);
                    out.write(buffer, 0, nbytes);
                    out.close();
                    totalSuccess.incrementAndGet();
                    success = true;
                }
                catch (IOException ioe) {
                    success = false;
                    ++totalExceptions;
                    NNBenchWithoutMR.handleException("creating file #" + index, ioe, ++singleFileExceptions);
                }
            } while (!success);
        }
        return totalExceptions;
    }

    static int openRead() {
        int totalExceptions = 0;
        for (int index = 0; index < numFiles; ++index) {
            int singleFileExceptions = 0;
            try {
                FSDataInputStream in = fileSys.open(new Path(taskDir.get(), "" + index), 512);
                long toBeRead = bytesPerFile;
                while (toBeRead > 0L) {
                    int nbytes = (int)Math.min((long)buffer.length, toBeRead);
                    toBeRead -= (long)nbytes;
                    try {
                        in.read(buffer, 0, nbytes);
                    }
                    catch (IOException ioe) {
                        ++totalExceptions;
                        NNBenchWithoutMR.handleException("reading from file #" + index, ioe, ++singleFileExceptions);
                    }
                }
                in.close();
                continue;
            }
            catch (IOException ioe) {
                ++totalExceptions;
                NNBenchWithoutMR.handleException("opening file #" + index, ioe, ++singleFileExceptions);
            }
        }
        return totalExceptions;
    }

    static int rename() {
        int totalExceptions = 0;
        for (int index = 0; index < numFiles; ++index) {
            boolean success;
            int singleFileExceptions = 0;
            do {
                try {
                    fileSys.rename(new Path(taskDir.get(), "" + index), new Path(taskDir.get(), "A" + index));
                    success = true;
                }
                catch (IOException ioe) {
                    success = false;
                    ++totalExceptions;
                    NNBenchWithoutMR.handleException("creating file #" + index, ioe, ++singleFileExceptions);
                }
            } while (!success);
        }
        return totalExceptions;
    }

    static int delete() {
        int totalExceptions = 0;
        for (int index = 0; index < numFiles; ++index) {
            boolean success;
            int singleFileExceptions = 0;
            do {
                try {
                    fileSys.delete(new Path(taskDir.get(), "A" + index), true);
                    success = true;
                }
                catch (IOException ioe) {
                    success = false;
                    ++totalExceptions;
                    NNBenchWithoutMR.handleException("creating file #" + index, ioe, ++singleFileExceptions);
                }
            } while (!success);
        }
        return totalExceptions;
    }

    static Path getFinalPathByIndex(int index) {
        Path subdir0 = new Path(taskDir.get(), "" + index / 1000000);
        Path subdir1 = new Path(subdir0, "" + index % 1000000 / 1000);
        Path path = new Path(subdir1, "" + index % 1000);
        return path;
    }

    static synchronized void report() {
        while (true) {
            int avg;
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException var7) {
                return;
            }
            Date now = new Date();
            if (now.getTime() - lastReportTime <= 1000L) continue;
            int lastTotalSuccess = 0;
            if (!history.isEmpty()) {
                lastTotalSuccess = history.getLast();
            }
            int thisTotal = totalSuccess.get();
            int qps = thisTotal - lastTotalSuccess;
            int avg10 = 0;
            if (history.size() > 10) {
                avg = history.get(history.size() - 10);
                avg10 = (thisTotal - avg) / 10;
            }
            avg = thisTotal / (history.size() + 1);
            String time = df.format(now);
            System.out.println(time + " success:" + totalSuccess.get() + " exception:" + totalException.get() + ", qps:" + qps + ", avg10:" + avg10 + ", avg:" + avg);
            lastReportTime = now.getTime();
            history.offerLast(thisTotal);
        }
    }

    static int mkdir() {
        int totalExceptions = 0;
        for (int index = 0; index < numFiles; ++index) {
            boolean success;
            int singleFileExceptions = 0;
            do {
                try {
                    Path path = NNBenchWithoutMR.getFinalPathByIndex(index);
                    success = fileSys.mkdirs(path);
                    totalSuccess.incrementAndGet();
                }
                catch (IOException ioe) {
                    success = false;
                    ++totalExceptions;
                    totalException.incrementAndGet();
                    NNBenchWithoutMR.handleException("creating file #" + index, ioe, ++singleFileExceptions);
                }
            } while (!success);
        }
        return totalExceptions;
    }

    static int rmdir() {
        int totalExceptions = 0;
        for (int index = 0; index < numFiles; ++index) {
            boolean success;
            int singleFileExceptions = 0;
            do {
                try {
                    Path path = NNBenchWithoutMR.getFinalPathByIndex(index);
                    success = fileSys.delete(path, false);
                    totalSuccess.incrementAndGet();
                }
                catch (IOException ioe) {
                    success = false;
                    ++totalExceptions;
                    totalException.incrementAndGet();
                    NNBenchWithoutMR.handleException("creating file #" + index, ioe, ++singleFileExceptions);
                }
            } while (!success);
        }
        return totalExceptions;
    }

    static int createEmpty(boolean loadMode) {
        if (loadMode) {
            int theIdx = threadIndex.get();
            taskDir.set(new Path(baseDir, "emptyfile-t" + theIdx));
        }
        int totalExceptions = 0;
        for (int index = 0; index < numFiles; ++index) {
            boolean success;
            int singleFileExceptions = 0;
            do {
                try {
                    Path path = NNBenchWithoutMR.getFinalPathByIndex(index);
                    FSDataOutputStream out = fileSys.create(path);
                    out.close();
                    success = true;
                    totalSuccess.incrementAndGet();
                }
                catch (IOException ioe) {
                    success = false;
                    ++totalExceptions;
                    totalException.incrementAndGet();
                    NNBenchWithoutMR.handleException("creating file #" + index, ioe, ++singleFileExceptions);
                }
            } while (!success);
        }
        return totalExceptions;
    }

    static int openEmpty() {
        int theIdx = threadIndex.get();
        taskDir.set(new Path(baseDir, "emptyfile-t" + theIdx));
        block2: while (true) {
            int index = 0;
            while (true) {
                boolean success;
                if (index >= numFiles) continue block2;
                int singleFileExceptions = 0;
                do {
                    try {
                        Path path = NNBenchWithoutMR.getFinalPathByIndex(index);
                        FSDataInputStream in = fileSys.open(path);
                        in.close();
                        success = true;
                        totalSuccess.incrementAndGet();
                    }
                    catch (IOException ioe) {
                        success = false;
                        totalException.incrementAndGet();
                        NNBenchWithoutMR.handleException("openEmpty file #" + index, ioe, ++singleFileExceptions);
                    }
                } while (!success);
                ++index;
            }
            break;
        }
    }

    static int statusEmpty() {
        int theIdx = threadIndex.get();
        taskDir.set(new Path(baseDir, "emptyfile-t" + theIdx));
        block2: while (true) {
            int index = 0;
            while (true) {
                boolean success;
                if (index >= numFiles) continue block2;
                int singleFileExceptions = 0;
                do {
                    try {
                        Path path = NNBenchWithoutMR.getFinalPathByIndex(index);
                        FileStatus status = fileSys.getFileStatus(path);
                        success = true;
                        totalSuccess.incrementAndGet();
                    }
                    catch (IOException ioe) {
                        success = false;
                        totalException.incrementAndGet();
                        NNBenchWithoutMR.handleException("statusEmpty file #" + index, ioe, ++singleFileExceptions);
                    }
                } while (!success);
                ++index;
            }
            break;
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        Configuration conf = new Configuration();
        String version = "NameNodeBenchmark.0.3";
        System.out.println(version);
        int bytesPerChecksum = -1;
        String usage = "Usage: nnbench   -operation <one of createWrite, openRead, rename, or delete>\n   -baseDir <base output/input DFS path>\n   -startTime <time to start, given in seconds from the epoch>\n  -numFiles <number of files to create>\n   -replicationFactorPerFile <Replication factor for the files, default is 1>\n  -blocksPerFile <number of blocks to create per file>\n  [-bytesPerBlock <number of bytes to write to each block, default is 1>]\n  [-bytesPerChecksum <value for io.bytes.per.checksum>]\nNote: bytesPerBlock MUST be a multiple of bytesPerChecksum\n";
        String operation = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-baseDir")) {
                baseDir = new Path(args[++i]);
                continue;
            }
            if (args[i].equals("-numFiles")) {
                numFiles = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-threads")) {
                threads = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-blocksPerFile")) {
                blocksPerFile = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-filesPerReport")) {
                filesPerReport = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equals("-bytesPerChecksum")) {
                bytesPerChecksum = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-replicationFactorPerFile")) {
                replicationFactorPerFile = Short.parseShort(args[++i]);
                continue;
            }
            if (args[i].equals("-startTime")) {
                startTime = Long.parseLong(args[++i]) * 1000L;
                continue;
            }
            if (args[i].equals("-operation")) {
                operation = args[++i];
                continue;
            }
            System.out.println(usage);
            System.exit(-1);
        }
        System.out.println("Inputs: ");
        System.out.println("   operation: " + operation);
        System.out.println("   baseDir: " + baseDir);
        System.out.println("   startTime: " + startTime);
        System.out.println("   numFiles: " + numFiles);
        System.out.println("   threads: " + threads);
        System.out.println("   replicationFactorPerFile: " + replicationFactorPerFile);
        System.out.println("   blocksPerFile: " + blocksPerFile);
        System.out.println("   filesPerReport: " + filesPerReport);
        System.out.println("   bytesPerChecksum: " + bytesPerChecksum);
        if (operation == null || baseDir == null || numFiles < 1) {
            System.err.println(usage);
            System.exit(-1);
        }
        fileSys = baseDir.toUri().getScheme().equals("jfs") ? new JindoFileSystem() : (baseDir.toUri().getScheme().equals("hdfs") ? FileSystem.get((Configuration)conf) : baseDir.getFileSystem(conf));
        fileSys.initialize(baseDir.toUri(), conf);
        String uniqueId = InetAddress.getLocalHost().getHostName();
        baseDir = new Path(baseDir, uniqueId);
        buffer = new byte[(int)Math.min(bytesPerFile, 32768L)];
        ArrayList<IndexedThread> threadList = new ArrayList<IndexedThread>();
        Runnable runnable = null;
        if (operation.equals("createWrite")) {
            if (!fileSys.mkdirs(baseDir)) {
                throw new IOException("Mkdirs failed to create " + taskDir.toString());
            }
            runnable = () -> NNBenchWithoutMR.createWrite();
        } else if (operation.equals("mkdir")) {
            runnable = () -> NNBenchWithoutMR.mkdir();
        } else if (operation.equals("rmdir")) {
            runnable = () -> NNBenchWithoutMR.rmdir();
        } else if (operation.equals("openRead")) {
            runnable = () -> NNBenchWithoutMR.openRead();
        } else if (operation.equals("openRead")) {
            runnable = () -> NNBenchWithoutMR.openRead();
        } else if (operation.equals("rename")) {
            runnable = () -> NNBenchWithoutMR.rename();
        } else if (operation.equals("delete")) {
            runnable = () -> NNBenchWithoutMR.delete();
        } else if (operation.equals("createEmpty")) {
            runnable = () -> NNBenchWithoutMR.createEmpty(false);
        } else if (operation.equals("loadEmpty")) {
            runnable = () -> NNBenchWithoutMR.createEmpty(true);
        } else if (operation.equals("openEmpty")) {
            runnable = () -> NNBenchWithoutMR.openEmpty();
        } else if (operation.equals("statusEmpty")) {
            runnable = () -> NNBenchWithoutMR.statusEmpty();
        } else {
            System.err.println(usage);
            System.exit(-1);
        }
        int i = 0;
        while ((long)i < threads) {
            IndexedThread t = new IndexedThread(runnable, i);
            threadList.add(t);
            ++i;
        }
        Thread reportThread = new Thread(() -> NNBenchWithoutMR.report());
        reportThread.setDaemon(true);
        reportThread.start();
        NNBenchWithoutMR.barrier();
        Date execTime = new Date();
        System.out.println("Job started: " + startTime);
        for (Thread thread : threadList) {
            thread.start();
        }
        for (Thread thread : threadList) {
            thread.join();
        }
        Date endTime = new Date();
        System.out.println("Job ended: " + endTime);
        long duration = (endTime.getTime() - execTime.getTime()) / 1000L;
        System.out.println("The " + operation + " job took " + duration + " seconds.");
        System.out.println("The job recorded " + totalException.get() + " exceptions.");
    }

    static {
        maxExceptionsPerFile = 200L;
        df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        lastReportTime = System.currentTimeMillis();
        history = new LinkedList();
    }

    public static class IndexedThread
    extends Thread {
        int idx;
        Runnable op;

        public IndexedThread(Runnable op, int idx) {
            this.idx = idx;
            this.op = op;
        }

        @Override
        public void run() {
            threadIndex.set(this.idx);
            this.op.run();
        }
    }
}

