/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.hdfs;

import com.aliyun.emr.fs.common.WrappedRemoteIterator;
import com.aliyun.emr.fs.internal.JindoPathResolver;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.BlockStoragePolicySpi;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JindoHdfsShimsFileSystem
extends DistributedFileSystem {
    public static final Logger LOG = LoggerFactory.getLogger(JindoHdfsShimsFileSystem.class);
    private JindoPathResolver pathResolver;

    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.pathResolver = new JindoPathResolver(conf, uri.getAuthority());
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(file.getPath());
        if (newPath == null) {
            return super.getFileBlockLocations(file, start, len);
        }
        return newPath.getTargetFS().getFileBlockLocations(newPath.getTargetPath(), start, len);
    }

    public BlockLocation[] getFileBlockLocations(Path p, long start, long len) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(p);
        if (newPath == null) {
            return super.getFileBlockLocations(p, start, len);
        }
        return newPath.getTargetFS().getFileBlockLocations(newPath.getTargetPath(), start, len);
    }

    public boolean recoverLease(Path path) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(path);
        if (newPath == null) {
            return super.recoverLease(path);
        }
        return true;
    }

    public FSDataInputStream open(Path path, int i) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(path);
        if (newPath == null) {
            return super.open(path, i);
        }
        return newPath.getTargetFS().open(newPath.getTargetPath(), i);
    }

    public FSDataOutputStream append(Path f, EnumSet<CreateFlag> flag, int bufferSize, Progressable progress) throws UnsupportedOperationException, IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(f);
        if (newPath == null) {
            return super.append(f, flag, bufferSize, progress);
        }
        return newPath.getTargetFS().append(newPath.getTargetPath(), bufferSize, progress);
    }

    public FSDataOutputStream create(Path path, FsPermission fsPermission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progressable) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(path);
        if (newPath == null) {
            return super.create(path, fsPermission, overwrite, bufferSize, replication, blockSize, progressable);
        }
        return newPath.getTargetFS().create(newPath.getTargetPath(), fsPermission, overwrite, bufferSize, replication, blockSize, progressable);
    }

    public HdfsDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress, InetSocketAddress[] favoredNodes) throws UnsupportedOperationException, IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(f);
        if (newPath == null) {
            return super.create(f, permission, overwrite, bufferSize, replication, blockSize, progress, favoredNodes);
        }
        throw new UnsupportedOperationException("Not implemented create(final Path f, final FsPermission permission, final boolean overwrite, final int bufferSize, final short replication, final long blockSize, final Progressable progress, final InetSocketAddress[] favoredNodes)!");
    }

    public FSDataOutputStream create(Path f, FsPermission permission, EnumSet<CreateFlag> cflags, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws UnsupportedOperationException, IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(f);
        if (newPath == null) {
            return super.create(f, permission, cflags, bufferSize, replication, blockSize, progress, checksumOpt);
        }
        return newPath.getTargetFS().create(newPath.getTargetPath(), permission, cflags, bufferSize, replication, blockSize, progress, checksumOpt);
    }

    protected HdfsDataOutputStream primitiveCreate(Path f, FsPermission absolutePermission, EnumSet<CreateFlag> flag, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws UnsupportedOperationException, IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(f);
        if (newPath == null) {
            return super.primitiveCreate(f, absolutePermission, flag, bufferSize, replication, blockSize, progress, checksumOpt);
        }
        throw new UnsupportedOperationException("Not implemented HdfsDataOutputStream primitiveCreate(Path f, FsPermission absolutePermission, EnumSet<CreateFlag> flag, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt)");
    }

    public FSDataOutputStream createNonRecursive(Path path, FsPermission permission, EnumSet<CreateFlag> flag, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(path);
        if (newPath == null) {
            return super.createNonRecursive(path, permission, flag, bufferSize, replication, blockSize, progress);
        }
        return newPath.getTargetFS().createNonRecursive(newPath.getTargetPath(), permission, flag, bufferSize, replication, blockSize, progress);
    }

    public boolean setReplication(Path src, short replication) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(src);
        if (newPath == null) {
            return super.setReplication(src, replication);
        }
        return newPath.getTargetFS().setReplication(newPath.getTargetPath(), replication);
    }

    public void setStoragePolicy(Path src, String policyName) throws UnsupportedOperationException, IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(src);
        if (newPath != null) {
            throw new UnsupportedOperationException("Not implemented setStoragePolicy(Path src, final String policyName)!");
        }
        super.setStoragePolicy(src, policyName);
    }

    public void unsetStoragePolicy(Path src) throws UnsupportedOperationException, IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(src);
        if (newPath != null) {
            throw new UnsupportedOperationException("Not implemented unsetStoragePolicy");
        }
        super.unsetStoragePolicy(src);
    }

    public BlockStoragePolicySpi getStoragePolicy(Path path) throws UnsupportedOperationException, IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(path);
        if (newPath == null) {
            return super.getStoragePolicy(path);
        }
        throw new UnsupportedOperationException("Not implemented getStoragePolicy(Path path)!");
    }

    public void concat(Path trg, Path[] psrcs) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(trg);
        if (newPath == null) {
            super.concat(trg, psrcs);
        } else {
            String targetAuthority = newPath.getTargetFS().getUri().getAuthority();
            Path[] newPathArray = new Path[psrcs.length];
            for (int i = 0; i < psrcs.length; ++i) {
                JindoPathResolver.JindoShimsPath transferedSource = this.pathResolver.getJindoShimsPath(psrcs[i]);
                if (!transferedSource.getTargetFS().getUri().getAuthority().equals(targetAuthority)) {
                    throw new UnsupportedOperationException("can not concat files across the filesystem, target filesystem: " + newPath.getTargetFS().getUri() + ", source: " + transferedSource.getTargetFS().getUri());
                }
                newPathArray[i] = transferedSource.getTargetPath();
            }
            newPath.getTargetFS().concat(newPath.getTargetPath(), newPathArray);
        }
    }

    public boolean rename(Path src, Path dst) throws IOException {
        JindoPathResolver.JindoShimsPath jindoPathSrc = this.pathResolver.getJindoShimsPath(src);
        JindoPathResolver.JindoShimsPath jindoPathDst = this.pathResolver.getJindoShimsPath(dst);
        if (jindoPathSrc == null && jindoPathDst == null) {
            return super.rename(src, dst);
        }
        if (jindoPathSrc == null || jindoPathDst == null) {
            throw new UnsupportedOperationException("can not support rename across filesystem");
        }
        if (!StringUtils.equalsIgnoreCase((String)jindoPathSrc.getTargetFS().getUri().getAuthority(), (String)jindoPathDst.getTargetFS().getUri().getAuthority())) {
            throw new UnsupportedOperationException("can not support rename across filesystem. src fs: " + jindoPathSrc.getTargetFS().getUri() + ", dst fs: " + jindoPathDst.getTargetFS().getUri());
        }
        return jindoPathSrc.getTargetFS().rename(jindoPathSrc.getTargetPath(), jindoPathDst.getTargetPath());
    }

    public void rename(Path src, Path dst, Options.Rename ... options) throws UnsupportedOperationException, IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(src);
        JindoPathResolver.JindoShimsPath newPathDest = this.pathResolver.getJindoShimsPath(dst);
        if (newPath == null && newPathDest == null) {
            super.rename(src, dst, options);
            return;
        }
        if (newPath == null || newPathDest == null) {
            throw new UnsupportedOperationException("rename can't across filesystem");
        }
        if (!StringUtils.equalsIgnoreCase((String)newPath.getTargetFS().getUri().getAuthority(), (String)newPathDest.getTargetFS().getUri().getAuthority())) {
            throw new UnsupportedOperationException("rename can't across filesystem");
        }
        if (newPath.getTargetPath().toString().equals(newPathDest.getTargetPath().toString())) {
            return;
        }
        try {
            Class<?> classType = newPath.getTargetFS().getClass();
            Method method = classType.getDeclaredMethod("rename", Path.class, Path.class, Options.Rename[].class);
            method.setAccessible(true);
            method.invoke((Object)newPath.getTargetFS(), newPath.getTargetPath(), newPathDest.getTargetPath(), options);
            return;
        }
        catch (NoSuchMethodException classType) {
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOG.warn("use reflection rename failed, ignore this and use FileSystem.rename method.", (Throwable)e);
        }
        if (options.length > 0 && options[0] == Options.Rename.OVERWRITE) {
            newPath.getTargetFS().delete(newPathDest.getTargetPath(), false);
            newPath.getTargetFS().rename(newPath.getTargetPath(), newPathDest.getTargetPath());
        } else {
            newPath.getTargetFS().rename(newPath.getTargetPath(), newPathDest.getTargetPath());
        }
    }

    public boolean truncate(Path f, long newLength) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(f);
        if (newPath == null) {
            return super.truncate(f, newLength);
        }
        return newPath.getTargetFS().truncate(newPath.getTargetPath(), newLength);
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(path);
        if (newPath == null) {
            return super.delete(path, recursive);
        }
        return newPath.getTargetFS().delete(newPath.getTargetPath(), recursive);
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(f);
        if (newPath == null) {
            return super.getContentSummary(f);
        }
        return newPath.getTargetFS().getContentSummary(newPath.getTargetPath());
    }

    public void setQuota(Path src, long namespaceQuota, long storagespaceQuota) throws UnsupportedOperationException, IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(src);
        if (newPath != null) {
            throw new UnsupportedOperationException("Not implemented setQuota(Path src, final long namespaceQuota, final long storagespaceQuota)!");
        }
        super.setQuota(src, namespaceQuota, storagespaceQuota);
    }

    public void setQuotaByStorageType(Path src, StorageType type, long quota) throws UnsupportedOperationException, IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(src);
        if (newPath != null) {
            throw new UnsupportedOperationException("Not implemented setQuotaByStorageType(Path src, final StorageType type, final long quota)!");
        }
        super.setQuotaByStorageType(src, type, quota);
    }

    public FileStatus[] listStatus(Path p) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(p);
        if (newPath == null) {
            List<JindoPathResolver.JindoShimsPath> pathList = this.pathResolver.getJindoShimsPathList(p);
            if (pathList == null) {
                return super.listStatus(p);
            }
            ArrayList<FileStatus> shimStatusList = new ArrayList<FileStatus>();
            for (JindoPathResolver.JindoShimsPath path : pathList) {
                FileStatus status = path.getTargetFS().getFileStatus(path.getTargetPath());
                status.setPath(new Path(path.getRewriteRule().getFromPath()));
                shimStatusList.add(status);
            }
            ArrayList<FileStatus> superList = new ArrayList<FileStatus>(Arrays.asList(super.listStatus(p)));
            superList.addAll(shimStatusList);
            return superList.toArray(new FileStatus[superList.size()]);
        }
        FileStatus[] fileStatuses = newPath.getTargetFS().listStatus(newPath.getTargetPath());
        for (int i = 0; i < fileStatuses.length; ++i) {
            fileStatuses[i].setPath(newPath.rewriteToSrcPath(fileStatuses[i].getPath(), this.getUri()));
        }
        return fileStatuses;
    }

    public RemoteIterator<LocatedFileStatus> listFiles(Path f, boolean recursive) throws FileNotFoundException, IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(f);
        if (newPath == null) {
            List<JindoPathResolver.JindoShimsPath> pathList = this.pathResolver.getJindoShimsPathList(f);
            if (pathList == null) {
                return super.listFiles(f, recursive);
            }
            final ArrayList<WrappedRemoteIterator<LocatedFileStatus>> iteratorList = new ArrayList<WrappedRemoteIterator<LocatedFileStatus>>();
            for (JindoPathResolver.JindoShimsPath path : pathList) {
                WrappedRemoteIterator<LocatedFileStatus> iterator = new WrappedRemoteIterator<LocatedFileStatus>(path.getTargetFS().listFiles(path.getTargetPath(), recursive), locatedFileStatus -> {
                    Path originPath = path.rewriteToSrcPath(locatedFileStatus.getPath(), this.getUri());
                    locatedFileStatus.setPath(originPath);
                    return locatedFileStatus;
                });
                iteratorList.add(iterator);
            }
            return new RemoteIterator<LocatedFileStatus>(){
                private int i = 0;

                public boolean hasNext() throws IOException {
                    while (this.i < iteratorList.size() && !((RemoteIterator)iteratorList.get(this.i)).hasNext()) {
                        ++this.i;
                    }
                    return this.i < iteratorList.size();
                }

                public LocatedFileStatus next() throws IOException {
                    while (this.i < iteratorList.size() && !((RemoteIterator)iteratorList.get(this.i)).hasNext()) {
                        ++this.i;
                    }
                    return (LocatedFileStatus)((RemoteIterator)iteratorList.get(this.i)).next();
                }
            };
        }
        return new WrappedRemoteIterator<LocatedFileStatus>(newPath.getTargetFS().listFiles(newPath.getTargetPath(), recursive), locatedFileStatus -> {
            Path originPath = newPath.rewriteToSrcPath(locatedFileStatus.getPath(), this.getUri());
            locatedFileStatus.setPath(originPath);
            return locatedFileStatus;
        });
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws FileNotFoundException, IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(f);
        if (newPath == null) {
            List<JindoPathResolver.JindoShimsPath> pathList = this.pathResolver.getJindoShimsPathList(f);
            if (pathList == null) {
                return super.listLocatedStatus(f);
            }
            final ArrayList<LocatedFileStatus> locatedFileStatuses = new ArrayList<LocatedFileStatus>();
            final RemoteIterator iterator = super.listLocatedStatus(f);
            for (JindoPathResolver.JindoShimsPath path : pathList) {
                FileStatus status = path.getTargetFS().getFileStatus(path.getTargetPath());
                status.setPath(new Path(path.getRewriteRule().getFromPath()));
                LocatedFileStatus s = new LocatedFileStatus(status, null);
                locatedFileStatuses.add(s);
            }
            return new RemoteIterator<LocatedFileStatus>(){
                private int i = 0;

                public boolean hasNext() throws IOException {
                    return iterator.hasNext() || this.i < locatedFileStatuses.size();
                }

                public LocatedFileStatus next() throws IOException {
                    if (iterator.hasNext()) {
                        return (LocatedFileStatus)iterator.next();
                    }
                    return (LocatedFileStatus)locatedFileStatuses.get(this.i++);
                }
            };
        }
        return new WrappedRemoteIterator<LocatedFileStatus>(newPath.getTargetFS().listLocatedStatus(newPath.getTargetPath()), locatedFileStatus -> {
            Path originPath = newPath.rewriteToSrcPath(locatedFileStatus.getPath(), this.getUri());
            locatedFileStatus.setPath(originPath);
            return locatedFileStatus;
        });
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path p, PathFilter filter) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(p);
        if (newPath == null) {
            List<JindoPathResolver.JindoShimsPath> pathList = this.pathResolver.getJindoShimsPathList(p);
            if (pathList == null) {
                return super.listLocatedStatus(p, filter);
            }
            final ArrayList<LocatedFileStatus> locatedFileStatuses = new ArrayList<LocatedFileStatus>();
            final RemoteIterator iterator = super.listLocatedStatus(p, filter);
            for (JindoPathResolver.JindoShimsPath path : pathList) {
                FileStatus status = path.getTargetFS().getFileStatus(path.getTargetPath());
                status.setPath(new Path(path.getRewriteRule().getFromPath()));
                LocatedFileStatus s = new LocatedFileStatus(status, null);
                if (!filter.accept(status.getPath())) continue;
                locatedFileStatuses.add(s);
            }
            return new RemoteIterator<LocatedFileStatus>(){
                private int i = 0;

                public boolean hasNext() throws IOException {
                    return iterator.hasNext() || this.i < locatedFileStatuses.size();
                }

                public LocatedFileStatus next() throws IOException {
                    if (iterator.hasNext()) {
                        return (LocatedFileStatus)iterator.next();
                    }
                    return (LocatedFileStatus)locatedFileStatuses.get(this.i++);
                }
            };
        }
        Class<?> classType = newPath.getTargetFS().getClass();
        Method method = null;
        try {
            method = classType.getDeclaredMethod("listLocatedStatus", Path.class, PathFilter.class);
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("Not implemented listLocatedStatus(Path p, final PathFilter filter)", e);
        }
        method.setAccessible(true);
        try {
            return new WrappedRemoteIterator<LocatedFileStatus>((RemoteIterator)method.invoke((Object)newPath.getTargetFS(), newPath.getTargetPath(), filter), locatedFileStatus -> {
                Path originPath = newPath.rewriteToSrcPath(locatedFileStatus.getPath(), this.getUri());
                locatedFileStatus.setPath(originPath);
                return locatedFileStatus;
            });
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException("Not implemented listLocatedStatus(Path p, final PathFilter filter)", e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IOException) {
                throw (IOException)e.getTargetException();
            }
            throw new UnsupportedOperationException("Not implemented listLocatedStatus(Path p, final PathFilter filter)", e);
        }
    }

    public RemoteIterator<FileStatus> listStatusIterator(Path p) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(p);
        if (newPath == null) {
            List<JindoPathResolver.JindoShimsPath> pathList = this.pathResolver.getJindoShimsPathList(p);
            if (pathList == null) {
                return super.listStatusIterator(p);
            }
            final ArrayList<FileStatus> fileStatuses = new ArrayList<FileStatus>();
            final RemoteIterator iterator = super.listStatusIterator(p);
            for (JindoPathResolver.JindoShimsPath path : pathList) {
                FileStatus status = path.getTargetFS().getFileStatus(path.getTargetPath());
                status.setPath(new Path(path.getRewriteRule().getFromPath()));
                fileStatuses.add(status);
            }
            return new RemoteIterator<FileStatus>(){
                private int i = 0;

                public boolean hasNext() throws IOException {
                    return iterator.hasNext() || this.i < fileStatuses.size();
                }

                public FileStatus next() throws IOException {
                    if (iterator.hasNext()) {
                        return (FileStatus)iterator.next();
                    }
                    return (FileStatus)fileStatuses.get(this.i++);
                }
            };
        }
        return new WrappedRemoteIterator<FileStatus>(newPath.getTargetFS().listStatusIterator(newPath.getTargetPath()), fileStatus -> {
            Path originPath = newPath.rewriteToSrcPath(fileStatus.getPath(), this.getUri());
            fileStatus.setPath(originPath);
            return fileStatus;
        });
    }

    public boolean mkdir(Path f, FsPermission permission) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(f);
        if (newPath == null) {
            return super.mkdir(f, permission);
        }
        return newPath.getTargetFS().mkdirs(newPath.getTargetPath(), permission);
    }

    public boolean mkdirs(Path path, FsPermission fsPermission) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(path);
        if (newPath == null) {
            return super.mkdirs(path, fsPermission);
        }
        return newPath.getTargetFS().mkdirs(newPath.getTargetPath(), fsPermission);
    }

    protected boolean primitiveMkdir(Path f, FsPermission absolutePermission) throws UnsupportedOperationException, IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(f);
        if (newPath == null) {
            return super.primitiveMkdir(f, absolutePermission);
        }
        return newPath.getTargetFS().mkdirs(newPath.getTargetPath(), absolutePermission);
    }

    public void close() throws IOException {
        IOException ex = null;
        try {
            super.close();
        }
        catch (IOException e) {
            ex = e;
            LOG.error("failed to close", (Throwable)e);
        }
        try {
            this.pathResolver.close();
        }
        catch (IOException e) {
            ex = e;
            LOG.error("failed to close " + e.getMessage(), (Throwable)e);
        }
        if (ex != null) {
            throw ex;
        }
    }

    public FsStatus getStatus(Path p) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(p);
        if (newPath == null) {
            return super.getStatus(p);
        }
        return newPath.getTargetFS().getStatus(newPath.getTargetPath());
    }

    public RemoteIterator<Path> listCorruptFileBlocks(Path path) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(path);
        if (newPath == null) {
            return super.listCorruptFileBlocks(path);
        }
        return newPath.getTargetFS().listCorruptFileBlocks(newPath.getTargetPath());
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(path);
        if (newPath == null) {
            return super.getFileStatus(path);
        }
        FileStatus fileStatus = newPath.getTargetFS().getFileStatus(newPath.getTargetPath());
        fileStatus.setPath(path);
        return fileStatus;
    }

    public void createSymlink(Path target, Path link, boolean createParent) throws IOException {
        JindoPathResolver.JindoShimsPath newTarget = this.pathResolver.getJindoShimsPath(target);
        JindoPathResolver.JindoShimsPath newLink = this.pathResolver.getJindoShimsPath(link);
        if (newTarget == null && newLink == null) {
            super.createSymlink(target, link, createParent);
        }
        if (newTarget == null && newLink != null || newTarget != null && newLink == null) {
            throw new UnsupportedOperationException("can not support createSymlink across filesystem");
        }
        if (!newTarget.getTargetFS().getUri().getAuthority().equals(newLink.getTargetFS().getUri().getAuthority())) {
            throw new UnsupportedOperationException("can not support createSymlink across filesystem");
        }
        newLink.getTargetFS().createSymlink(newTarget.getTargetPath(), newLink.getTargetPath(), createParent);
    }

    public FileStatus getFileLinkStatus(Path f) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(f);
        if (newPath == null) {
            return super.getFileLinkStatus(f);
        }
        FileStatus fileStatus = newPath.getTargetFS().getFileLinkStatus(newPath.getTargetPath());
        fileStatus.setPath(f);
        return fileStatus;
    }

    public Path getLinkTarget(Path f) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(f);
        if (newPath == null) {
            return super.getLinkTarget(f);
        }
        return newPath.getTargetFS().getLinkTarget(newPath.getTargetPath());
    }

    protected Path resolveLink(Path f) throws UnsupportedOperationException, IOException {
        return super.resolveLink(f);
    }

    public FileChecksum getFileChecksum(Path f) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(f);
        if (newPath == null) {
            return super.getFileChecksum(f);
        }
        return newPath.getTargetFS().getFileChecksum(newPath.getTargetPath());
    }

    public FileChecksum getFileChecksum(Path f, long length) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(f);
        if (newPath == null) {
            return super.getFileChecksum(f, length);
        }
        return newPath.getTargetFS().getFileChecksum(newPath.getTargetPath(), length);
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(p);
        if (newPath == null) {
            super.setPermission(p, permission);
        } else {
            newPath.getTargetFS().setPermission(newPath.getTargetPath(), permission);
        }
    }

    public void setOwner(Path p, String username, String groupname) throws UnsupportedOperationException, IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(p);
        if (newPath == null) {
            super.setOwner(p, username, groupname);
        } else {
            newPath.getTargetFS().setOwner(newPath.getTargetPath(), username, groupname);
        }
    }

    public void setTimes(Path p, long mtime, long atime) throws UnsupportedOperationException, IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(p);
        if (newPath == null) {
            super.setTimes(p, mtime, atime);
        } else {
            newPath.getTargetFS().setTimes(newPath.getTargetPath(), mtime, atime);
        }
    }

    protected int getDefaultPort() {
        return super.getDefaultPort();
    }

    protected URI canonicalizeUri(URI uri) {
        return super.canonicalizeUri(uri);
    }

    public Path createSnapshot(Path path, String snapshotName) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(path);
        if (newPath == null) {
            return super.createSnapshot(path, snapshotName);
        }
        return newPath.getTargetFS().createSnapshot(newPath.getTargetPath(), snapshotName);
    }

    public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(path);
        if (newPath == null) {
            super.renameSnapshot(path, snapshotOldName, snapshotNewName);
        } else {
            newPath.getTargetFS().renameSnapshot(newPath.getTargetPath(), snapshotOldName, snapshotNewName);
        }
    }

    public void deleteSnapshot(Path snapshotDir, String snapshotName) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(snapshotDir);
        if (newPath == null) {
            super.deleteSnapshot(snapshotDir, snapshotName);
        } else {
            newPath.getTargetFS().deleteSnapshot(newPath.getTargetPath(), snapshotName);
        }
    }

    public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(path);
        if (newPath == null) {
            super.modifyAclEntries(path, aclSpec);
        } else {
            newPath.getTargetFS().modifyAclEntries(newPath.getTargetPath(), aclSpec);
        }
    }

    public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(path);
        if (newPath == null) {
            super.removeAclEntries(path, aclSpec);
        } else {
            newPath.getTargetFS().removeAclEntries(newPath.getTargetPath(), aclSpec);
        }
    }

    public void removeDefaultAcl(Path path) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(path);
        if (newPath == null) {
            super.removeDefaultAcl(path);
        } else {
            newPath.getTargetFS().removeDefaultAcl(newPath.getTargetPath());
        }
    }

    public void removeAcl(Path path) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(path);
        if (newPath == null) {
            super.removeAcl(path);
        } else {
            newPath.getTargetFS().removeAcl(newPath.getTargetPath());
        }
    }

    public void setAcl(Path path, List<AclEntry> aclSpec) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(path);
        if (newPath == null) {
            super.setAcl(path, aclSpec);
        } else {
            newPath.getTargetFS().setAcl(newPath.getTargetPath(), aclSpec);
        }
    }

    public AclStatus getAclStatus(Path path) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(path);
        if (newPath == null) {
            return super.getAclStatus(path);
        }
        return newPath.getTargetFS().getAclStatus(newPath.getTargetPath());
    }

    public void setXAttr(Path path, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(path);
        if (newPath == null) {
            super.setXAttr(path, name, value, flag);
        } else {
            newPath.getTargetFS().setXAttr(newPath.getTargetPath(), name, value, flag);
        }
    }

    public byte[] getXAttr(Path path, String name) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(path);
        if (newPath == null) {
            return super.getXAttr(path, name);
        }
        return newPath.getTargetFS().getXAttr(newPath.getTargetPath(), name);
    }

    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(path);
        if (newPath == null) {
            return super.getXAttrs(path);
        }
        return newPath.getTargetFS().getXAttrs(newPath.getTargetPath());
    }

    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(path);
        if (newPath == null) {
            return super.getXAttrs(path, names);
        }
        return newPath.getTargetFS().getXAttrs(newPath.getTargetPath(), names);
    }

    public List<String> listXAttrs(Path path) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(path);
        if (newPath == null) {
            return super.listXAttrs(path);
        }
        return newPath.getTargetFS().listXAttrs(newPath.getTargetPath());
    }

    public void removeXAttr(Path path, String name) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(path);
        if (newPath == null) {
            super.removeXAttr(path, name);
        } else {
            newPath.getTargetFS().removeXAttr(newPath.getTargetPath(), name);
        }
    }

    public void access(Path path, FsAction mode) throws IOException {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(path);
        if (newPath == null) {
            super.access(path, mode);
        } else {
            newPath.getTargetFS().access(newPath.getTargetPath(), mode);
        }
    }

    public Path getTrashRoot(Path path) {
        JindoPathResolver.JindoShimsPath newPath = this.pathResolver.getJindoShimsPath(path);
        if (newPath == null) {
            return super.getTrashRoot(path);
        }
        try {
            return newPath.getTargetFS().getTrashRoot(newPath.getTargetPath());
        }
        catch (IOException e) {
            return super.getTrashRoot(path);
        }
    }
}

