/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.internal.hdfs;

import bigboot.protocol.type.BlockInfoList;
import bigboot.protocol.type.CltGetFileChecksumReply;
import bigboot.protocol.type.FileletCreateReply;
import bigboot.protocol.type.FileletOpenReply;
import bigboot.protocol.type.FileletStatus;
import bigboot.protocol.type.FileletStatusList;
import bigboot.protocol.type.FileletSummary;
import bigboot.protocol.type.NssFileletDiffReply;
import com.alibaba.jboot.JbootFuture;
import com.alibaba.jboot.JbootHdfs;
import com.alibaba.jboot.JbootHdfsReader;
import com.alibaba.jboot.JbootHdfsWriter;
import com.alibaba.jboot.JbootUtils;
import com.alibaba.jboot.buffer.JbootBufferFactory;
import com.alibaba.jboot.exception.ShouldIgnoreException;
import com.alibaba.jboot.exception.ShouldReturnFalseException;
import com.alibaba.jboot.future.ByteBufferFuture;
import com.alibaba.jboot.protocols.ClientArchiveRequestWrapper;
import com.alibaba.jboot.protocols.ClientAtomicCacheRequestWrapper;
import com.alibaba.jboot.protocols.ClientCacheRequestWrapper;
import com.alibaba.jboot.protocols.ClientCheckPermissionRequestWrapper;
import com.alibaba.jboot.protocols.ClientDeleteRequestWrapper;
import com.alibaba.jboot.protocols.ClientGetFileChecksumWrapper;
import com.alibaba.jboot.protocols.ClientListRequestWrapper;
import com.alibaba.jboot.protocols.ClientMkdirRequestWrapper;
import com.alibaba.jboot.protocols.ClientRenameRequestWrapper;
import com.alibaba.jboot.protocols.ClientStatusRequestWrapper;
import com.alibaba.jboot.protocols.ClientUnarchiveRequestWrapper;
import com.alibaba.jboot.protocols.ClientUncacheRequestWrapper;
import com.alibaba.jboot.protocols.ClientWriteRequestWrapper;
import com.alibaba.jboot.protocols.FileletCacheCreateRequestWrapper;
import com.alibaba.jboot.protocols.FileletCacheOpenRequestWrapper;
import com.alibaba.jboot.protocols.FileletCheckProgressRequestWrapper;
import com.alibaba.jboot.protocols.FileletDiffRequestWrapper;
import com.alibaba.jboot.protocols.GetCacheBlockLocationsRequestWrapper;
import com.alibaba.jfs.JfsSystemBase;
import com.alibaba.jfs.JindoRequestPath;
import com.alibaba.jfs.OssAtomicRenameContext;
import com.alibaba.jfs.OssFlushContext;
import com.aliyun.emr.fs.common.AbstractJindoShimsFileSystem;
import com.aliyun.emr.fs.internal.hdfs.HadoopLoginUserInfo;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.FileAlreadyExistsException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class HdfsFileletSystem
extends JfsSystemBase {
    public long DEFAULT_FUTRUE_TIMEOUT = 180L;
    private JbootHdfs jbootHdfs = new JbootHdfs();

    public HdfsFileletSystem() {
        super(new HadoopLoginUserInfo());
    }

    public void write(JindoRequestPath path, ByteBuffer buffer) throws IOException {
        if (JbootUtils.isEmpty(path.getPath())) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new ClientWriteRequestWrapper(this.ugi, path).toDirectBuffer();
        JbootFuture f = this.asyncWrite(request, buffer);
        try {
            f.get();
            return;
        }
        catch (ExecutionException ee) {
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException("Write failed: " + path + " . " + buffer.position() + ":" + buffer.limit(), e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public JbootFuture asyncWrite(ByteBuffer request, ByteBuffer buffer) throws IOException {
        JbootFuture jbootFuture;
        JbootFuture future = jbootFuture = this.jbootHdfs.putObject(request, buffer);
        return future;
    }

    public void mkdir(JindoRequestPath path) throws IOException {
        if (JbootUtils.isEmpty(path.getPath())) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new ClientMkdirRequestWrapper(this.ugi, path).toDirectBuffer();
        try {
            JbootFuture f = this.jbootHdfs.mkdir(request);
            f.get();
            return;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof FileAlreadyExistsException) {
                throw (FileAlreadyExistsException)ee.getCause();
            }
            throw new IOException("Mkdir failed on :" + path, ee.getCause());
        }
        catch (Exception e) {
            throw new IOException("Mkdir failed on :" + path, e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public boolean rename(JindoRequestPath srcPath, String dstPath, long copyPartSize, boolean atomicRename, boolean appendName, boolean ignoreHidden, OssAtomicRenameContext ossAtomicRenameContext) throws IOException {
        if (JbootUtils.isEmpty(srcPath.getPath()) || JbootUtils.isEmpty(dstPath)) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new ClientRenameRequestWrapper(this.ugi, srcPath, dstPath, appendName, ignoreHidden, copyPartSize, atomicRename, 50, false, ossAtomicRenameContext).toDirectBuffer();
        try {
            JbootFuture f = this.jbootHdfs.rename(request);
            f.get();
            boolean bl = true;
            return bl;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof FileNotFoundException) {
                boolean bl = false;
                return bl;
            }
            if (ee.getCause() instanceof FileAlreadyExistsException) {
                throw (FileAlreadyExistsException)ee.getCause();
            }
            if (ee.getCause() instanceof ShouldReturnFalseException) {
                boolean bl = false;
                return bl;
            }
            if (ee.getCause() instanceof ShouldIgnoreException) {
                boolean bl = true;
                return bl;
            }
            throw new IOException("rename src:" + srcPath + ", dst:" + dstPath + "," + ee.getMessage(), ee.getCause());
        }
        catch (Exception e) {
            throw new IOException("Rename failed", e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public boolean delete(JindoRequestPath path, boolean recursive, boolean deleteWithVersions) throws IOException {
        if (JbootUtils.isEmpty(path.getPath())) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new ClientDeleteRequestWrapper(this.ugi, path, recursive, false, deleteWithVersions).toDirectBuffer();
        try {
            JbootFuture f = this.jbootHdfs.delete(request);
            f.get();
            boolean bl = true;
            return bl;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof FileNotFoundException) {
                throw (FileNotFoundException)ee.getCause();
            }
            if (ee.getCause() instanceof ShouldReturnFalseException) {
                boolean bl = false;
                return bl;
            }
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException("Delete failed", e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public FileletCreateReply create(JindoRequestPath path, JbootHdfsWriter jbootWriter, String storageOption, OssFlushContext flushContext, int bufferSize) throws IOException {
        if (JbootUtils.isEmpty(path.getPath())) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new FileletCacheCreateRequestWrapper(this.ugi, path, storageOption, flushContext, bufferSize).toDirectBuffer();
        ByteBuffer result = null;
        try {
            ByteBufferFuture f = new ByteBufferFuture(this.jbootHdfs.create(request, jbootWriter));
            result = f.get();
            FileletCreateReply fileletCreateReply = FileletCreateReply.getRootAsFileletCreateReply(result);
            return fileletCreateReply;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof FileNotFoundException) {
                throw (FileNotFoundException)ee.getCause();
            }
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException("Open failed", e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public FileletCreateReply create(JindoRequestPath path, JbootHdfsWriter jbootWriter, String storageOption, String checksumInfo, OssFlushContext flushContext, int bufferSize) throws IOException {
        if (JbootUtils.isEmpty(path.getPath())) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new FileletCacheCreateRequestWrapper(this.ugi, path, storageOption, checksumInfo, flushContext, bufferSize).toDirectBuffer();
        ByteBuffer result = null;
        try {
            ByteBufferFuture f = new ByteBufferFuture(this.jbootHdfs.create(request, jbootWriter));
            result = f.get();
            FileletCreateReply fileletCreateReply = FileletCreateReply.getRootAsFileletCreateReply(result);
            return fileletCreateReply;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof FileNotFoundException) {
                throw (FileNotFoundException)ee.getCause();
            }
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException("Open failed", e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public FileletOpenReply open(JindoRequestPath path, JbootHdfsReader jbootReader, boolean ossOnly, boolean dataVerify, int bufferSize) throws IOException {
        if (JbootUtils.isEmpty(path.getPath())) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new FileletCacheOpenRequestWrapper(this.ugi, path, ossOnly, dataVerify, bufferSize).toDirectBuffer();
        try {
            ByteBufferFuture f = new ByteBufferFuture(this.jbootHdfs.open(request, jbootReader));
            ByteBuffer result = f.get();
            FileletOpenReply fileletOpenReply = FileletOpenReply.getRootAsFileletOpenReply(result);
            return fileletOpenReply;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof FileNotFoundException) {
                throw (FileNotFoundException)ee.getCause();
            }
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException("Open failed", e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public FileletStatus getStatus(JindoRequestPath path, boolean lsExtend) throws IOException {
        if (JbootUtils.isEmpty(path.getPath())) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new ClientStatusRequestWrapper(this.ugi, path, lsExtend).toDirectBuffer();
        try {
            FileletStatus s;
            ByteBufferFuture f = new ByteBufferFuture(this.jbootHdfs.getStatus(request));
            ByteBuffer result = f.get();
            FileletStatus fileletStatus = s = FileletStatus.getRootAsFileletStatus(result);
            return fileletStatus;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof FileNotFoundException) {
                throw (FileNotFoundException)ee.getCause();
            }
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException("Get status failed", e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public FileletStatusList listStatus(JindoRequestPath path, boolean recursive, boolean isSummary) throws IOException {
        if (JbootUtils.isEmpty(path.getPath())) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new ClientListRequestWrapper(this.ugi, path, recursive, isSummary).toDirectBuffer();
        try {
            ByteBufferFuture f = new ByteBufferFuture(this.jbootHdfs.list(request));
            ByteBuffer result = f.get();
            FileletStatusList fileletStatusList = FileletStatusList.getRootAsFileletStatusList(result);
            return fileletStatusList;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof FileNotFoundException) {
                throw (FileNotFoundException)ee.getCause();
            }
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException("Get status failed", e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public BlockInfoList getFileBlockLocations(JindoRequestPath path, String etag, long start, long len, long logicBlockSize) throws IOException {
        ByteBuffer request = new GetCacheBlockLocationsRequestWrapper(this.ugi, path, etag, start, len, logicBlockSize).toDirectBuffer();
        try {
            ByteBufferFuture future = new ByteBufferFuture(this.jbootHdfs.getFileBlockLocations(request));
            ByteBuffer result = future.get(60L, TimeUnit.SECONDS);
            if (result == null) {
                BlockInfoList blockInfoList = null;
                return blockInfoList;
            }
            BlockInfoList blockInfoList = BlockInfoList.getRootAsBlockInfoList(result);
            return blockInfoList;
        }
        catch (ExecutionException ee) {
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public boolean checkPermission(JindoRequestPath path, boolean doCheckOwner, short parentAccess, short access) throws IOException {
        if (JbootUtils.isEmpty(path.getPath())) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new ClientCheckPermissionRequestWrapper(this.ugi, path, doCheckOwner, parentAccess, access).toDirectBuffer();
        try {
            JbootFuture jbootFuture;
            JbootFuture f = jbootFuture = this.jbootHdfs.checkPermission(request);
            f.get(60L, TimeUnit.SECONDS);
            boolean bl = true;
            return bl;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof FileNotFoundException) {
                throw (FileNotFoundException)ee.getCause();
            }
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException("Get status failed", e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public boolean cache(JindoRequestPath path, AbstractJindoShimsFileSystem.CacheOpContext opContext, long timeoutInSeconds) throws IOException {
        ByteBuffer request = new ClientCacheRequestWrapper(this.ugi, path, opContext.shouldPin, opContext.shouldLoadMemory, opContext.sync, opContext.smallfile, opContext.fileBatchSize, opContext.replica).toDirectBuffer();
        boolean rpc_succeed = false;
        try {
            JbootFuture jbootFuture;
            int retryCount = 0;
            JbootFuture future = jbootFuture = this.jbootHdfs.cache(request);
            try {
                JbootFuture.checkFuture(future, timeoutInSeconds);
                rpc_succeed = true;
                JbootUtils.logRetrySuccess("cache", retryCount);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                IOException lastException = e;
                throw lastException;
            }
        }
        finally {
            if (rpc_succeed) {
                JbootBufferFactory.returnBuffer(request);
            }
        }
    }

    public boolean atomicCache(JindoRequestPath path, AbstractJindoShimsFileSystem.CacheOpContext opContext, long timeoutInSeconds) throws IOException {
        ByteBuffer request = new ClientAtomicCacheRequestWrapper(this.ugi, path, opContext.recursive, opContext.shouldPin, opContext.shouldLoadMemory, opContext.smallfile, opContext.replica, opContext.dataCache).toDirectBuffer();
        boolean rpc_succeed = false;
        try {
            JbootFuture jbootFuture;
            int retryCount = 0;
            JbootFuture future = jbootFuture = this.jbootHdfs.atomicCache(request);
            try {
                JbootFuture.checkFuture(future, timeoutInSeconds);
                rpc_succeed = true;
                JbootUtils.logRetrySuccess("atomicCache", retryCount);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                IOException lastException = e;
                throw lastException;
            }
        }
        finally {
            if (rpc_succeed) {
                JbootBufferFactory.returnBuffer(request);
            }
        }
    }

    public boolean uncache(JindoRequestPath path, long timeoutInSeconds) throws IOException {
        ByteBuffer request = new ClientUncacheRequestWrapper(this.ugi, path).toDirectBuffer();
        boolean rpc_succeed = false;
        try {
            JbootFuture jbootFuture;
            int retryCount = 0;
            JbootFuture future = jbootFuture = this.jbootHdfs.uncache(request);
            try {
                JbootFuture.checkFuture(future, timeoutInSeconds);
                rpc_succeed = true;
                JbootUtils.logRetrySuccess("uncache", retryCount);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                IOException lastException = e;
                throw lastException;
            }
        }
        finally {
            if (rpc_succeed) {
                JbootBufferFactory.returnBuffer(request);
            }
        }
    }

    public boolean archive(JindoRequestPath path, Byte policy, long timeoutInSeconds) throws IOException {
        ByteBuffer request = new ClientArchiveRequestWrapper(this.ugi, path, policy).toDirectBuffer();
        boolean rpc_succeed = false;
        try {
            JbootFuture jbootFuture;
            int retryCount = 0;
            JbootFuture future = jbootFuture = this.jbootHdfs.archive(request);
            try {
                JbootFuture.checkFuture(future, timeoutInSeconds);
                rpc_succeed = true;
                JbootUtils.logRetrySuccess("archive", retryCount);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                IOException lastException = e;
                throw lastException;
            }
        }
        finally {
            if (rpc_succeed) {
                JbootBufferFactory.returnBuffer(request);
            }
        }
    }

    public boolean unarchive(JindoRequestPath path, Byte policy, long timeoutInSeconds) throws IOException {
        ByteBuffer request = new ClientUnarchiveRequestWrapper(this.ugi, path, policy).toDirectBuffer();
        boolean rpc_succeed = false;
        try {
            JbootFuture jbootFuture;
            int retryCount = 0;
            JbootFuture future = jbootFuture = this.jbootHdfs.unarchive(request);
            try {
                JbootFuture.checkFuture(future, timeoutInSeconds);
                rpc_succeed = true;
                JbootUtils.logRetrySuccess("unarchive", retryCount);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                IOException lastException = e;
                throw lastException;
            }
        }
        finally {
            if (rpc_succeed) {
                JbootBufferFactory.returnBuffer(request);
            }
        }
    }

    public FileletStatusList checkProgress(JindoRequestPath path, boolean detailed, long timeoutInSeconds) throws IOException {
        if (JbootUtils.isEmpty(path.getPath())) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new FileletCheckProgressRequestWrapper(this.ugi, path, detailed).toDirectBuffer();
        try {
            ByteBufferFuture f = new ByteBufferFuture(this.jbootHdfs.checkProgress(request));
            ByteBuffer result = f.get();
            FileletStatusList fileletStatusList = FileletStatusList.getRootAsFileletStatusList(result);
            return fileletStatusList;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof FileNotFoundException) {
                throw (FileNotFoundException)ee.getCause();
            }
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException("List failed", e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    /*
     * Exception decompiling
     */
    public FileletSummary getContentSummary(JindoRequestPath path, int batchSize) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getFileChecksum(JindoRequestPath path) throws IOException {
        if (JbootUtils.isEmpty(path.getPath())) {
            throw new IllegalArgumentException("Input parameter is not correct");
        }
        ByteBuffer request = new ClientGetFileChecksumWrapper(this.ugi, path).toDirectBuffer();
        try {
            ByteBufferFuture f = new ByteBufferFuture(this.jbootHdfs.getFileChecksum(request));
            ByteBuffer result = f.get();
            CltGetFileChecksumReply reply = CltGetFileChecksumReply.getRootAsCltGetFileChecksumReply(result);
            String string = reply.checksum();
            return string;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof FileNotFoundException) {
                throw (FileNotFoundException)ee.getCause();
            }
            throw new IOException(ee.getCause());
        }
        catch (Exception e) {
            throw new IOException("getFileChecksum failed", e);
        }
        finally {
            JbootBufferFactory.returnBuffer(request);
        }
    }

    public NssFileletDiffReply metaDiff(JindoRequestPath path, boolean recursive) throws IOException {
        return this.metaDiff(path, recursive, this.DEFAULT_FUTRUE_TIMEOUT);
    }

    public NssFileletDiffReply metaDiff(JindoRequestPath path, boolean recursive, long timeoutInSeconds) throws IOException {
        ByteBuffer request = new FileletDiffRequestWrapper(this.ugi, path, recursive).toDirectBuffer();
        boolean rpc_succeed = false;
        try {
            int retryCount = 0;
            ByteBufferFuture future = new ByteBufferFuture(this.jbootHdfs.metaDiff(request));
            try {
                rpc_succeed = true;
                ByteBuffer result = future.get(timeoutInSeconds, TimeUnit.SECONDS);
                JbootUtils.logRetrySuccess("diff", retryCount);
                NssFileletDiffReply nssFileletDiffReply = NssFileletDiffReply.getRootAsNssFileletDiffReply(result);
                return nssFileletDiffReply;
            }
            catch (Exception e) {
                IOException lastException = new IOException(e);
                throw lastException;
            }
        }
        finally {
            if (rpc_succeed) {
                JbootBufferFactory.returnBuffer(request);
            }
        }
    }

    public void metaSync(JindoRequestPath path, boolean recursive, boolean progressable) throws IOException {
        this.metaSync(path, recursive, 36000L, progressable);
    }

    /*
     * Exception decompiling
     */
    public void metaSync(JindoRequestPath path, boolean recursive, long timeoutInSeconds, boolean progressable) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IOException wrapIOException(ExecutionException ee) {
        if (ee.getCause() instanceof IOException) {
            return (IOException)ee.getCause();
        }
        return new IOException(ee.getCause());
    }
}

