/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.internal.hdfs;

import bigboot.protocol.type.BlockInfo;
import bigboot.protocol.type.BlockInfoList;
import bigboot.protocol.type.FileletCreateReply;
import bigboot.protocol.type.FileletOpenReply;
import bigboot.protocol.type.FileletStatus;
import bigboot.protocol.type.FileletStatusList;
import bigboot.protocol.type.FileletSummary;
import bigboot.protocol.type.NssFileletDiffReply;
import bigboot.protocol.type.StoragePolicy;
import bigboot.protocol.type.StringList;
import com.alibaba.jboot.JbootHdfsReader;
import com.alibaba.jboot.JbootHdfsWriter;
import com.alibaba.jboot.JbootNative;
import com.alibaba.jboot.buffer.JbootBufferFactory;
import com.alibaba.jboot.google.flatbuffers.Table;
import com.alibaba.jfs.JindoRequestPath;
import com.alibaba.jfs.OssFlushContext;
import com.aliyun.emr.fs.auth.AliyunCredentialProviderList;
import com.aliyun.emr.fs.common.AbstractJindoShimsFileSystem;
import com.aliyun.emr.fs.common.Utils;
import com.aliyun.emr.fs.internal.AbstractFileSystemStore;
import com.aliyun.emr.fs.internal.hdfs.HdfsDeleteOp;
import com.aliyun.emr.fs.internal.hdfs.HdfsFileStatus;
import com.aliyun.emr.fs.internal.hdfs.HdfsFileletSystem;
import com.aliyun.emr.fs.internal.hdfs.HdfsGetFileChecksumOp;
import com.aliyun.emr.fs.internal.hdfs.HdfsGetFileStatusOp;
import com.aliyun.emr.fs.internal.hdfs.HdfsListStatusOp;
import com.aliyun.emr.fs.internal.hdfs.HdfsOpContext;
import com.aliyun.emr.fs.internal.hdfs.JindoHdfsInputStream;
import com.aliyun.emr.fs.internal.hdfs.JindoHdfsOutputStream;
import com.aliyun.emr.fs.internal.jfs.Crc64FileChecksum;
import com.aliyun.emr.fs.internal.oss.OssUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsStore
extends AbstractFileSystemStore {
    public static final Logger LOG = LoggerFactory.getLogger(HdfsStore.class);
    private int writeBufferSize;
    private int readBufferSize;
    private boolean enableBlockLocation;
    private long logicBlockSize;
    private boolean magicEnabled = false;
    private int contentSummaryBatchCount;
    private boolean dataVerify;
    private boolean allowFileOverwriteFolder;
    private HdfsOpBuilder hdfsOpBuilder;
    private final String version = "3.7.2";
    private Context context;
    private URI finalUri;
    private String[] deleteMarkerDirs;
    private OssFlushContext flushContext;

    public HdfsStore(FileSystem fs, Configuration conf, Context context) throws IOException {
        super(fs, conf, context);
        this.context = context;
        try {
            String logName = JbootNative.instance().getLogName();
            LOG.info("Jboot log name is {}", (Object)logName);
            this.context.logName = logName;
        }
        catch (Throwable e) {
            LOG.info("NativeLibrary of Jindo is not available, you can ignore if you are not using jindo fs and cache.");
        }
        this.finalUri = context.uri;
        this.hdfsOpBuilder = new HdfsOpBuilder();
        int bufferSize = conf.getInt("fs.jfs.cache.write.buffer.size", 0x100000);
        this.writeBufferSize = this.allignBufferSize(bufferSize);
        bufferSize = conf.getInt("fs.jfs.cache.read.buffer.size", 0x100000);
        this.readBufferSize = this.allignBufferSize(bufferSize);
        this.enableBlockLocation = conf.getBoolean("fs.jfs.cache.block.location.enable", false);
        this.logicBlockSize = conf.getLong("fs.jfs.cache.oss-blocksize", 0x8000000L);
        this.allowFileOverwriteFolder = conf.getBoolean("fs.jfs.cache.allow-file-overwrite-folder", true);
        this.contentSummaryBatchCount = conf.getInt("fs.jfs.cache.get-summary.batch-size", 1000);
        this.dataVerify = conf.getBoolean("fs.jfs.cache.data.verify.enable", true);
        if (this.contentSummaryBatchCount > 1000) {
            LOG.info("fs.jfs.cache.get-summary.batch-size=" + this.contentSummaryBatchCount + ", is larger than maxValue: " + 1000);
            this.contentSummaryBatchCount = 1000;
        }
        this.deleteMarkerDirs = conf.getTrimmedStrings("fs.jfs.cache.oss.delete-marker.dirs", new String[]{"_temporary", ".staging", ".hive-staging", "__magic"});
        boolean usePool = conf.getBoolean("fs.jfs.cache.buffer.pool", false);
        JbootBufferFactory.setUsePool(usePool);
        boolean flushEnabled = conf.getBoolean("fs.jfs.cache.oss.flush.enable", false);
        String flushStagingPath = conf.get("fs.jfs.cache.oss.flush.staging.path", "tmp");
        this.flushContext = new OssFlushContext();
        this.flushContext.flushEnabled = flushEnabled;
        this.flushContext.flushStagingPath = flushStagingPath;
        LOG.info("Filesystem support for magic committers {} enabled, write buffer size {}, read buffer size {}", new Object[]{this.magicEnabled ? "is" : "is not", this.writeBufferSize, this.readBufferSize});
    }

    public Path qualifyPath(Path path) {
        if (this.fs.getScheme().equals("jfs")) {
            return path;
        }
        Path finalPath = Utils.qualifyPath(path, this.finalUri, this.context.workingDir);
        return finalPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FSDataOutputStream create(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress, String storageOption) throws IOException {
        Path finalPath = this.qualifyPath(path);
        this.checkFileWritable(finalPath, overwrite);
        Table reply = null;
        try {
            JbootHdfsWriter jbootWriter = new JbootHdfsWriter(this.context.hdfsFileletSystem.getUgi(), finalPath.toString());
            reply = this.context.hdfsFileletSystem.create(new JindoRequestPath(finalPath.toString(), null), jbootWriter, storageOption, this.flushContext, this.writeBufferSize);
            int realBufferSize = ((FileletCreateReply)reply).bufferSize();
            JindoHdfsOutputStream.HdfsWriteContext writeContext = new JindoHdfsOutputStream.HdfsWriteContext();
            this.initContext(writeContext);
            writeContext.path = finalPath;
            writeContext.key = OssUtils.pathToKey(finalPath);
            writeContext.bufferSize = realBufferSize;
            writeContext.jbootWriter = jbootWriter;
            JindoHdfsOutputStream outputStream = new JindoHdfsOutputStream(writeContext);
            FSDataOutputStream fSDataOutputStream = new FSDataOutputStream((OutputStream)outputStream, this.context.statistics);
            return fSDataOutputStream;
        }
        finally {
            if (reply != null) {
                JbootBufferFactory.returnBuffer(reply.getByteBuffer());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FSDataOutputStream create(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress, String storageOption, String checksumInfo) throws IOException {
        Path finalPath = this.qualifyPath(path);
        this.checkFileWritable(finalPath, overwrite);
        Table reply = null;
        try {
            JbootHdfsWriter jbootWriter = new JbootHdfsWriter(this.context.hdfsFileletSystem.getUgi(), finalPath.toString());
            reply = this.context.hdfsFileletSystem.create(new JindoRequestPath(finalPath.toString(), null), jbootWriter, storageOption, checksumInfo, this.flushContext, this.writeBufferSize);
            int realBufferSize = ((FileletCreateReply)reply).bufferSize();
            JindoHdfsOutputStream.HdfsWriteContext writeContext = new JindoHdfsOutputStream.HdfsWriteContext();
            this.initContext(writeContext);
            writeContext.path = finalPath;
            writeContext.key = OssUtils.pathToKey(finalPath);
            writeContext.bufferSize = realBufferSize;
            writeContext.jbootWriter = jbootWriter;
            JindoHdfsOutputStream outputStream = new JindoHdfsOutputStream(writeContext);
            FSDataOutputStream fSDataOutputStream = new FSDataOutputStream((OutputStream)outputStream, this.context.statistics);
            return fSDataOutputStream;
        }
        finally {
            if (reply != null) {
                JbootBufferFactory.returnBuffer(reply.getByteBuffer());
            }
        }
    }

    private void checkFileWritable(Path f, boolean overwrite) throws IOException {
        if (overwrite && this.allowFileOverwriteFolder) {
            return;
        }
        try {
            HdfsFileStatus status = this.getFileStatusInternal(f, false);
            if (status.isDirectory()) {
                throw new FileAlreadyExistsException(f + " is a directory");
            }
            if (!overwrite) {
                throw new FileAlreadyExistsException(f + " already exists");
            }
            this.getFileStatusInternal(f, false);
            throw new FileAlreadyExistsException(f + " already exists");
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
    }

    @Override
    public boolean delete(Path path, boolean recurse, boolean ignoreHidden, boolean deleteVersion) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        return this.deleteInternal(qualifiedPath, recurse, deleteVersion);
    }

    public boolean deleteInternal(Path f, boolean recurse, boolean deleteVersion) throws IOException {
        try {
            boolean deleteWithVersions = deleteVersion || HdfsStore.needDeleteVersions(f, this.deleteMarkerDirs);
            return this.hdfsOpBuilder.createDeleteOperation().delete(f, recurse, deleteWithVersions, null);
        }
        catch (FileNotFoundException e) {
            LOG.debug("Delete called for '" + f + "' but file does not exist, so returning false");
            return false;
        }
    }

    public static boolean needDeleteVersions(Path f, String[] deleteMarkerDirs) {
        if (deleteMarkerDirs == null || deleteMarkerDirs.length == 0) {
            return false;
        }
        try {
            for (String dm : deleteMarkerDirs) {
                String pathStr = f.toString();
                if (!pathStr.contains(dm)) continue;
                List<String> components = HdfsStore.getJindoPathComponents(pathStr);
                for (String comp : components) {
                    if (!comp.startsWith(dm)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            LOG.info("Can't detect '" + f + "' for enable deleteWithVersions or not. " + e.getMessage());
        }
        return false;
    }

    private static List<String> getJindoPathComponents(String path) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        for (String component : path.split("/")) {
            if (component.isEmpty()) continue;
            ret.add(component);
        }
        return ret;
    }

    @Override
    public FileStatus getFileStatus(Path path) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        HdfsFileStatus fileStatus = this.getFileStatusInternal(qualifiedPath, false);
        this.qualifyStatusResult(fileStatus);
        return fileStatus;
    }

    public HdfsFileStatus getOssFileStatus(Path path) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        HdfsFileStatus fileStatus = this.getFileStatusInternal(qualifiedPath, true);
        this.qualifyStatusResult(fileStatus);
        return fileStatus;
    }

    private HdfsFileStatus getFileStatusInternal(Path qualifiedPath, boolean lsExtend) throws IOException {
        if (qualifiedPath.toString().endsWith("/") && qualifiedPath.getParent() != null) {
            qualifiedPath = qualifiedPath.getParent();
        }
        return this.hdfsOpBuilder.createGetFileStatusOperation().getFileStatus(qualifiedPath, lsExtend);
    }

    private void qualifyStatusResult(FileStatus fileStatus) {
        Path finalPath = Utils.qualifyPath(fileStatus.getPath(), this.context.uri, this.context.workingDir);
        fileStatus.setPath(finalPath);
    }

    @Override
    public FileStatus[] listStatus(Path path, boolean recursive, boolean isCmd) throws IOException {
        FileStatus[] result;
        if (recursive) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support recursive listStatus.");
        }
        Path qualifiedPath = this.qualifyPath(path);
        for (FileStatus status : result = this.hdfsOpBuilder.createListStatusOperation().listStatus(qualifiedPath)) {
            this.qualifyStatusResult(status);
        }
        return result;
    }

    private FileStatus[] listStatusWithoutCreateTime(Path path) throws IOException {
        FileStatus[] result;
        Path qualifiedPath = this.qualifyPath(path);
        for (FileStatus status : result = this.hdfsOpBuilder.createListStatusOperation().listStatus(qualifiedPath, false, false, true)) {
            this.qualifyStatusResult(status);
        }
        return result;
    }

    @Override
    public RemoteIterator<LocatedFileStatus> listLocatedStatus(final Path qualifiedPath, final PathFilter filter) throws IOException {
        return new RemoteIterator<LocatedFileStatus>(){
            private final FileStatus[] stats;
            private int i;
            {
                this.stats = HdfsStore.this.listStatus(qualifiedPath, false, false);
                this.i = 0;
            }

            public boolean hasNext() {
                while (this.i < this.stats.length) {
                    if (filter.accept(this.stats[this.i].getPath())) {
                        return true;
                    }
                    ++this.i;
                }
                return false;
            }

            public LocatedFileStatus next() throws IOException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more entry in " + qualifiedPath);
                }
                FileStatus result = this.stats[this.i++];
                BlockLocation[] locs = null;
                if (result.isFile()) {
                    if (HdfsStore.this.enableBlockLocation) {
                        locs = HdfsStore.this.getFileBlockLocations(result, 0L, result.getLen());
                    }
                    if (locs == null) {
                        String[] name = new String[]{"localhost:50010"};
                        String[] host = new String[]{"localhost"};
                        locs = new BlockLocation[]{new BlockLocation(name, host, 0L, result.getLen())};
                    }
                }
                return new LocatedFileStatus(result, locs);
            }
        };
    }

    @Override
    public boolean mkdirs(Path path, FsPermission permission) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        try {
            this.context.hdfsFileletSystem.mkdir(new JindoRequestPath(qualifiedPath.toString(), null));
            return true;
        }
        catch (java.nio.file.FileAlreadyExistsException e) {
            throw new FileAlreadyExistsException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        int realBufferSize;
        Path qualifiedPath = this.qualifyPath(f);
        Table reply = null;
        HdfsFileStatus status = null;
        JbootHdfsReader jbootReader = new JbootHdfsReader(this.context.hdfsFileletSystem.getUgi(), new JindoRequestPath(qualifiedPath.toString(), null));
        try {
            reply = this.context.hdfsFileletSystem.open(new JindoRequestPath(qualifiedPath.toString(), null), jbootReader, false, this.dataVerify, this.readBufferSize);
            FileletStatus fileletStatus = ((FileletOpenReply)reply).statusAsFileletStatus();
            status = new HdfsFileStatus(fileletStatus.inodeAsInodeStatus(), this.conf);
            realBufferSize = ((FileletOpenReply)reply).bufferSize();
        }
        finally {
            if (reply != null) {
                JbootBufferFactory.returnBuffer(reply.getByteBuffer());
            }
        }
        if (status.isDirectory()) {
            throw new FileNotFoundException("'" + f + "' is a directory");
        }
        LOG.debug("Opening ' {} ' for reading, size: {}", (Object)f, (Object)status.getLen());
        JindoHdfsInputStream.HdfsReadContext readContext = new JindoHdfsInputStream.HdfsReadContext();
        this.initContext(readContext.hdfsCtx);
        readContext.stats = this.context.statistics;
        readContext.path = qualifiedPath;
        readContext.hdfsCtx.key = OssUtils.pathToKey(qualifiedPath);
        readContext.fileSize = status.getLen();
        readContext.bufferSize = realBufferSize;
        int bufferNum = (int)(readContext.fileSize / (long)readContext.bufferSize);
        readContext.totalBuffers = readContext.fileSize % (long)readContext.bufferSize == 0L ? (long)bufferNum : (long)(bufferNum + 1);
        readContext.timeoutInSecond = this.conf.getInt("fs.jfs.cache.timeout.second", 10);
        JindoHdfsInputStream fsInputStream = new JindoHdfsInputStream(readContext, jbootReader);
        return new FSDataInputStream((InputStream)((Object)fsInputStream));
    }

    @Override
    public boolean rename(Path srcPath, Path dstPath, boolean appendName, boolean ignoreHidden) throws IOException {
        Path parent;
        Path qualifiedSrcPath = this.qualifyPath(srcPath);
        Path qualifiedDstPath = this.qualifyPath(dstPath);
        String srcKey = OssUtils.pathToKey(qualifiedSrcPath);
        if (srcKey.length() == 0) {
            return false;
        }
        for (parent = qualifiedDstPath.getParent(); parent != null && !qualifiedSrcPath.equals((Object)parent); parent = parent.getParent()) {
        }
        if (parent != null) {
            return false;
        }
        String debugPreamble = "Renaming '" + qualifiedSrcPath + "' to '" + qualifiedDstPath + "' - ";
        boolean result = false;
        try {
            result = this.context.hdfsFileletSystem.rename(new JindoRequestPath(qualifiedSrcPath.toString(), null), qualifiedDstPath.toString(), -1L, false, appendName, ignoreHidden, null);
        }
        catch (java.nio.file.FileAlreadyExistsException e) {
            return false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (!this.enableBlockLocation) {
            return null;
        }
        Path qualifiedPath = this.qualifyPath(file.getPath());
        String path = Utils.pathToJindoPath(qualifiedPath);
        if (file == null) {
            LOG.debug("getFileBlockLocations({}, {}, {}) returned null", new Object[]{path, start, len});
            return null;
        }
        if (!(file instanceof HdfsFileStatus)) {
            LOG.warn("FileStatus is not HdfsFileStatus for path {}, cannot getFileBlockLocations", (Object)path);
            return null;
        }
        HdfsFileStatus hdfsFileStatus = (HdfsFileStatus)file;
        String etag = hdfsFileStatus.getEtag();
        LOG.debug("GetFileBlockLocations start : {}, {}, {}, {}, {}", new Object[]{path, etag, start, len, this.logicBlockSize});
        Table list = null;
        try {
            list = this.context.hdfsFileletSystem.getFileBlockLocations(new JindoRequestPath(path, null), etag, start, len, this.logicBlockSize);
            LOG.debug("GetFileBlockLocations end : {}, {}, {}, {} returned {}", new Object[]{path, start, len, this.logicBlockSize, list == null ? null : Integer.valueOf(((BlockInfoList)list).blocksLength())});
            BlockLocation[] blockLocationArray = this.getBlockLocation((BlockInfoList)list, file.getLen());
            return blockLocationArray;
        }
        finally {
            if (list != null) {
                JbootBufferFactory.returnBuffer(list.getByteBuffer());
            }
        }
    }

    private BlockLocation[] getBlockLocation(BlockInfoList list, long fileSize) {
        if (list != null && list.blocksLength() > 0) {
            BlockLocation[] blockLocations = new BlockLocation[list.blocksLength()];
            for (int i = 0; i < list.blocksLength(); ++i) {
                BlockInfo info = list.blocks(i);
                ArrayList<String> hosts = new ArrayList<String>();
                ArrayList<String> names = new ArrayList<String>();
                StringList blockHosts = StringList.getRootAsStringList(info.locationsAsByteBuffer());
                for (int j = 0; j < blockHosts.stringsLength(); ++j) {
                    String ip;
                    String host;
                    String hostAndPort = blockHosts.strings(j);
                    String[] hostPort = hostAndPort.split(":");
                    String hostName = hostPort[0];
                    String port = hostPort.length > 1 ? hostPort[1] : "6101";
                    try {
                        InetAddress addr = InetAddress.getByName(hostName);
                        addr.getHostAddress();
                        host = addr.getHostName();
                        ip = addr.getHostAddress();
                    }
                    catch (Exception e) {
                        host = hostName;
                        ip = hostName;
                    }
                    String ipAndPort = ip + ":" + port;
                    hosts.add(host);
                    names.add(ipAndPort);
                }
                long blockOffset = info.start();
                long remainingSize = fileSize - blockOffset;
                long blockLength = Math.min(remainingSize, this.logicBlockSize);
                blockLocations[i] = new BlockLocation(names.toArray(new String[blockHosts.stringsLength()]), hosts.toArray(new String[blockHosts.stringsLength()]), blockOffset, blockLength);
            }
            return blockLocations;
        }
        return null;
    }

    @Override
    public byte[] getXAttr(Path path, String name) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support removeXAttr");
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support removeXAttr");
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support removeXAttr");
    }

    @Override
    public void setXAttr(Path path, String name, byte[] value) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support removeXAttr");
    }

    @Override
    public List<String> listXAttrs(Path path) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support removeXAttr");
    }

    @Override
    public void removeXAttr(Path path, String name) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support removeXAttr");
    }

    @Override
    public void checkPermission(Path path, FsAction mode) throws IOException {
        Path qualifiedPath = path.makeQualified(this.context.uri, this.context.workingDir);
        String key = Utils.pathToJindoPath(qualifiedPath);
        boolean result = false;
        try {
            LOG.debug("checkPermission for path {}", (Object)key);
            result = this.context.hdfsFileletSystem.checkPermission(new JindoRequestPath(key, null), false, (short)0, (short)mode.ordinal());
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            LOG.info("checkPermission for path {} result {}", (Object)key, (Object)result);
        }
    }

    @Override
    public void setPermission(Path p, FsPermission permission) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support setPermission");
    }

    @Override
    public void processPermissionDelta(Path path, short permission, short permissionDelta, boolean recursive) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support processPermissionDelta");
    }

    @Override
    public void setOwner(Path path, String username, String groupName, boolean recursive) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support processPermissionDelta");
    }

    @Override
    public void setOwner(Path p, String username, String groupName) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support setOwner");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentSummary getContentSummary(Path path) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        String key = Utils.pathToJindoPath(qualifiedPath);
        Table fileletSummary = null;
        try {
            fileletSummary = this.context.hdfsFileletSystem.getContentSummary(new JindoRequestPath(key, null), this.contentSummaryBatchCount);
            if (fileletSummary != null) {
                ContentSummary contentSummary = new ContentSummary(((FileletSummary)fileletSummary).fileLength(), ((FileletSummary)fileletSummary).fileCount(), ((FileletSummary)fileletSummary).directoryCount(), -1L, ((FileletSummary)fileletSummary).fileLength(), -1L);
                return contentSummary;
            }
            ContentSummary contentSummary = new ContentSummary();
            return contentSummary;
        }
        finally {
            if (fileletSummary != null && fileletSummary.getByteBuffer() != null) {
                JbootBufferFactory.returnBuffer(fileletSummary.getByteBuffer());
            }
        }
    }

    @Override
    public FileChecksum getFileChecksum(Path path) throws IOException {
        String checksum = this.hdfsOpBuilder.createGetFileChecksumOperation().getFileChecksum(path, null);
        return new Crc64FileChecksum(checksum);
    }

    @Override
    public FileChecksum getFileChecksum2(Path path) throws IOException {
        throw new IOException("Not support checksum v2");
    }

    @Override
    public FileChecksum getFileChecksum2(Path path, long blockSize) throws IOException {
        return this.getFileChecksum2(path);
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public Boolean isMagicCommitEnabled() {
        return false;
    }

    private void initContext(HdfsOpContext hdfsOpContext) {
        hdfsOpContext.hdfsFileletSystem = this.context.hdfsFileletSystem;
        hdfsOpContext.conf = this.conf;
        hdfsOpContext.stats = this.context.statistics;
    }

    public HdfsOpBuilder getHdfsOpBuilder() {
        return this.hdfsOpBuilder;
    }

    public HdfsFileletSystem getHdfsFileletSystem() {
        return this.context.hdfsFileletSystem;
    }

    @Override
    public void cache(Path path, AbstractJindoShimsFileSystem.CacheOpContext opContext) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        String filePath = Utils.pathToJindoPath(qualifiedPath);
        try {
            this.context.hdfsFileletSystem.cache(new JindoRequestPath(filePath, null), opContext, 20000L);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to cache " + filePath);
            throw e;
        }
    }

    @Override
    public void atomicCache(Path path, AbstractJindoShimsFileSystem.CacheOpContext opContext) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        String filePath = Utils.pathToJindoPath(qualifiedPath);
        try {
            this.context.hdfsFileletSystem.atomicCache(new JindoRequestPath(filePath, null), opContext, 36000L);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to cache " + filePath);
            throw e;
        }
    }

    @Override
    public void uncache(Path path) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        String filePath = Utils.pathToJindoPath(qualifiedPath);
        try {
            this.context.hdfsFileletSystem.uncache(new JindoRequestPath(filePath, null), 10000L);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to uncache " + filePath);
            throw e;
        }
    }

    @Override
    public void archive(Path path, Byte policy) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        String filePath = Utils.pathToJindoPath(qualifiedPath);
        try {
            this.context.hdfsFileletSystem.archive(new JindoRequestPath(filePath, null), policy, 10000L);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to archive " + filePath + " policy " + StoragePolicy.name(policy.byteValue()));
            throw e;
        }
    }

    @Override
    public void unarchive(Path path, Byte policy) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        String filePath = Utils.pathToJindoPath(qualifiedPath);
        try {
            this.context.hdfsFileletSystem.unarchive(new JindoRequestPath(filePath, null), policy, 10000L);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to unarchive " + filePath + " policy " + StoragePolicy.name(policy.byteValue()));
            throw e;
        }
    }

    @Override
    public FileletStatus[] checkProgress(Path path, boolean detailed) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        String filePath = Utils.pathToJindoPath(qualifiedPath);
        try {
            FileletStatusList list = this.context.hdfsFileletSystem.checkProgress(new JindoRequestPath(filePath, null), detailed, 10000L);
            FileletStatus[] fileStatuses = new FileletStatus[list.filesLength()];
            for (int i = 0; i < list.filesLength(); ++i) {
                fileStatuses[i] = list.files(i);
            }
            JbootBufferFactory.returnBuffer(list.getByteBuffer());
            return fileStatuses;
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to checkProgress " + filePath);
            return null;
        }
    }

    @Override
    public NssFileletDiffReply metaDiff(Path path, boolean recursive) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        String filePath = Utils.pathToJindoPath(qualifiedPath);
        try {
            return this.context.hdfsFileletSystem.metaDiff(new JindoRequestPath(filePath, null), recursive);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to cache " + filePath);
            throw e;
        }
    }

    @Override
    public void metaSync(Path path, boolean recursive, boolean progressable) throws IOException {
        Path qualifiedPath = this.qualifyPath(path);
        String filePath = Utils.pathToJindoPath(qualifiedPath);
        try {
            this.context.hdfsFileletSystem.metaSync(new JindoRequestPath(filePath, null), recursive, progressable);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Failed to cache " + filePath);
            throw e;
        }
    }

    public class HdfsOpBuilder {
        public HdfsDeleteOp createDeleteOperation() {
            HdfsOpContext context = new HdfsOpContext();
            HdfsStore.this.initContext(context);
            return new HdfsDeleteOp(context, HdfsStore.this.fs, null);
        }

        public HdfsListStatusOp createListStatusOperation() {
            HdfsOpContext context = new HdfsOpContext();
            HdfsStore.this.initContext(context);
            return new HdfsListStatusOp(context, HdfsStore.this.fs, null);
        }

        public HdfsGetFileStatusOp createGetFileStatusOperation() {
            HdfsOpContext context = new HdfsOpContext();
            HdfsStore.this.initContext(context);
            return new HdfsGetFileStatusOp(context, HdfsStore.this.fs, null);
        }

        public HdfsGetFileChecksumOp createGetFileChecksumOperation() {
            HdfsOpContext context = new HdfsOpContext();
            HdfsStore.this.initContext(context);
            return new HdfsGetFileChecksumOp(context, HdfsStore.this.fs, null);
        }
    }

    public static class Context
    extends AbstractFileSystemStore.Context {
        public final HdfsFileletSystem hdfsFileletSystem = new HdfsFileletSystem();
        public String prefix;
        public long namespaceConnectId = 0L;
        public AliyunCredentialProviderList credentialProviders;
    }
}

