/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.internal.jfs;

import com.aliyun.emr.fs.internal.jfs.CrcUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.util.DataChecksum;

public class CompositeCrcFileChecksum
extends FileChecksum {
    public static final int LENGTH = 4;
    private int crc;
    private DataChecksum.Type crcType;
    private int bytesPerCrc;

    public CompositeCrcFileChecksum(int crc, int crcType, int bytesPerCrc) throws IOException {
        this.crc = crc;
        this.crcType = CrcUtil.getDataChecksumType(crcType);
        this.bytesPerCrc = bytesPerCrc;
    }

    public CompositeCrcFileChecksum(int crc, DataChecksum.Type crcType, int bytesPerCrc) {
        this.crc = crc;
        this.crcType = crcType;
        this.bytesPerCrc = bytesPerCrc;
    }

    public String getAlgorithmName() {
        return "COMPOSITE-" + this.crcType.name();
    }

    public int getLength() {
        return 4;
    }

    public byte[] getBytes() {
        return CrcUtil.intToBytes(this.crc);
    }

    public Options.ChecksumOpt getChecksumOpt() {
        return new Options.ChecksumOpt(this.crcType, this.bytesPerCrc);
    }

    public void readFields(DataInput in) throws IOException {
        this.crc = in.readInt();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.crc);
    }

    public String toString() {
        return this.getAlgorithmName() + ":" + String.format("0x%08x", this.crc);
    }
}

