/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.internal.jfs;

import com.aliyun.emr.fs.internal.jfs.JfsStore;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositePathInfo {
    public Path realPath;
    public String inodeId;
    public long fileSize;
    public static final String COMPOSITE_NAME_FLAG = "JindoCompositeName";
    static final Logger LOG = LoggerFactory.getLogger(JfsStore.class);

    public static CompositePathInfo decode(Path jfsPath) {
        try {
            String name = jfsPath.getName();
            int len = name.length();
            if (!name.endsWith(COMPOSITE_NAME_FLAG) || len < COMPOSITE_NAME_FLAG.length()) {
                return null;
            }
            int idx = name.lastIndexOf(95);
            if (idx == -1) {
                return null;
            }
            int idx2 = name.lastIndexOf(95, idx - 1);
            if (idx2 == -1) {
                return null;
            }
            String fileSizeStr = name.substring(idx + 1, len - COMPOSITE_NAME_FLAG.length());
            String inodeIdStr = name.substring(idx2 + 1, idx);
            String realName = name.substring(0, idx2);
            LOG.debug("fileSizeStr " + fileSizeStr + ", inodeIdStr " + inodeIdStr + ", realName " + realName);
            long fileSize = Long.valueOf(fileSizeStr);
            CompositePathInfo pathInfo = new CompositePathInfo();
            pathInfo.realPath = new Path(jfsPath.getParent(), realName);
            pathInfo.inodeId = inodeIdStr;
            pathInfo.fileSize = fileSize;
            return pathInfo;
        }
        catch (Throwable e) {
            LOG.warn(e.getMessage());
            return null;
        }
    }

    public static Path extractRealPath(Path path) {
        CompositePathInfo compositePathInfo = CompositePathInfo.decode(path);
        if (compositePathInfo == null) {
            return path;
        }
        return compositePathInfo.realPath;
    }

    public static Path encodeCompositeJfsPath(Path realPath, String inodeId, long fileSize) {
        String newName = realPath.getName() + "_" + inodeId + "_" + fileSize + COMPOSITE_NAME_FLAG;
        return new Path(realPath.getParent(), newName);
    }
}

