/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.internal.jfs;

import com.alibaba.jboot.JbootJfsReader;
import com.alibaba.jboot.buffer.JbootBufferFactory;
import com.aliyun.emr.compatibility.StopWatch;
import com.aliyun.emr.fs.common.FsStats;
import com.aliyun.emr.fs.internal.JindoInputStream;
import com.aliyun.emr.fs.internal.jfs.JfsBlobSystem;
import com.aliyun.emr.fs.internal.jfs.JfsFileletSystem;
import com.aliyun.emr.fs.internal.jfs.JfsStore;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JfsInputStream
extends JindoInputStream {
    static final Logger LOG = LoggerFactory.getLogger(JfsInputStream.class);
    protected final JfsReadContext context;
    protected final JfsBlobSystem jbootBlocklet;
    final long tid = Thread.currentThread().getId();

    public JfsInputStream(JfsReadContext context) {
        super(context);
        this.context = context;
        this.jbootBlocklet = new JfsBlobSystem();
    }

    @Override
    protected int bufferMore() throws IOException {
        if (this.currentBufferId + 1L >= this.context.totalBuffers) {
            return -1;
        }
        ++this.currentBufferId;
        if (this.buffer.capacity() <= 0) {
            this.buffer = JbootBufferFactory.allocateBuffer(this.context.bufferSize);
            this.buffer.limit(0);
        }
        StopWatch sw = new StopWatch().start();
        this.submitRead();
        this.byteReaded += (long)this.buffer.remaining();
        this.readElapsedNanos += sw.stop().now();
        return this.buffer.remaining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readFromPostion(long position, byte[] buffer, int offset, int length) throws IOException {
        if (position < 0L) {
            throw new EOFException("Cannot seek to a negative offset: Pos = " + position);
        }
        StopWatch sw = new StopWatch().start();
        ByteBuffer partBuffer = JbootBufferFactory.allocateBuffer(length);
        try {
            this.context.blockletReader.randomRead(position, length, partBuffer, false);
            partBuffer.get(buffer, offset, length);
            int n = length;
            return n;
        }
        finally {
            FsStats.logStats("randomRead", this.context.path, null, (long)length, null, sw.stop().now(), "3.7.2");
            JbootBufferFactory.returnBuffer(partBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readFromPostion(long position, ByteBuffer byteBuffer, int length) throws IOException {
        if (position < 0L) {
            throw new EOFException("Cannot seek to a negative offset: Pos = " + position);
        }
        StopWatch sw = new StopWatch().start();
        ByteBuffer partBuffer = JbootBufferFactory.allocateBuffer(length);
        try {
            this.context.blockletReader.randomRead(position, length, partBuffer, false);
            byteBuffer.put(partBuffer);
            int n = length;
            return n;
        }
        finally {
            FsStats.logStats("randomRead", this.context.path, null, (long)length, null, sw.stop().now(), "3.7.2");
            JbootBufferFactory.returnBuffer(partBuffer);
        }
    }

    private void submitRead() throws IOException {
        long offset = this.currentBufferId * (long)this.context.bufferSize;
        long totalRemaining = this.context.fileSize - this.currentBufferId * (long)this.context.bufferSize;
        long length = Math.min((long)this.context.bufferSize, totalRemaining);
        boolean readOssOnly = this.context.readOssOnly;
        StopWatch sw = new StopWatch().start();
        this.context.blockletReader.read(offset, length, this.buffer, readOssOnly, false, this.context.timeoutInSecond);
        long timeInNs = sw.stop().now();
        long timeInUs = timeInNs / 1000L;
        if (readOssOnly) {
            JfsStore.totalOssReadTime.getAndAdd(timeInUs);
            JfsStore.ossReadCount.getAndIncrement();
        } else {
            JfsStore.totalCacheReadTime.getAndAdd(timeInUs);
            JfsStore.cacheReadCount.getAndIncrement();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        Exception cleanupError = null;
        Exception closeError = null;
        try {
            this.cleanup();
        }
        catch (Exception ex) {
            cleanupError = ex;
        }
        try {
            super.close();
        }
        catch (Exception ex) {
            closeError = ex;
        }
        this.closed = true;
        if (cleanupError != null) {
            throw new IOException(cleanupError);
        }
        if (closeError != null) {
            throw new IOException(closeError);
        }
    }

    private void cleanup() {
        this.context.blockletReader.close();
        if (this.buffer != null && this.buffer.capacity() > 0) {
            JbootBufferFactory.returnBuffer(this.buffer);
            this.buffer = null;
        }
    }

    protected void finalize() {
        this.cleanup();
    }

    public static class JfsReadContext
    extends JindoInputStream.ReadContext {
        public String iNodeId;
        JbootJfsReader blockletReader;
        public boolean readOssOnly;
        public JfsFileletSystem fileletSystem;
    }
}

