/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.jfs;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class JindoBatchMetaHelper {
    public static final Log LOG = LogFactory.getLog(JindoBatchMetaHelper.class);
    private static JindoBatchMetaHelper instance = null;
    private Class<?> implClass;
    private Method isBatchMetaSupportedMethod;
    private Method composeReadPathMethod;
    private Method composeReadPathListMethod;
    private Method composeCreatePathMethod;
    private Method composeClosePathMethod;
    private Method closeBatchMethod;

    private JindoBatchMetaHelper() {
    }

    public static Boolean isBatchMetaSupported(FileSystem fs, Path path) {
        try {
            if (fs == null) {
                return false;
            }
            Object obj = JindoBatchMetaHelper.getInstance().isBatchMetaSupportedMethod.invoke(null, fs, path);
            return (Boolean)obj;
        }
        catch (Exception e) {
            LOG.info((Object)"JindoBatchMetaHelperImpl isBatchMetaSupported not found");
            return false;
        }
    }

    public static Path composeReadPath(FileSystem fs, FileStatus fileStatus) {
        try {
            if (fs != null && !JindoBatchMetaHelper.isBatchMetaSupported(fs, null).booleanValue()) {
                return fileStatus.getPath();
            }
            Object obj = JindoBatchMetaHelper.getInstance().composeReadPathMethod.invoke(null, null, fileStatus);
            return (Path)obj;
        }
        catch (Exception e) {
            LOG.info((Object)"JindoBatchMetaHelperImpl composeReadPath not found");
            return fileStatus.getPath();
        }
    }

    public static void composeReadPathList(FileSystem fs, FileStatus[] fileStatusList) {
        try {
            if (fs != null && !JindoBatchMetaHelper.isBatchMetaSupported(fs, null).booleanValue()) {
                return;
            }
            JindoBatchMetaHelper.getInstance().composeReadPathListMethod.invoke(null, null, fileStatusList);
        }
        catch (Exception e) {
            LOG.info((Object)"JindoBatchMetaHelperImpl composeReadPathList not found");
        }
    }

    public static Path composeCreatePath(FileSystem fs, Path realPath) {
        try {
            if (fs != null && !JindoBatchMetaHelper.isBatchMetaSupported(fs, null).booleanValue()) {
                return realPath;
            }
            Object obj = JindoBatchMetaHelper.getInstance().composeCreatePathMethod.invoke(null, null, realPath);
            return (Path)obj;
        }
        catch (Exception e) {
            LOG.info((Object)"JindoBatchMetaHelperImpl composeCreatePath not found");
            return realPath;
        }
    }

    public static Path composeClosePath(FileSystem fs, Path realPath) throws IOException {
        try {
            Object obj = JindoBatchMetaHelper.getInstance().composeClosePathMethod.invoke(null, fs, realPath);
            return (Path)obj;
        }
        catch (Exception e) {
            LOG.info((Object)"JindoBatchMetaHelperImpl composeClosePath failed");
            throw new IOException(e);
        }
    }

    public static void closeBatch(FileSystem fs, List<String> paths, boolean abort) throws IOException {
        try {
            JindoBatchMetaHelper.getInstance().closeBatchMethod.invoke(null, fs, paths, abort);
            return;
        }
        catch (Exception e) {
            LOG.info((Object)"JindoBatchMetaHelperImpl closeBatch failed");
            throw new IOException(e);
        }
    }

    private void init() throws Exception {
        ClassLoader cl = JindoBatchMetaHelper.class.getClassLoader();
        this.implClass = cl.loadClass("com.aliyun.emr.fs.jfs.JindoBatchMetaHelperImpl");
        this.isBatchMetaSupportedMethod = this.implClass.getMethod("isBatchMetaSupported", FileSystem.class, Path.class);
        this.composeReadPathMethod = this.implClass.getMethod("composeReadPath", FileSystem.class, FileStatus.class);
        this.composeReadPathListMethod = this.implClass.getMethod("composeReadPathList", FileSystem.class, FileStatus[].class);
        this.composeCreatePathMethod = this.implClass.getMethod("composeCreatePath", FileSystem.class, Path.class);
        this.composeClosePathMethod = this.implClass.getMethod("composeClosePath", FileSystem.class, Path.class);
        this.closeBatchMethod = this.implClass.getMethod("closeBatch", FileSystem.class, List.class, Boolean.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JindoBatchMetaHelper getInstance() throws IOException {
        if (instance != null) {
            return instance;
        }
        Class<JindoBatchMetaHelper> clazz = JindoBatchMetaHelper.class;
        synchronized (JindoBatchMetaHelper.class) {
            if (instance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            JindoBatchMetaHelper theInstance = new JindoBatchMetaHelper();
            try {
                theInstance.init();
            }
            catch (Exception e) {
                LOG.warn((Object)"failed to get method from JindoFileSystem");
                throw new IOException(e);
            }
            instance = theInstance;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

