/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.oss.commit.magic;

import com.aliyun.emr.fs.common.AbstractJindoShimsFileSystem;
import com.aliyun.emr.fs.oss.commit.FileOutputCommitter;
import com.aliyun.emr.fs.oss.commit.magic.CommitOperations;
import com.aliyun.emr.fs.oss.commit.magic.CommitUtils;
import com.aliyun.emr.fs.oss.commit.magic.CommitUtilsWithMR;
import com.aliyun.emr.fs.oss.commit.magic.DurationInfo;
import com.aliyun.emr.fs.oss.commit.magic.MagicCommitPaths;
import com.aliyun.emr.fs.oss.commit.magic.OSSClientUtils;
import com.aliyun.emr.fs.oss.commit.magic.PathCommitException;
import com.aliyun.emr.fs.oss.commit.magic.PendingSet;
import com.aliyun.emr.fs.oss.commit.magic.SinglePendingCommit;
import com.aliyun.emr.fs.oss.commit.magic.SuccessData;
import com.aliyun.emr.fs.oss.commit.magic.Tasks;
import com.aliyun.emr.shade.google_guava.base.Preconditions;
import com.aliyun.emr.shade.google_guava.collect.Lists;
import com.aliyun.emr.shade.google_guava.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.math3.util.Pair;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.net.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public final class JindoOssMagicCommitter
extends FileOutputCommitter {
    private static final Logger LOG = LoggerFactory.getLogger(JindoOssMagicCommitter.class);
    public static final String NAME = "magic";
    private ExecutorService threadPool;
    private CommitOperations commitOperations;
    private Path outputPath;
    private final String role;
    private Path workPath;
    private Configuration conf;
    protected AbstractJindoShimsFileSystem destFS;
    protected boolean tryDeleteVersion;
    private final JobContext jobContext;
    private String magicUUID;
    private boolean magicVerifyChecksum;

    public JindoOssMagicCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        super(outputPath, context);
        Preconditions.checkArgument(outputPath != null, "null output path");
        Preconditions.checkArgument(context != null, "null job context");
        this.jobContext = context;
        this.role = "Task committer " + context.getTaskAttemptID();
        FileSystem fs = outputPath.getFileSystem(context.getConfiguration());
        CommitUtils.verifyIsCacheModeFS(fs, outputPath);
        AbstractJindoShimsFileSystem jofs = (AbstractJindoShimsFileSystem)fs;
        CommitUtils.verifyIsMagicCommitFS(jofs);
        this.destFS = jofs;
        this.setOutputPath(fs.makeQualified(outputPath));
        this.commitOperations = new CommitOperations(jofs);
        this.setConf(context.getConfiguration());
        this.setWorkPath(this.getTaskAttemptPath(context));
        this.tryDeleteVersion = this.conf.getBoolean("fs.oss.committer.magicclean.versions.enabled", true);
        this.magicUUID = this.conf.get("fs.oss.committer.magic.job.uuid", null);
        this.magicVerifyChecksum = this.conf.getBoolean("fs.oss.committer.magicverify.checksum.enabled", false);
        CommitUtils.verifyIsMagicCommitPath(this.destFS, this.getWorkPath(), this.magicUUID);
        LOG.debug("{} instantiated for job \"{}\" ID {} with destination {}, workPath {}", new Object[]{this.role, CommitUtilsWithMR.jobName((JobContext)context), CommitUtilsWithMR.jobIdString((JobContext)context), outputPath, this.getWorkPath().toString()});
    }

    public JindoOssMagicCommitter(Path outputPath, JobContext context) throws IOException {
        super(outputPath, context);
        Preconditions.checkArgument(outputPath != null, "null output path");
        Preconditions.checkArgument(context != null, "null job context");
        this.jobContext = context;
        this.role = "Job committer " + context.getJobID();
        FileSystem fs = outputPath.getFileSystem(context.getConfiguration());
        CommitUtils.verifyIsCacheModeFS(fs, outputPath);
        AbstractJindoShimsFileSystem jofs = (AbstractJindoShimsFileSystem)fs;
        CommitUtils.verifyIsMagicCommitFS(jofs);
        this.destFS = jofs;
        this.setOutputPath(fs.makeQualified(outputPath));
        this.commitOperations = new CommitOperations(jofs);
        this.setConf(context.getConfiguration());
        this.tryDeleteVersion = this.conf.getBoolean("fs.oss.committer.magicclean.versions.enabled", true);
        LOG.info("{} instantiated for job \"{}\" ID {} with destination {}", new Object[]{this.role, CommitUtilsWithMR.jobName(context), CommitUtilsWithMR.jobIdString(context), outputPath});
    }

    @Override
    public void setupJob(JobContext context) throws IOException {
        try (DurationInfo d = new DurationInfo(LOG, "Setup Job %s", CommitUtilsWithMR.jobIdString(context));){
            Path jobAttemptPath = this.getJobAttemptPath(context);
            this.destFS.mkdirs(jobAttemptPath);
        }
    }

    @Override
    public void abortJob(JobContext context, JobStatus.State state) throws IOException {
        LOG.info("{}: aborting job {} in state {}", new Object[]{this.getRole(), CommitUtilsWithMR.jobIdString(context), state});
        this.abortJobInternal(context, false);
    }

    @Override
    public void cleanupJob(JobContext context) throws IOException {
        String r = this.getRole();
        String id = CommitUtilsWithMR.jobIdString(context);
        LOG.warn("{}: using deprecated cleanupJob call for {}", (Object)r, (Object)id);
        try (DurationInfo d = new DurationInfo(LOG, "%s: cleanup Job %s", r, id);){
            this.cleanup(context, true);
        }
    }

    @Override
    public void commitJob(JobContext context) throws IOException {
        String id = CommitUtilsWithMR.jobIdString(context);
        try (DurationInfo d = new DurationInfo(LOG, "%s: commitJob(%s)", this.getRole(), id);){
            List<SinglePendingCommit> pending = this.listPendingUploadsToCommit(context);
            LOG.info("Got {} pending commits.");
            this.preCommitJob(context, pending);
            this.commitJobInternal(context, pending);
            this.jobCompleted(true);
            this.maybeCreateSuccessMarkerFromCommits(context, pending);
            this.cleanup(context, false);
        }
        catch (IOException e) {
            LOG.warn("Commit failure for job {}", (Object)id, (Object)e);
            this.jobCompleted(false);
            this.abortJobInternal(context, true);
            throw e;
        }
    }

    @Override
    public void setupTask(TaskAttemptContext context) throws IOException {
        try (DurationInfo d = new DurationInfo(LOG, "Setup Task %s", context.getTaskAttemptID());){
            Path taskAttemptPath = this.getTaskAttemptPath(context);
            FileSystem fs = taskAttemptPath.getFileSystem(this.getConf());
            fs.mkdirs(taskAttemptPath);
        }
    }

    @Override
    public boolean needsTaskCommit(TaskAttemptContext context) throws IOException {
        Path taskAttemptPath = this.getTaskAttemptPath(context);
        try (DurationInfo d = new DurationInfo(LOG, "needsTaskCommit task %s", context.getTaskAttemptID());){
            boolean bl = taskAttemptPath.getFileSystem(context.getConfiguration()).exists(taskAttemptPath);
            return bl;
        }
    }

    @Override
    public boolean needsTaskCommit(TaskAttemptContext taskAttemptContext, Path taskAttemptPath) throws IOException {
        return this.needsTaskCommit(taskAttemptContext);
    }

    @Override
    public void commitTask(TaskAttemptContext context) throws IOException {
        try (DurationInfo d = new DurationInfo(LOG, "Commit task %s", context.getTaskAttemptID());){
            PendingSet commits = this.innerCommitTask(context);
            LOG.info("Task {} committed {} files", (Object)context.getTaskAttemptID(), (Object)commits.size());
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.deleteTaskAttemptPathQuietly(context);
        }
    }

    @Override
    public void commitTask(TaskAttemptContext context, Path taskAttemptPath) throws IOException {
        this.commitTask(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortTask(TaskAttemptContext context) throws IOException {
        Path attemptPath = this.getTaskAttemptPath(context);
        Path pendingSetPath = this.getPendingSetPath(context);
        try (DurationInfo d = new DurationInfo(LOG, "Abort task %s", context.getTaskAttemptID());){
            this.getCommitOperations().abortAllSinglePendingCommits(attemptPath, true);
        }
        finally {
            OSSClientUtils.deleteQuietly(attemptPath.getFileSystem(context.getConfiguration()), attemptPath, true);
            if (this.destFS.exists(pendingSetPath)) {
                OSSClientUtils.deleteQuietly(pendingSetPath.getFileSystem(context.getConfiguration()), pendingSetPath, true);
            }
        }
    }

    @Override
    public void abortTask(TaskAttemptContext context, Path taskAttemptPath) throws IOException {
        this.abortTask(context);
    }

    @Override
    public void recoverTask(TaskAttemptContext taskContext) throws IOException {
        LOG.warn("Cannot recover task {}", (Object)taskContext.getTaskAttemptID());
        throw new PathCommitException(this.outputPath, String.format("Unable to recover task %s", taskContext.getTaskAttemptID()));
    }

    public String getName() {
        return NAME;
    }

    protected List<SinglePendingCommit> listPendingUploadsToCommit(JobContext context) throws IOException {
        return this.loadPendingsetFiles(context, false, this.destFS, OSSClientUtils.listAndFilter(this.destFS, this.getJobAttemptPath(context), false, CommitOperations.PENDINGSET_FILTER));
    }

    private Path getPendingSetPath(TaskAttemptContext context) {
        return new Path(this.getJobAttemptPath((JobContext)context), context.getTaskAttemptID().toString() + ".pendingset");
    }

    public void cleanupStagingDirs() {
        Path path = MagicCommitPaths.magicSubdir(this.getOutputPath(), this.magicUUID);
        try {
            OSSClientUtils.deleteWithWarning(this.destFS, path, true, this.tryDeleteVersion);
        }
        catch (Exception e) {
            LOG.info("cleanup magic directory:" + path.toString(), (Throwable)e);
        }
    }

    private PendingSet innerCommitTask(TaskAttemptContext context) throws IOException {
        Path taskAttemptPath = this.getTaskAttemptPath(context);
        CommitOperations actions = this.getCommitOperations();
        Pair<PendingSet, List<Pair<LocatedFileStatus, IOException>>> loaded = actions.loadSinglePendingCommits(taskAttemptPath, true);
        PendingSet pendingSet = (PendingSet)loaded.getKey();
        List failures = (List)loaded.getValue();
        if (!failures.isEmpty()) {
            LOG.error("At least one commit file could not be read: failing");
            this.abortPendingUploads((JobContext)context, pendingSet.getCommits(), true);
            throw (IOException)((Pair)failures.get(0)).getValue();
        }
        String jobId = String.valueOf(context.getJobID());
        String taskId = String.valueOf(context.getTaskAttemptID());
        for (SinglePendingCommit commit : pendingSet.getCommits()) {
            commit.setJobId(jobId);
            commit.setTaskId(taskId);
        }
        TaskAttemptID taskAttemptID = context.getTaskAttemptID();
        Path taskOutcomePath = this.getPendingSetPath(context);
        LOG.info("Saving work of {} to {}", (Object)taskAttemptID, (Object)taskOutcomePath);
        try {
            pendingSet.save(this.destFS, taskOutcomePath, false);
        }
        catch (IOException e) {
            LOG.warn("Failed to save task commit data to {} ", (Object)taskOutcomePath, (Object)e);
            this.abortPendingUploads((JobContext)context, pendingSet.getCommits(), true);
            throw e;
        }
        return pendingSet;
    }

    @Override
    protected Path getJobAttemptPath(int appAttemptId) {
        return CommitUtilsWithMR.getMagicJobAttemptPath(appAttemptId, this.getOutputPath(), this.magicUUID);
    }

    @Override
    public Path getTaskAttemptPath(TaskAttemptContext context) {
        return CommitUtilsWithMR.getMagicTaskAttemptPath(context, this.getOutputPath(), this.magicUUID);
    }

    protected Path getBaseTaskAttemptPath(TaskAttemptContext context) {
        return CommitUtilsWithMR.getBaseMagicTaskAttemptPath(context, this.getOutputPath(), this.magicUUID);
    }

    public Path getTempTaskAttemptPath(TaskAttemptContext context) {
        return CommitUtilsWithMR.getTempTaskAttemptPath(context, this.getOutputPath());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MagicCommitter{");
        sb.append('}');
        return sb.toString();
    }

    public final JobContext getJobContext() {
        return this.jobContext;
    }

    @Override
    public final Path getOutputPath() {
        return this.outputPath;
    }

    protected final void setOutputPath(Path outputPath) {
        Preconditions.checkNotNull(outputPath, "Null output path");
        this.outputPath = outputPath;
    }

    @Override
    public Path getWorkPath() {
        return this.workPath;
    }

    protected void setWorkPath(Path workPath) {
        LOG.debug("Setting work path to {}", (Object)workPath);
        this.workPath = workPath;
    }

    public Configuration getConf() {
        return this.conf;
    }

    protected void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Path getJobAttemptPath(JobContext context) {
        return this.getJobAttemptPath(CommitUtilsWithMR.getAppAttemptId(context));
    }

    protected void maybeCreateSuccessMarkerFromCommits(JobContext context, List<SinglePendingCommit> pending) throws IOException {
        if (!context.getConfiguration().getBoolean("mapreduce.fileoutputcommitter.marksuccessfuljobs", true)) {
            return;
        }
        ArrayList<String> filenames = new ArrayList<String>(pending.size());
        for (SinglePendingCommit commit : pending) {
            String key = commit.getDestinationKey();
            if (!key.startsWith("/")) {
                key = "/" + key;
            }
            filenames.add(key);
        }
        this.maybeCreateSuccessMarker(context, filenames);
    }

    protected void maybeCreateSuccessMarker(JobContext context, List<String> filenames) throws IOException {
        SuccessData successData = new SuccessData();
        successData.setCommitter(this.getName());
        successData.setDescription(this.getRole());
        successData.setHostname(NetUtils.getHostname());
        Date now = new Date();
        successData.setTimestamp(now.getTime());
        successData.setDate(now.toString());
        successData.setFilenames(filenames);
        this.commitOperations.createSuccessMarker(this.getOutputPath(), successData, true);
    }

    protected FileSystem getTaskAttemptFilesystem(TaskAttemptContext context) throws IOException {
        return this.getTaskAttemptPath(context).getFileSystem(this.getConf());
    }

    protected void commitPendingUploads(JobContext context, List<SinglePendingCommit> pending) throws IOException {
        if (pending.isEmpty()) {
            LOG.warn("{}: No pending uploads to commit", (Object)this.getRole());
        }
        LOG.debug("{}: committing the output of {} task(s)", (Object)this.getRole(), (Object)pending.size());
        Tasks.foreach(pending).stopOnFailure().executeWith(this.buildThreadPool(context)).onFailure((commit, exception) -> this.getCommitOperations().abortSingleCommit((SinglePendingCommit)commit)).abortWith(commit -> this.getCommitOperations().abortSingleCommit((SinglePendingCommit)commit)).revertWith(commit -> this.getCommitOperations().revertCommit((SinglePendingCommit)commit)).run(commit -> this.getCommitOperations().commitOrFail((SinglePendingCommit)commit, this.magicVerifyChecksum));
    }

    protected List<SinglePendingCommit> loadPendingsetFiles(JobContext context, boolean suppressExceptions, FileSystem fs, Iterable<? extends FileStatus> pendingCommitFiles) throws IOException {
        List<SinglePendingCommit> pending = Collections.synchronizedList(Lists.newArrayList());
        Tasks.foreach(pendingCommitFiles).suppressExceptions(suppressExceptions).executeWith(this.buildThreadPool(context)).run(pendingCommitFile -> pending.addAll(PendingSet.load(fs, pendingCommitFile.getPath()).getCommits()));
        LOG.info("Get {} singe pending from all pendingset", (Object)pending.size());
        return pending;
    }

    protected void commitJobInternal(JobContext context, List<SinglePendingCommit> pending) throws IOException {
        this.commitPendingUploads(context, pending);
    }

    protected void abortJobInternal(JobContext context, boolean suppressExceptions) throws IOException {
        this.cleanup(context, suppressExceptions);
    }

    protected void abortPendingUploadsInCleanup(boolean suppressExceptions) throws IOException {
        Path dest = this.getOutputPath();
        try (DurationInfo d = new DurationInfo(LOG, "Aborting all pending commits under %s", dest);){
            List<Pair<String, String>> pending;
            CommitOperations ops = this.getCommitOperations();
            String schema = dest.toUri().getScheme();
            String bucket = dest.toUri().getHost();
            try {
                pending = ops.listPendingUploadsUnderPath(dest);
            }
            catch (IOException e) {
                this.maybeIgnore(suppressExceptions, "aborting pending uploads", e);
                if (d != null) {
                    if (var4_4 != null) {
                        try {
                            d.close();
                        }
                        catch (Throwable throwable) {
                            var4_4.addSuppressed(throwable);
                        }
                    } else {
                        d.close();
                    }
                }
                return;
            }
            if (pending != null && pending.size() > 0) {
                Tasks.foreach(pending).executeWith(this.buildThreadPool(this.getJobContext())).suppressExceptions(suppressExceptions).run(u -> ops.abortMultipartCommit(schema + "://" + bucket + "/" + (String)u.getKey(), (String)u.getValue()));
            }
        }
    }

    protected void preCommitJob(JobContext context, List<SinglePendingCommit> pending) throws IOException {
    }

    protected void jobCompleted(boolean success) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup(JobContext context, boolean suppressExceptions) throws IOException {
        try (DurationInfo d = new DurationInfo(LOG, "Cleanup job %s", CommitUtilsWithMR.jobIdString(context));){
            this.abortPendingUploadsInCleanup(suppressExceptions);
        }
        finally {
            this.cleanupStagingDirs();
        }
    }

    protected void maybeIgnore(boolean suppress, String action, IOException ex) throws IOException {
        if (!suppress) {
            throw ex;
        }
        LOG.debug(action, (Throwable)ex);
    }

    protected CommitOperations getCommitOperations() {
        return this.commitOperations;
    }

    protected String getRole() {
        return this.role;
    }

    protected final synchronized ExecutorService buildThreadPool(JobContext context) {
        if (this.threadPool == null) {
            int numThreads = context.getConfiguration().getInt("fs.oss.committer.threads", 8);
            LOG.debug("{}: creating thread pool of size {}", (Object)this.getRole(), (Object)numThreads);
            if (numThreads > 0) {
                this.threadPool = Executors.newFixedThreadPool(numThreads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("oss-committer-pool-%d").build());
            } else {
                return null;
            }
        }
        return this.threadPool;
    }

    protected void deleteTaskAttemptPathQuietly(TaskAttemptContext context) {
        Path attemptPath = this.getBaseTaskAttemptPath(context);
        try {
            this.getTaskAttemptFilesystem(context).delete(attemptPath, true);
        }
        catch (Exception e) {
            LOG.info("Delete task attempt path" + attemptPath.toString(), (Throwable)e);
        }
    }

    protected void abortPendingUploads(JobContext context, List<SinglePendingCommit> pending, boolean suppressExceptions) throws IOException {
        if (pending == null || pending.isEmpty()) {
            LOG.info("{}: no pending commits to abort", (Object)this.getRole());
        } else {
            try (DurationInfo d = new DurationInfo(LOG, "Aborting %s uploads", pending.size());){
                Tasks.foreach(pending).executeWith(this.buildThreadPool(context)).suppressExceptions(suppressExceptions).run(commit -> this.getCommitOperations().abortSingleCommit((SinglePendingCommit)commit));
            }
        }
    }
}

