/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.auth;

import com.aliyun.emr.fs.s3.auth.BasicCredentials;
import com.aliyun.emr.fs.s3.auth.BasicSessionCredentials;
import com.aliyun.emr.fs.s3.auth.CredentialInitializationException;
import com.aliyun.emr.fs.s3.auth.S3Credentials;
import com.aliyun.emr.fs.s3.auth.S3CredentialsProvider;
import com.aliyun.emr.shade.google_guava.base.Strings;
import com.aliyun.emr.utils.StringUtils;

public class EnvironmentVariableCredentialsProvider
implements S3CredentialsProvider {
    public static final String NAME = "com.aliyun.emr.fs.s3.auth.EnvironmentVariableCredentialsProvider";
    private final S3CredentialsProvider.CredentialType type;

    public EnvironmentVariableCredentialsProvider(S3CredentialsProvider.CredentialType type) {
        this.type = type;
    }

    @Override
    public S3Credentials getCredentials() {
        String securityToken;
        String accessKeySecret;
        String accessKeyId;
        if (this.type == S3CredentialsProvider.CredentialType.S3 || this.type == S3CredentialsProvider.CredentialType.JFS) {
            accessKeyId = StringUtils.trim(System.getenv("S3_ACCESS_KEY_ID"));
            accessKeySecret = StringUtils.trim(System.getenv("S3_ACCESS_KEY_SECRET"));
            securityToken = StringUtils.trim(System.getenv("S3_SECURITY_TOKEN"));
        } else if (this.type == S3CredentialsProvider.CredentialType.OTS) {
            accessKeyId = StringUtils.trim(System.getenv("OTS_ACCESS_KEY_ID"));
            accessKeySecret = StringUtils.trim(System.getenv("OTS_ACCESS_KEY_SECRET"));
            securityToken = StringUtils.trim(System.getenv("OTS_SECURITY_TOKEN"));
        } else {
            throw new CredentialInitializationException("WARNING: wrong credential type: " + this.type.name());
        }
        if (Strings.isNullOrEmpty(accessKeyId) || Strings.isNullOrEmpty(accessKeySecret)) {
            throw new CredentialInitializationException("Unable to load credentials from environment variables (S3_ACCESS_KEY_ID) and (S3_ACCESS_KEY_SECRET)");
        }
        return Strings.isNullOrEmpty(securityToken) ? new BasicCredentials(accessKeyId, accessKeySecret) : new BasicSessionCredentials(accessKeyId, accessKeySecret, securityToken);
    }

    @Override
    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

