/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.auth;

import com.aliyun.emr.fs.s3.auth.AbstractSessionCredentialsProvider;
import com.aliyun.emr.fs.s3.auth.MarshalledCredentialBinding;
import com.aliyun.emr.fs.s3.auth.MarshalledCredentials;
import com.aliyun.emr.fs.s3.auth.S3Credentials;
import com.aliyun.emr.fs.s3.auth.S3CredentialsProvider;
import com.aliyun.emr.shade.google_guava.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;

public class MarshalledCredentialProvider
extends AbstractSessionCredentialsProvider {
    public static final String NAME = "com.aliyun.emr.fs.s3.auth.MarshalledCredentialProvider";
    private final MarshalledCredentials credentials;
    private final MarshalledCredentials.CredentialTypeRequired typeRequired;
    private final String component;

    public MarshalledCredentialProvider(String component, URI uri, Configuration conf, MarshalledCredentials credentials, MarshalledCredentials.CredentialTypeRequired typeRequired) throws IOException {
        super(Preconditions.checkNotNull(uri, "No filesystem URI"), conf, S3CredentialsProvider.CredentialType.S3);
        this.component = component;
        this.typeRequired = typeRequired;
        this.credentials = Preconditions.checkNotNull(credentials);
    }

    @Override
    protected S3Credentials createCredentials(Configuration config) throws IOException {
        return MarshalledCredentialBinding.toCredentials(this.credentials, this.typeRequired, this.component);
    }
}

