/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.auth.delegation;

import com.aliyun.emr.fs.s3.auth.AuthUtils;
import com.aliyun.emr.fs.s3.auth.MarshalledCredentialBinding;
import com.aliyun.emr.fs.s3.auth.MarshalledCredentialProvider;
import com.aliyun.emr.fs.s3.auth.MarshalledCredentials;
import com.aliyun.emr.fs.s3.auth.S3CredentialProviderList;
import com.aliyun.emr.fs.s3.auth.S3CredentialsProvider;
import com.aliyun.emr.fs.s3.auth.delegation.AbstractDelegationTokenBinding;
import com.aliyun.emr.fs.s3.auth.delegation.AbstractS3TokenIdentifier;
import com.aliyun.emr.fs.s3.auth.delegation.DelegationConstants;
import com.aliyun.emr.fs.s3.auth.delegation.FullCredentialsTokenIdentifier;
import com.aliyun.emr.fs.s3.internal.s3.S3LoginHelper;
import com.aliyun.emr.shade.google_guava.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;

public class FullCredentialsTokenBinding
extends AbstractDelegationTokenBinding {
    private static final String NAME = "FullCredentials/001";
    public static final String FULL_TOKEN = "Full Delegation Token";
    private MarshalledCredentials credentials;
    private String credentialOrigin;

    public FullCredentialsTokenBinding() {
        super(NAME, DelegationConstants.FULL_TOKEN_KIND);
    }

    @Override
    protected void serviceStart() throws Exception {
        super.serviceStart();
    }

    private void loadCredentials() throws IOException {
        this.credentialOrigin = AbstractS3TokenIdentifier.createDefaultOriginMessage();
        Configuration conf = this.getConfig();
        URI uri = this.getCanonicalUri();
        S3LoginHelper.Login secrets = AuthUtils.getAccessKeys(uri, conf, S3CredentialsProvider.CredentialType.S3);
        if (secrets.hasLogin()) {
            this.credentials = new MarshalledCredentials(secrets.getUser(), secrets.getPassword(), "");
            this.credentialOrigin = this.credentialOrigin + "; source = Hadoop configuration data";
        } else {
            this.credentials = MarshalledCredentialBinding.fromEnvironment(System.getenv());
            this.credentialOrigin = this.credentials.isValid(MarshalledCredentials.CredentialTypeRequired.AnyNonEmpty) ? this.credentialOrigin + "; source = Environment variables" : "no credentials in configuration or environment variables";
        }
        this.credentials.validate(this.credentialOrigin + ": ", MarshalledCredentials.CredentialTypeRequired.AnyNonEmpty);
    }

    @Override
    public S3CredentialProviderList deployUnbonded() throws IOException {
        this.requireServiceStarted();
        this.loadCredentials();
        return new S3CredentialProviderList("Full credentials Token Binding", new MarshalledCredentialProvider(FULL_TOKEN, this.getCanonicalUri(), this.getConfig(), this.credentials, MarshalledCredentials.CredentialTypeRequired.AnyNonEmpty));
    }

    @Override
    public AbstractS3TokenIdentifier createTokenIdentifier(Text renewer) throws IOException {
        this.requireServiceStarted();
        Preconditions.checkNotNull(this.credentials, "No credentials to use for a delegation token");
        return new FullCredentialsTokenIdentifier(this.getCanonicalUri(), this.getOwnerText(), renewer, this.credentials, this.credentialOrigin);
    }

    @Override
    public S3CredentialProviderList bindToTokenIdentifier(AbstractS3TokenIdentifier retrievedIdentifier) throws IOException {
        FullCredentialsTokenIdentifier tokenIdentifier = this.convertTokenIdentifier(retrievedIdentifier, FullCredentialsTokenIdentifier.class);
        return new S3CredentialProviderList("Full credentials Token Binding", new MarshalledCredentialProvider(FULL_TOKEN, this.getCanonicalUri(), this.getConfig(), tokenIdentifier.getMarshalledCredentials(), MarshalledCredentials.CredentialTypeRequired.AnyNonEmpty));
    }

    @Override
    public AbstractS3TokenIdentifier createEmptyIdentifier() {
        return new FullCredentialsTokenIdentifier();
    }
}

