/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.commit.magic;

import com.aliyun.emr.shade.google_guava.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MagicCommitPaths {
    private static final Logger LOG = LoggerFactory.getLogger(MagicCommitPaths.class);

    private MagicCommitPaths() {
    }

    public static Path pathOfFinalDestination(Path originPath, String authority, String UUID2) {
        List<String> elements = MagicCommitPaths.splitPathToElements(originPath);
        if (MagicCommitPaths.isMagicCommitPath(elements, UUID2)) {
            String key = MagicCommitPaths.elementsToKey(MagicCommitPaths.finalDestination(elements, UUID2));
            String finalPathStr = originPath.toUri().getScheme() + "://" + authority + "/" + key;
            LOG.info("OriginPath:{} authority:{} finalPath: {}", new Object[]{originPath, authority, finalPathStr});
            return new Path(finalPathStr);
        }
        return originPath;
    }

    public static boolean isMagicCommitPath(Path path, String UUID2) {
        return MagicCommitPaths.isMagicCommitPath(MagicCommitPaths.splitPathToElements(path), UUID2);
    }

    private static boolean isMagicCommitPath(List<String> elements, String UUID2) {
        return MagicCommitPaths.isMagicFile(elements, UUID2);
    }

    private static boolean isMagicFile(List<String> elements, String UUID2) {
        return MagicCommitPaths.isMagicPath(elements, UUID2) && !MagicCommitPaths.isCommitMetadataFile(elements);
    }

    private static boolean isCommitMetadataFile(List<String> elements) {
        String last = elements.get(elements.size() - 1);
        return last.endsWith(".pending") || last.endsWith(".pendingset");
    }

    private static List<String> splitPathToElements(Path path) {
        Preconditions.checkArgument(path.isAbsolute(), "path is relative");
        String uriPath = path.toUri().getPath();
        Preconditions.checkArgument(!uriPath.isEmpty(), "empty path");
        if ("/".equals(uriPath)) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> elements = new ArrayList<String>();
        int len = uriPath.length();
        int firstElementChar = 1;
        int endOfElement = uriPath.indexOf(47, firstElementChar);
        while (endOfElement > 0) {
            elements.add(uriPath.substring(firstElementChar, endOfElement));
            firstElementChar = endOfElement + 1;
            endOfElement = firstElementChar == len ? -1 : uriPath.indexOf(47, firstElementChar);
        }
        if (firstElementChar != len) {
            elements.add(uriPath.substring(firstElementChar));
        }
        return elements;
    }

    public static boolean isMagicPath(List<String> elements, String UUID2) {
        if (UUID2 == null) {
            return elements.contains("__magic");
        }
        return elements.contains("__magic_" + UUID2);
    }

    private static boolean containsBasePath(List<String> elements) {
        return elements.contains("__base");
    }

    private static int magicElementIndex(List<String> elements, String UUID2) {
        int index;
        String element = "__magic";
        if (UUID2 != null) {
            element = element + "_" + UUID2;
        }
        Preconditions.checkArgument((index = elements.indexOf(element)) >= 0, "No __magic element in path");
        return index;
    }

    private static List<String> magicPathParents(List<String> elements, String UUID2) {
        return elements.subList(0, MagicCommitPaths.magicElementIndex(elements, UUID2));
    }

    private static List<String> magicPathChildren(List<String> elements, String UUID2) {
        int len;
        int index = MagicCommitPaths.magicElementIndex(elements, UUID2);
        if (index == (len = elements.size()) - 1) {
            return Collections.emptyList();
        }
        return elements.subList(index + 1, len);
    }

    private static List<String> basePathChildren(List<String> elements) {
        int index = elements.indexOf("__base");
        if (index < 0) {
            return Collections.emptyList();
        }
        int len = elements.size();
        if (index == len - 1) {
            return Collections.emptyList();
        }
        return elements.subList(index + 1, len);
    }

    private static String elementsToKey(List<String> elements) {
        return StringUtils.join((CharSequence)"/", elements);
    }

    private static String filename(List<String> elements) {
        return MagicCommitPaths.lastElement(elements);
    }

    private static String lastElement(List<String> strings) {
        Preconditions.checkArgument(!strings.isEmpty(), "empty list");
        return strings.get(strings.size() - 1);
    }

    public static Path magicSubdir(Path destDir, String UUID2) {
        if (UUID2 == null) {
            return new Path(destDir, "__magic");
        }
        return new Path(destDir, "__magic_" + UUID2);
    }

    private static List<String> finalDestination(List<String> elements, String UUID2) {
        if (MagicCommitPaths.isMagicPath(elements, UUID2)) {
            List<String> destDir = MagicCommitPaths.magicPathParents(elements, UUID2);
            List<String> children = MagicCommitPaths.magicPathChildren(elements, UUID2);
            Preconditions.checkArgument(!children.isEmpty(), "No path found under __magic");
            ArrayList<String> dest = new ArrayList<String>(destDir);
            if (MagicCommitPaths.containsBasePath(children)) {
                List<String> baseChildren = MagicCommitPaths.basePathChildren(children);
                Preconditions.checkArgument(!baseChildren.isEmpty(), "No path found under __base");
                dest.addAll(baseChildren);
            } else {
                dest.add(MagicCommitPaths.filename(children));
            }
            return dest;
        }
        return elements;
    }
}

