/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.internal;

import bigboot.protocol.type.CipherSuite;
import bigboot.protocol.type.CryptoPolicy;
import bigboot.protocol.type.NssGetCryptoPolicyReply;
import com.aliyun.emr.shade.apache_commons_codec.binary.Hex;
import java.nio.ByteBuffer;

public class JindoCryptoPolicy {
    private boolean encryped;
    private byte cipherSuite;
    private String keyIdName;
    private String keyIdVersion;
    private byte[] edek;
    private byte[] iv;

    public JindoCryptoPolicy(NssGetCryptoPolicyReply reply) {
        this.encryped = reply.encrypted();
        if (!this.encryped) {
            return;
        }
        CryptoPolicy policy = reply.policyAsCryptoPolicy();
        this.cipherSuite = policy.cipherSuite();
        this.keyIdName = policy.keyIdName();
        this.keyIdVersion = policy.keyIdVersion();
        ByteBuffer edekBuffer = policy.edekAsByteBuffer();
        if (edekBuffer == null) {
            this.edek = new byte[0];
        } else {
            this.edek = new byte[edekBuffer.remaining()];
            edekBuffer.get(this.edek);
        }
        ByteBuffer ivBuffer = policy.ivAsByteBuffer();
        if (ivBuffer == null) {
            this.iv = new byte[0];
        } else {
            this.iv = new byte[ivBuffer.remaining()];
            ivBuffer.get(this.iv);
        }
    }

    public boolean isEncryped() {
        return this.encryped;
    }

    public String getKeyIdName() {
        return this.keyIdName;
    }

    public String getCipherSuite() {
        return CipherSuite.name(this.cipherSuite);
    }

    public String getKeyIdVersion() {
        return this.keyIdVersion;
    }

    public byte[] getEdek() {
        return this.edek;
    }

    public byte[] getIv() {
        return this.iv;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (!this.encryped) {
            builder.append("{NONE}");
        } else {
            builder.append("{cipherSuite: ").append(this.getCipherSuite()).append(", keyIdName: ").append(this.keyIdName).append(", keyIdVersion: ").append(this.keyIdVersion).append(", edek: ").append(Hex.encodeHexString(this.edek)).append(", iv: ").append(Hex.encodeHexString(this.iv)).append("}");
        }
        return builder.toString();
    }
}

