/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.s3.internal.s3native;

import com.alibaba.jfs.CredentialContext;
import com.aliyun.emr.fs.s3.Constants;
import com.aliyun.emr.fs.s3.auth.AuthUtils;
import com.aliyun.emr.fs.s3.auth.JindoCredentialsProvider;
import com.aliyun.emr.fs.s3.auth.S3CredentialProviderList;
import com.aliyun.emr.fs.s3.auth.S3Credentials;
import com.aliyun.emr.fs.s3.auth.S3CredentialsProvider;
import com.aliyun.emr.fs.s3.auth.S3SessionCredentials;
import com.aliyun.emr.shade.google_guava.base.Strings;
import com.aliyun.emr.utils.StringUtils;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3CredentialUtils {
    public static final Logger LOG = LoggerFactory.getLogger(S3CredentialUtils.class);
    public static volatile CredentialContext cachedCredentialContext;
    public static volatile boolean needInitCredential;

    public static URI createFinallyURI(URI uri, Configuration conf, String schema, CredentialContext s3Context) {
        if (schema.equals("jfs")) {
            return uri;
        }
        String bucket = null;
        String host = uri.getHost();
        if (!StringUtils.isEmpty(host) && !host.contains(".")) {
            bucket = host;
        } else if (!StringUtils.isEmpty(host)) {
            bucket = host.substring(0, host.indexOf("."));
        }
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(bucket);
        String actualEndpoint = S3CredentialUtils.getEndpoint(conf, uri);
        if (actualEndpoint != null) {
            strBuilder.append(".").append(actualEndpoint);
        }
        String authority = strBuilder.toString();
        return URI.create(uri.getScheme() + "://" + authority);
    }

    public static CredentialContext createCredentialContext(String path, Configuration configuration, S3CredentialsProvider.CredentialType type) throws IOException {
        URI uri = URI.create(path);
        uri = uri.getAuthority() != null ? URI.create(uri.getScheme() + "://" + uri.getAuthority()) : URI.create(uri.getScheme() + ":///");
        return S3CredentialUtils.createS3CredentialContext(configuration, uri, AuthUtils.createCredentialProviderSet(uri, configuration, type));
    }

    public static CredentialContext createS3CredentialContext(Configuration conf, URI uri, S3CredentialProviderList providers) throws IOException {
        String userInfo;
        String actualAccessKeyId = null;
        String actualAccessKeySecret = null;
        String actualSecurityToken = null;
        if ((uri.getScheme().equals("s3") || uri.getScheme().equals("s3a") || uri.getScheme().equals("s3n") || uri.getScheme().equals("cos") || uri.getScheme().equals("obs")) && (userInfo = uri.getUserInfo()) != null) {
            String[] credentials = userInfo.split(":");
            if (credentials.length >= 2) {
                actualAccessKeyId = credentials[0];
                actualAccessKeySecret = credentials[1];
            }
            if (credentials.length == 3) {
                actualSecurityToken = credentials[2];
            }
        }
        String accessKeyId = null;
        String accessKeySecret = null;
        String securityToken = null;
        S3Credentials credentials = providers.getCredentials();
        if (credentials != null) {
            accessKeyId = credentials.getAccessKeyId();
            accessKeySecret = credentials.getAccessKeySecret();
            boolean hasSessionCreds = credentials instanceof S3SessionCredentials;
            if (hasSessionCreds) {
                S3SessionCredentials sessionCredentials = (S3SessionCredentials)credentials;
                securityToken = sessionCredentials.getSecurityToken();
            }
        }
        if (actualAccessKeyId == null) {
            actualAccessKeyId = accessKeyId;
        }
        if (actualAccessKeySecret == null) {
            actualAccessKeySecret = accessKeySecret;
        }
        if (actualSecurityToken == null) {
            actualSecurityToken = securityToken;
        }
        CredentialContext s3Context = new CredentialContext();
        s3Context.accessKeyId = actualAccessKeyId;
        s3Context.accessKeySecret = actualAccessKeySecret;
        s3Context.securityToken = actualSecurityToken;
        if (Strings.isNullOrEmpty(actualAccessKeyId) || Strings.isNullOrEmpty(actualAccessKeySecret)) {
            JindoCredentialsProvider provider = providers.getJindoCredentialsProvider();
            byte format = 0;
            if (provider != null) {
                s3Context.providerEndpoint = S3CredentialUtils.getProviderEndpoint(provider);
                format = S3CredentialUtils.getTokenFormat(provider.getTokenFormat());
            }
            s3Context.format = format;
        }
        s3Context.endpoint = S3CredentialUtils.getEndpoint(conf, uri);
        return s3Context;
    }

    private static String getEndpoint(Configuration conf, URI uri) {
        String actualEndpoint = null;
        if (uri.getScheme().equals("s3") || uri.getScheme().equals("s3a") || uri.getScheme().equals("s3n") || uri.getScheme().equals("cos") || uri.getScheme().equals("obs")) {
            String host = uri.getHost();
            if (!StringUtils.isEmpty(host) && host.contains(".")) {
                actualEndpoint = host.substring(host.indexOf(".") + 1);
            }
            String endpoint = S3CredentialUtils.getS3Config(conf, "fs.jfs.cache.s3.endpoint", Constants.DEPRECATED_S3_ENDPOINT);
            if (actualEndpoint == null) {
                actualEndpoint = endpoint;
            }
        } else if (uri.getScheme().equals("jfs")) {
            actualEndpoint = S3CredentialUtils.getS3Config(conf, "fs.jfs.endpoint", new String[0]);
        }
        if (actualEndpoint == null) {
            actualEndpoint = S3CredentialUtils.getS3Config(conf, "jindo.common.s3.endpoint", new String[0]);
        }
        return actualEndpoint;
    }

    private static String getProviderEndpoint(JindoCredentialsProvider provider) throws IOException {
        String url;
        try {
            url = provider.getStsProviderUrl();
        }
        catch (IOException e) {
            throw new IOException("ERROR: fail to get endpoint from provider. " + e.getMessage());
        }
        if (Strings.isNullOrEmpty(url)) {
            throw new IOException("ERROR: the endpoint of provider: " + provider.getClass() + " is null.");
        }
        return url;
    }

    private static String getS3Config(Configuration conf, String key, String ... deprecatedKeys) {
        String value = conf.getTrimmed(key);
        if (value == null & deprecatedKeys != null) {
            for (int i = 0; i < deprecatedKeys.length; ++i) {
                value = conf.getTrimmed(deprecatedKeys[i]);
                if (value == null) continue;
                LOG.warn("{} is deprecated, please use: {}", (Object)deprecatedKeys[i], (Object)key);
                return value;
            }
        }
        return value;
    }

    private static byte getTokenFormat(JindoCredentialsProvider.CredentialsTokenFormat format) {
        byte result;
        switch (format) {
            case PLAIN: {
                result = 0;
                break;
            }
            case JSON: {
                result = 1;
                break;
            }
            default: {
                LOG.warn("unknown format: " + (Object)((Object)format) + " . use the default format " + 1);
                result = 1;
            }
        }
        return result;
    }

    static {
        needInitCredential = true;
    }
}

