/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.aliyun.emr.fs.jfs.JindoFileSystem;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.TrashPolicyDefault;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Time;

public class JfsTrashPolicy
extends TrashPolicyDefault {
    JindoFileSystem jfs = null;
    private static final Path CURRENT = new Path("Current");
    private static final FsPermission PERMISSION = new FsPermission(FsAction.ALL, FsAction.NONE, FsAction.NONE);
    private static final Log LOG = LogFactory.getLog(JfsTrashPolicy.class);

    public JfsTrashPolicy() {
    }

    private JfsTrashPolicy(FileSystem fs, Configuration conf) throws IOException {
        this.initialize(conf, fs);
    }

    public void initialize(Configuration conf, FileSystem fs) {
        this.jfs = (JindoFileSystem)fs;
        super.initialize(conf, fs);
    }

    public boolean moveToTrash(Path path) throws IOException {
        LOG.debug((Object)("moveToTrash path : " + path));
        if (!this.isEnabled()) {
            return false;
        }
        if (!path.isAbsolute()) {
            path = new Path(this.jfs.getWorkingDirectory(), path);
        }
        String qpath = this.jfs.makeQualified(path).toString();
        Path trashRoot = this.jfs.getTrashRoot(path);
        Path trashCurrent = new Path(trashRoot, CURRENT);
        if (qpath.startsWith(trashRoot.toString())) {
            return false;
        }
        if (trashRoot.getParent().toString().startsWith(qpath)) {
            throw new IOException("Cannot move \"" + path + "\" to the trash, as it contains the trash");
        }
        Path trashPath = this.makeTrashRelativePath(trashCurrent, path);
        boolean needCreateTrashDir = false;
        while (trashPath.toString().contains("*")) {
            needCreateTrashDir = true;
            trashPath = trashPath.getParent();
        }
        Path baseTrashPath = this.makeTrashRelativePath(trashCurrent, path.getParent());
        IOException cause = null;
        for (int i = 0; i < 2; ++i) {
            try {
                if (!this.jfs.mkdirs(baseTrashPath, PERMISSION)) {
                    LOG.warn((Object)("Can't create(mkdir) trash directory: " + baseTrashPath));
                    return false;
                }
            }
            catch (IOException e) {
                LOG.warn((Object)("Can't create trash directory: " + baseTrashPath), (Throwable)e);
                cause = e;
                break;
            }
            try {
                boolean ret;
                String orig = trashPath.toString();
                for (int retryCount = 0; this.fs.exists(trashPath) && retryCount < 10; ++retryCount) {
                    trashPath = new Path(orig + Time.now());
                    if (!needCreateTrashDir) continue;
                    try {
                        this.fs.mkdirs(trashPath);
                        break;
                    }
                    catch (FileAlreadyExistsException fileAlreadyExistsException) {
                        continue;
                    }
                }
                LOG.info((Object)((ret = this.jfs.renameFiles(path, trashPath, false)) ? "Moved: '" : "Failed to move: " + path + "' to trash at: " + trashPath));
                return ret;
            }
            catch (IOException e) {
                cause = e;
                continue;
            }
        }
        throw (IOException)new IOException("Failed to move to trash: " + path).initCause(cause);
    }

    private Path makeTrashRelativePath(Path basePath, Path rmFilePath) {
        return Path.mergePaths((Path)basePath, (Path)rmFilePath);
    }
}

