/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import com.aliyun.emr.fs.jfs.JindoFileSystem;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.util.StringUtils;

public abstract class JindoFsCommandShims
extends FsCommand {
    private static final Log LOG = LogFactory.getLog(JindoFsCommandShims.class);
    private int depth = 0;

    public static boolean isJfsBlockMode(FileSystem fs) {
        JindoFileSystem jfs;
        return fs != null && fs instanceof JindoFileSystem && (jfs = (JindoFileSystem)fs).isCacheMode() == false;
    }

    protected JindoFsCommandShims() {
    }

    protected JindoFsCommandShims(Configuration conf) {
        super(conf);
    }

    public String getCommandName() {
        return this.getName();
    }

    protected void run(Path path) throws IOException {
        throw new RuntimeException("not supposed to get here");
    }

    @Deprecated
    public int runAll() {
        return this.run(this.args);
    }

    protected void processRawArguments(LinkedList<String> args) throws IOException {
        LinkedList<PathData> expendedArgs = this.expandArguments(args);
        boolean displayWarnings = this.getConf().getBoolean("hadoop.shell.missing.defaultFs.warning", false);
        if (displayWarnings) {
            boolean missingDefaultFs;
            String defaultFs = this.getConf().get("fs.defaultFS");
            boolean bl = missingDefaultFs = defaultFs == null || defaultFs.equals("file:///");
            if (missingDefaultFs) {
                this.err.printf("Warning: fs.defaultFS is not set when running \"%s\" command.%n", this.getCommandName());
            }
        }
        this.processArguments(expendedArgs);
    }

    protected int getDepth() {
        return this.depth;
    }

    public int run(String ... argv) {
        LinkedList<String> args = new LinkedList<String>(Arrays.asList(argv));
        try {
            if (this.isDeprecated()) {
                this.displayWarning("DEPRECATED: Please use '" + this.getReplacementCommand() + "' instead.");
            }
            this.processOptions(args);
            this.processRawArguments(args);
        }
        catch (IOException e) {
            this.displayError(e);
        }
        return this.numErrors == 0 ? this.exitCode : this.exitCodeForError();
    }

    protected int exitCodeForError() {
        return 1;
    }

    protected void processOptions(LinkedList<String> args) throws IOException {
    }

    protected LinkedList<PathData> expandArguments(LinkedList<String> args) throws IOException {
        LinkedList<PathData> expandedArgs = new LinkedList<PathData>();
        for (String arg : args) {
            try {
                expandedArgs.addAll(this.expandArgument(arg));
            }
            catch (IOException e) {
                this.displayError(e);
            }
        }
        return expandedArgs;
    }

    protected List<PathData> expandArgument(String arg) throws IOException {
        PathData[] items = PathData.expandAsGlob((String)arg, (Configuration)this.getConf());
        if (items.length == 0) {
            throw new PathNotFoundException(arg);
        }
        return Arrays.asList(items);
    }

    protected void processArguments(LinkedList<PathData> args) throws IOException {
        for (PathData arg : args) {
            try {
                this.processArgument(arg);
            }
            catch (IOException e) {
                this.displayError(e);
            }
        }
    }

    protected void processArgument(PathData item) throws IOException {
        if (item.exists) {
            this.processPathArgument(item);
        } else {
            this.processNonexistentPath(item);
        }
    }

    protected void processPathArgument(PathData item) throws IOException {
        this.depth = 0;
        this.processPaths(null, item);
    }

    protected void processNonexistentPath(PathData item) throws IOException {
        throw new PathNotFoundException(item.toString());
    }

    protected void processPaths(PathData parent, PathData ... items) throws IOException {
        for (PathData item : items) {
            try {
                this.processPath(item);
                if (this.recursive && this.isPathRecursable(item)) {
                    this.recursePath(item);
                }
                this.postProcessPath(item);
            }
            catch (IOException e) {
                this.displayError(e);
            }
        }
    }

    protected boolean isPathRecursable(PathData item) throws IOException {
        return item.stat.isDirectory();
    }

    protected void processPath(PathData item) throws IOException {
        throw new RuntimeException("processPath() is not implemented");
    }

    protected void postProcessPath(PathData item) throws IOException {
    }

    protected void recursePath(PathData item) throws IOException {
        try {
            ++this.depth;
            this.processPaths(item, item.getDirectoryContents());
        }
        finally {
            --this.depth;
        }
    }

    public void displayError(Exception e) {
        this.exceptions.add(e);
        String errorMessage = e.getLocalizedMessage();
        if (errorMessage == null) {
            errorMessage = StringUtils.stringifyException((Throwable)e);
            LOG.debug((Object)errorMessage);
        } else {
            errorMessage = errorMessage.split("\n", 2)[0];
        }
        this.displayError(errorMessage);
    }

    public void displayError(String message) {
        ++this.numErrors;
        this.displayWarning(message);
    }

    public void displayWarning(String message) {
        this.err.println(this.getName() + ": " + message);
    }

    public String getName() {
        return this.name == null ? this.getCommandField("NAME") : (this.name.startsWith("-") ? this.name.substring(1) : this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUsage() {
        String cmd = "-" + this.getName();
        String usage = this.isDeprecated() ? "" : this.getCommandField("USAGE");
        return usage.isEmpty() ? cmd : cmd + " " + usage;
    }

    public String getDescription() {
        return this.isDeprecated() ? "(DEPRECATED) Same as '" + this.getReplacementCommand() + "'" : this.getCommandField("DESCRIPTION");
    }

    public String getReplacementCommand() {
        return null;
    }

    private String getCommandField(String field) {
        String value;
        try {
            Field f = ((Object)((Object)this)).getClass().getDeclaredField(field);
            f.setAccessible(true);
            value = f.get((Object)this).toString();
        }
        catch (Exception e) {
            throw new RuntimeException("failed to get " + ((Object)((Object)this)).getClass().getSimpleName() + "." + field, e);
        }
        return value;
    }
}

