/*
 * Decompiled with CFR 0.152.
 */
package bigboot.protocol.type;

import bigboot.protocol.type.HdfsBlockLocation;
import com.alibaba.jboot.google.flatbuffers.FlatBufferBuilder;
import com.alibaba.jboot.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class HdfsBlock
extends Table {
    public static HdfsBlock getRootAsHdfsBlock(ByteBuffer _bb) {
        return HdfsBlock.getRootAsHdfsBlock(_bb, new HdfsBlock());
    }

    public static HdfsBlock getRootAsHdfsBlock(ByteBuffer _bb, HdfsBlock obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.bb_pos = _i;
        this.bb = _bb;
    }

    public HdfsBlock __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public String InodeBlockKey() {
        int o = this.__offset(4);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer InodeBlockKeyAsByteBuffer() {
        return this.__vector_as_bytebuffer(4, 1);
    }

    public ByteBuffer InodeBlockKeyInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 4, 1);
    }

    public HdfsBlockLocation locations(int j) {
        return this.locations(new HdfsBlockLocation(), j);
    }

    public HdfsBlockLocation locations(HdfsBlockLocation obj, int j) {
        int o = this.__offset(6);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int locationsLength() {
        int o = this.__offset(6);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public long numBytes() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateNumBytes(long numBytes) {
        int o = this.__offset(8);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, numBytes);
            return true;
        }
        return false;
    }

    public long generationStamp() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateGenerationStamp(long generationStamp) {
        int o = this.__offset(10);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, generationStamp);
            return true;
        }
        return false;
    }

    public short replication() {
        int o = this.__offset(12);
        return o != 0 ? this.bb.getShort(o + this.bb_pos) : (short)0;
    }

    public boolean mutateReplication(short replication) {
        int o = this.__offset(12);
        if (o != 0) {
            this.bb.putShort(o + this.bb_pos, replication);
            return true;
        }
        return false;
    }

    public String ucFeature() {
        int o = this.__offset(14);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer ucFeatureAsByteBuffer() {
        return this.__vector_as_bytebuffer(14, 1);
    }

    public ByteBuffer ucFeatureInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 14, 1);
    }

    public long id() {
        int o = this.__offset(16);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateId(long id) {
        int o = this.__offset(16);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, id);
            return true;
        }
        return false;
    }

    public String parentInodeId() {
        int o = this.__offset(18);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer parentInodeIdAsByteBuffer() {
        return this.__vector_as_bytebuffer(18, 1);
    }

    public ByteBuffer parentInodeIdInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 18, 1);
    }

    public String fileName() {
        int o = this.__offset(20);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer fileNameAsByteBuffer() {
        return this.__vector_as_bytebuffer(20, 1);
    }

    public ByteBuffer fileNameInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 20, 1);
    }

    public String inodeId() {
        int o = this.__offset(22);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer inodeIdAsByteBuffer() {
        return this.__vector_as_bytebuffer(22, 1);
    }

    public ByteBuffer inodeIdInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 22, 1);
    }

    public static int createHdfsBlock(FlatBufferBuilder builder, int InodeBlockKeyOffset, int locationsOffset, long numBytes, long generationStamp, short replication, int ucFeatureOffset, long id, int parentInodeIdOffset, int fileNameOffset, int inodeIdOffset) {
        builder.startObject(10);
        HdfsBlock.addId(builder, id);
        HdfsBlock.addGenerationStamp(builder, generationStamp);
        HdfsBlock.addNumBytes(builder, numBytes);
        HdfsBlock.addInodeId(builder, inodeIdOffset);
        HdfsBlock.addFileName(builder, fileNameOffset);
        HdfsBlock.addParentInodeId(builder, parentInodeIdOffset);
        HdfsBlock.addUcFeature(builder, ucFeatureOffset);
        HdfsBlock.addLocations(builder, locationsOffset);
        HdfsBlock.addInodeBlockKey(builder, InodeBlockKeyOffset);
        HdfsBlock.addReplication(builder, replication);
        return HdfsBlock.endHdfsBlock(builder);
    }

    public static void startHdfsBlock(FlatBufferBuilder builder) {
        builder.startObject(10);
    }

    public static void addInodeBlockKey(FlatBufferBuilder builder, int InodeBlockKeyOffset) {
        builder.addOffset(0, InodeBlockKeyOffset, 0);
    }

    public static void addLocations(FlatBufferBuilder builder, int locationsOffset) {
        builder.addOffset(1, locationsOffset, 0);
    }

    public static int createLocationsVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startLocationsVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addNumBytes(FlatBufferBuilder builder, long numBytes) {
        builder.addLong(2, numBytes, 0L);
    }

    public static void addGenerationStamp(FlatBufferBuilder builder, long generationStamp) {
        builder.addLong(3, generationStamp, 0L);
    }

    public static void addReplication(FlatBufferBuilder builder, short replication) {
        builder.addShort(4, replication, 0);
    }

    public static void addUcFeature(FlatBufferBuilder builder, int ucFeatureOffset) {
        builder.addOffset(5, ucFeatureOffset, 0);
    }

    public static void addId(FlatBufferBuilder builder, long id) {
        builder.addLong(6, id, 0L);
    }

    public static void addParentInodeId(FlatBufferBuilder builder, int parentInodeIdOffset) {
        builder.addOffset(7, parentInodeIdOffset, 0);
    }

    public static void addFileName(FlatBufferBuilder builder, int fileNameOffset) {
        builder.addOffset(8, fileNameOffset, 0);
    }

    public static void addInodeId(FlatBufferBuilder builder, int inodeIdOffset) {
        builder.addOffset(9, inodeIdOffset, 0);
    }

    public static int endHdfsBlock(FlatBufferBuilder builder) {
        int o = builder.endObject();
        return o;
    }
}

