/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.buffer;

import com.aliyun.emr.buffer.SmartBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ChunkBuffer
extends SmartBuffer {
    private boolean isAlone;

    public ChunkBuffer(ByteBuffer buffer, boolean isAlone) {
        super(buffer);
        this.isAlone = isAlone;
    }

    public ChunkBuffer(ByteBuffer buffer) {
        this(buffer, true);
    }

    void setAlone(boolean isAlone) {
        this.isAlone = isAlone;
    }

    boolean isAlone() {
        return this.isAlone;
    }

    @Override
    public ByteBuffer release() {
        if (this.isAlone) {
            return super.release();
        }
        return null;
    }

    public int write(byte[] src) throws IOException {
        return this.write(src, 0, src.length);
    }

    public int write(byte[] src, int off, int len) throws IOException {
        int remaining = this.buffer().remaining();
        int nWrite = Math.min(remaining, len);
        if (nWrite > 0) {
            this.buffer().put(src, off, nWrite);
        }
        return nWrite;
    }

    public int read(byte[] dst, int off, int len) throws IOException {
        int remaining = this.buffer().remaining();
        int nRead = Math.min(remaining, len);
        if (nRead > 0) {
            this.buffer().get(dst, off, nRead);
        }
        return nRead;
    }

    public byte[] bufferedData() throws IOException {
        int remaining = this.buffer().remaining();
        byte[] data = new byte[remaining];
        this.read(data, 0, remaining);
        return data;
    }

    public int read(SmartBuffer dst) throws IOException {
        int nRead = this.buffer().remaining();
        this.buffer().put(dst.buffer());
        return nRead;
    }

    public int write(SmartBuffer src) throws IOException {
        int nWritten = src.buffer().remaining();
        this.buffer().put(src.buffer());
        return nWritten;
    }

    public void swap(ChunkBuffer other) throws IOException {
        ByteBuffer otherBuffer = other.buffer();
        other.setBuffer(this.buffer());
        this.setBuffer(otherBuffer);
    }

    public void swap(SmartBuffer other) throws IOException {
        ByteBuffer otherBuffer = other.buffer();
        other.setBuffer(this.buffer());
        this.setBuffer(otherBuffer);
    }
}

