/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.auth;

import com.aliyun.emr.fs.auth.AliyunCredentialsProvider;
import com.aliyun.emr.fs.auth.JindoCredentialsProvider;
import java.io.IOException;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;

public class CustomCredentialsProvider
extends JindoCredentialsProvider {
    public static final String NAME = "com.aliyun.emr.fs.auth.CustomCredentialsProvider";

    public CustomCredentialsProvider(@Nullable URI uri, Configuration conf, AliyunCredentialsProvider.CredentialType type) {
        super(uri, conf, type);
    }

    @Override
    public String getStsProviderUrl() throws IOException {
        String url;
        if (this.getType() == AliyunCredentialsProvider.CredentialType.OSS || this.getType() == AliyunCredentialsProvider.CredentialType.JFS) {
            url = this.getConf().get("aliyun.oss.provider.url");
        } else if (this.getType() == AliyunCredentialsProvider.CredentialType.OTS) {
            url = this.getConf().get("aliyun.ots.provider.url");
        } else {
            throw new IOException("Wrong credential type: " + this.getType().name());
        }
        return url;
    }

    @Override
    public JindoCredentialsProvider.CredentialsTokenFormat getTokenFormat() {
        return JindoCredentialsProvider.CredentialsTokenFormat.JSON;
    }
}

