/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.auth;

import com.aliyun.emr.fs.auth.AliyunCredentials;
import com.aliyun.emr.fs.auth.AliyunCredentialsProvider;
import com.aliyun.emr.fs.auth.AuthUtils;
import com.aliyun.emr.fs.auth.BasicCredentials;
import com.aliyun.emr.fs.auth.BasicSessionCredentials;
import com.aliyun.emr.fs.auth.NoAliyunCredentialsException;
import com.aliyun.emr.utils.StringUtils;
import java.io.IOException;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;

public class JindoCommonCredentialsProvider
implements AliyunCredentialsProvider {
    public static final String NAME = "com.aliyun.emr.fs.auth.JindoCommonCredentialsProvider";
    private final Configuration conf;

    public JindoCommonCredentialsProvider(@Nullable URI uri, Configuration conf, AliyunCredentialsProvider.CredentialType type) {
        this.conf = conf;
    }

    @Override
    public AliyunCredentials getCredentials() {
        try {
            String accessKeyId = AuthUtils.getPassword(this.conf, "jindo.common.accessKeyId", null, "");
            String accessKeySecret = AuthUtils.getPassword(this.conf, "jindo.common.accessKeySecret", null, "");
            String securityToken = AuthUtils.getPassword(this.conf, "jindo.common.securityToken", null, "");
            if (!StringUtils.isEmpty(accessKeyId) && !StringUtils.isEmpty(accessKeySecret)) {
                if (!StringUtils.isEmpty(securityToken)) {
                    return new BasicSessionCredentials(accessKeyId, accessKeySecret, securityToken);
                }
                return new BasicCredentials(accessKeyId, accessKeySecret);
            }
        }
        catch (IOException e) {
            throw new NoAliyunCredentialsException("JindoCommonCredentialsProvider", "Fail to get common credentials in the configuration");
        }
        throw new NoAliyunCredentialsException("JindoCommonCredentialsProvider", "Fail to get common credentials in the configuration");
    }

    @Override
    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

