/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.auth.delegation;

import com.aliyun.emr.fs.auth.MarshalledCredentials;
import com.aliyun.emr.fs.auth.delegation.AbstractOssTokenIdentifier;
import com.aliyun.emr.fs.auth.delegation.DelegationConstants;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.io.Text;

public class SessionTokenIdentifier
extends AbstractOssTokenIdentifier {
    private MarshalledCredentials marshalledCredentials = new MarshalledCredentials();

    public SessionTokenIdentifier() {
        super(DelegationConstants.SESSION_TOKEN_KIND);
    }

    protected SessionTokenIdentifier(Text kind) {
        super(kind);
    }

    public SessionTokenIdentifier(Text kind, Text owner, Text renewer, URI uri, MarshalledCredentials marshalledCredentials, String origin) {
        super(kind, uri, owner, renewer, origin);
        this.marshalledCredentials = marshalledCredentials;
    }

    public SessionTokenIdentifier(Text kind, Text owner, Text renewer, Text realUser, URI uri) {
        super(kind, owner, renewer, realUser, uri);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.marshalledCredentials.write(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.marshalledCredentials.readFields(in);
    }

    @Override
    public long getExpiryTime() {
        return this.marshalledCredentials.getExpiration();
    }

    public MarshalledCredentials getMarshalledCredentials() {
        return this.marshalledCredentials;
    }

    @Override
    public String toString() {
        return super.toString() + "; " + this.marshalledCredentials.toString();
    }
}

