/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.hdfs;

import com.alibaba.jboot.protocols.JniRequestWrapper;
import com.aliyun.emr.shade.google_guava.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsRules {
    public static final Logger LOG = LoggerFactory.getLogger(HdfsRules.class);
    private final String defaultRule;
    private final HashMap<String, String> rules;

    public HdfsRules(Configuration conf) {
        this.defaultRule = conf.get("fs.hdfs.cache.default.namespace", "local");
        this.rules = new HashMap();
        this.initHdfsRules(conf);
    }

    @VisibleForTesting
    String getDefaultRule() {
        return this.defaultRule;
    }

    private void initHdfsRules(Configuration conf) {
        this.loadDfsHdfsRuleByNamespace("none", conf.getStrings("fs.hdfs.cache.none.srcs"));
        this.loadDfsHdfsRuleByNamespace("local", conf.getStrings("fs.hdfs.cache.local.srcs"));
        Map customNsConf = conf.getPropsWithPrefix("fs.hdfs.cache.custom.namespace.srcs.");
        if (customNsConf != null && customNsConf.size() > 0) {
            for (String customNs : customNsConf.keySet()) {
                this.loadDfsHdfsRuleByNamespace(customNs, conf.getStrings("fs.hdfs.cache.custom.namespace.srcs." + customNs));
            }
        }
    }

    private void loadDfsHdfsRuleByNamespace(String namespace, String[] hdfsNameservices) {
        if (hdfsNameservices != null && hdfsNameservices.length > 0) {
            for (String ns : hdfsNameservices) {
                if (!ns.endsWith("/")) {
                    ns = ns + "/";
                }
                this.rules.putIfAbsent(ns, namespace);
            }
        }
    }

    public boolean needReadHdfs(String nameservice, String path, DFSInputStream in) {
        boolean hdfsd = this.needHdfs(nameservice);
        LOG.debug("StreamHdfs is {} for input, nameservice:{}, path:{}, size:{} .", new Object[]{hdfsd ? "enabled" : "skipped", nameservice, path, in.getFileLength()});
        return hdfsd;
    }

    public boolean needHdfs(String nameservice) {
        if (!nameservice.endsWith("/")) {
            nameservice = nameservice + "/";
        }
        if (this.rules.containsKey(nameservice)) {
            return !"none".equals(this.rules.get(nameservice));
        }
        return !"none".equals(this.defaultRule);
    }

    public String getHdfsNs(String namenodeUri) {
        String nsName = this.rules.get(namenodeUri.endsWith("/") ? namenodeUri : namenodeUri + "/");
        if (nsName == null || nsName.isEmpty()) {
            nsName = this.defaultRule;
        }
        if ("local".equals(nsName)) {
            nsName = JniRequestWrapper.CACHE_MODE_NS_NAME;
        } else if ("none".equals(nsName)) {
            throw new IllegalArgumentException("NONE Mode don't have Namespace.");
        }
        return nsName;
    }
}

