/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.hdfs;

import bigboot.protocol.type.FileletStatus;
import bigboot.protocol.type.InodeStatus;
import com.alibaba.jboot.JbootHdfsReader;
import com.alibaba.jboot.JbootHdfsWriter;
import com.alibaba.jboot.google.flatbuffers.FlatBufferBuilder;
import com.alibaba.jboot.google.flatbuffers.JbootFlatBufferBuilder;
import com.aliyun.emr.fs.hdfs.JindoHdfsStreamHook;
import java.io.Closeable;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.FileStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HdfsUtils {
    public static final Logger LOG = LoggerFactory.getLogger(HdfsUtils.class);

    public static ByteBuffer toFsBuffer(FileStatus fileStatus, String eTag) {
        JbootFlatBufferBuilder builder = new JbootFlatBufferBuilder();
        int locateOffset = builder.createString("");
        FlatBufferBuilder inodeBuilder = new FlatBufferBuilder();
        int attrOffset = inodeBuilder.createString("");
        int idOffset = inodeBuilder.createString("");
        int ownerOffset = inodeBuilder.createString("");
        int groupOffset = inodeBuilder.createString("");
        int fileNameOffset = inodeBuilder.createString(fileStatus.getPath().toString());
        int etagOffset = inodeBuilder.createString(eTag);
        int pidOffset = inodeBuilder.createString("");
        InodeStatus.startInodeStatus(inodeBuilder);
        InodeStatus.addFileId(inodeBuilder, idOffset);
        InodeStatus.addFileName(inodeBuilder, fileNameOffset);
        InodeStatus.addAttributes(inodeBuilder, attrOffset);
        InodeStatus.addParentId(inodeBuilder, pidOffset);
        InodeStatus.addOwner(inodeBuilder, ownerOffset);
        InodeStatus.addOwnerGroup(inodeBuilder, groupOffset);
        InodeStatus.addFileType(inodeBuilder, (byte)1);
        InodeStatus.addFileSize(inodeBuilder, fileStatus.getLen());
        InodeStatus.addMtime(inodeBuilder, fileStatus.getModificationTime());
        InodeStatus.addDirectChildrenLoaded(inodeBuilder, false);
        InodeStatus.addEtag(inodeBuilder, etagOffset);
        InodeStatus.addState(inodeBuilder, (byte)1);
        inodeBuilder.finish(InodeStatus.endInodeStatus(inodeBuilder));
        int inodeOff = builder.createString(inodeBuilder.dataBuffer());
        FileletStatus.startFileletStatus(builder);
        FileletStatus.addLocations(builder, locateOffset);
        FileletStatus.addInode(builder, inodeOff);
        builder.finish(FileletStatus.endFileletStatus(builder));
        ByteBuffer buffer = builder.dataBuffer();
        return buffer;
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeQuietly(JindoHdfsStreamHook hook) {
        try {
            if (hook != null) {
                hook.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeQuietly(JbootHdfsReader blockletReader) {
        try {
            if (blockletReader != null) {
                blockletReader.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeQuietly(JbootHdfsWriter blockletWriter) {
        try {
            if (blockletWriter != null) {
                blockletWriter.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

