/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.emr.fs.hdfs.task;

import com.alibaba.jboot.JbootHdfsWriter;
import com.aliyun.emr.fs.hdfs.HdfsUtils;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseStreamWriterAsyncTask
implements Runnable {
    public static final Logger LOG = LoggerFactory.getLogger(CloseStreamWriterAsyncTask.class);
    private JbootHdfsWriter writer;
    private String path;
    private long timeoutInSeconds;

    public CloseStreamWriterAsyncTask(JbootHdfsWriter writer, String path, long timeoutInSeconds) {
        this.path = path;
        this.writer = writer;
        this.timeoutInSeconds = timeoutInSeconds;
    }

    @Override
    public void run() {
        this.closeWriter(this.timeoutInSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeWriter(long timeoutInSeconds) {
        block7: {
            try {
                this.writer.getWriterLock().writeLock().tryLock(timeoutInSeconds, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                if (timeoutInSeconds <= 0L) break block7;
                LOG.debug("Close hdfs stream {} wait too long, would close stream.", (Object)this.path);
            }
        }
        try {
            this.writer.finalizeFile();
        }
        catch (Exception e) {
            LOG.debug("Failed to finalize file." + e.getMessage(), (Throwable)e);
        }
        finally {
            HdfsUtils.closeQuietly(this.writer);
            this.writer.getWriterLock().writeLock().unlock();
        }
    }
}

